/*
 * config.h - methods and constants for driver
 * This file is part of MySocials driver library
 *
 * Copyright (C) 2010 - MySocials team
 *
 * libfacebook library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libfacebook library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libfacebook library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _DRIVER_CONFIG_H_
#define _DRIVER_CONFIG_H_

/*settings*/
#define DRIVER_ID "facebook"
#define DRIVER_NAME "Facebook"

#define DRIVER_PIC "\
iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAAC3FBMVEUdLEsYIjwTJEIXJE4QJ1AX\
J0UeKEIcKFIUK04aKkgcKU4YK1oYLVYhKlsgLVIgLk4cLl4UMGQfLmQbMVUgMWEeM1clMVcgM10b\
NGkeNXEmNGskNmAeOGcqNlwkOFwgN3IiO2soO2AtPWknP28rP2QsPoEoQmwkQYMcRIsvQmgrQ3My\
Qm4rRG8uQnolRXopQ4w0RHAtRnEzRWssRokyRn0xR3g1R20qSX8vSm8uSIsmSpIxSnU3SXA9SWsx\
THE0Snw2SYIxSZM5S3ExTIk6THMrTZY3TX40T3QyT4U8TnQ3T3stUJMwT583UY8/UXg6Un4oVKI3\
U4oyU5wyVJc8VIBCU3s/U4Y6VJI9VYE4Voc6VY0zV5NEVX0/VoI2V5s+VpVFV347WYpBWIQ9WJBC\
WYY2WqRMWHs6XJlEW4dKW4NFXIlCXJU+XaE7YJc9X5xCX5FEXpZJX4xAYZ9BYqBLYY5GYpVDYqdC\
Y6FIYptBZJw7Zag9ZK5IZJdGZqRKZplNaZxJaahPaKJHaq9FarVKaqlWaoxCbapPa55Ma6pKbaVQ\
bJ9bbJVObq1Nb6dQbbJIca9Lb7pfbotPcapLcbZRcK9Rc6tUcrJLdbJUda5RdcBPd7VXdbVJeMJJ\
er1RebhfeKBod5VTe7pWecVOfMdUfLtbfLVhfLBYfcNaf8VUgcxggLppg7hxhKhhiMh4h6ZljMx9\
jKt5jbFpkNCFkKlulNV5lsVzmdqMl7F9m8p6ndGAnc15nt9yoeF+oNaDoNCWnrKUn7mRobOFotKC\
pNmSosGGpNOHpdSEp9yHqd+ZqLuMqdmOq9yJrOGQrd6Nr+WWrtmlrMGSr+Cirryfr86UseGQsuiW\
s+Snss2Tteugs9mctN+ktNSyus+xvcu6vs65wNa0xNe9xNq6yd3BytLAy+a6zufS093O19/a4efb\
5Ozi4+3j6Ovs6u7u7PDp7/Ht8vXv9Pf59/v1+v3+//wQFVc8AAAAAXRSTlMAQObYZgAABj1JREFU\
eNrNl7+THUcRxz/d0zOz896dZZ/4ZaqUUIopUSS4SpETKPgzSCgHZERkZPw98AcQEZE4cBWiMFW2\
MJKRdTqdfPfe7s7uEMzs3nt3KHAEG9y72p3vt3t6ur/dA//rR+rPxhL2TXB5N+xvCPzZg/e/seln\
T8/HRqDfPnEEihQk1K9GGIL02rwamlmgb2YHpq9fzGBAt03trXgDCAAn4AGGAGGoNDumbJlEkQDl\
zTUYyNaaVcQDASkBQMGPdMAcGF7+6tEPvKHTuL98+o8/PAfb7goC+v57AMU3uBqgHhidAswKL3//\
I3cYgRc/C3D5tGDg3A0+AKbVd5Yfhccf3TqjJwHAD+vZ2agGgQBx1vbSj3gY4fGvb5/Bl0WAwkJg\
hIpXPLpYj5E+byF/dOcQ/+xHobTIAWPwBPF163ggb4cAQ4zI+Ju7Ofanrc9gIwoOLHoCXqMHvI8S\
xQ+eQnKu+NeP7uD3zosVqR7gauCDesATGXDeLFv2gB9/fteBfcKPuEZAMULF+5E4+GQ5gcfjAf/D\
A2T56kU83Zy82jD4sWVPQBY8+aS45MF70FlrEpze4L/+JZbLm4sHYQhDuAq76kEIhAj4iKtGUSwr\
lo186Prv3pmGbX96ioYhZJYYWMOLw+OrZcPq58MAlM/uk3YiBQ+DuXVFUOCkmIkzWi4Dsb+tAniY\
HCUXtFaYAT7g8TIk7xWsgVn+HBJ4jTMlZRnwY1gICBEfSycohFkXoJvcBBwUUdlYVj9a9uGqELw1\
e4qPxfCKgUYAJ2scjgRQjRxnGfO2r9piQAIpnURDIeKmORzBDli62GNkD1Mc4/rRi2/4CLOzdfv9\
Y4Dv3VD9wjMBfPrxhB+TawSy7VjxAYi1Ihk+PN6C/2n75+yJjCJDq8biI9GUeIiWIjAX+e+SfGEw\
jb4SxI2XaBCxFQ0I3Z63EWSsabXCKywaGmcjRlURETq6rnPbk7c1hTeKRb/pwGD3GQ/O8AZRQaDD\
TVsKZW1cd56vYj9bev1FjUF4NTz77vZbEW1wihawzFu38E8fv/jyxXWNQZm3Gy4uL85O7kmHg4K1\
mty/zYMn71z019trWTUxKux2L9JpepdU1zigeyUUus2ayucy10S41Mh1SyTniEpKJBjHy5w66brk\
HHDvjwAfrgTjbztgx+5sxxU3krZRUkpAR46Rgf41goVWSPmgFjoA0g40cu4yBhbjivdekapzANXd\
wyfOI92elM7TLsbFA13gCoJVtJvc3eCdQMx9x54EV6ukkRJ0OWpzvPYKQzVjzEfVMGJMWE67Wi+2\
FF7HFsQI4LDc3VSyHhIEGM3I3T6xM+sx8KRERwTZVIm1RUzd7RhEAuRCnLo9Kfi2LNFlQ+p2zFpN\
Q0ek90fa4pgCjKq7rlaTtZVJQwngurasDgZSpDsWhC5XhjlObZoAUiJHKQFidd3FVkWWsWzdYQgM\
JgJZ+27n1vaet2KhmrdO+64sYmyluHIUhN5sPxHI26uUlmPsolio0dvMY4yrjN7JBOfp6XKeAmM0\
tzSuHC0QMaNDo7g1P9zkpiMWU0722bA+ZFtkPbaRxMgwU0wKkkUFBncrnefZyJAZsLy2zs12/PG7\
3sCcgGVbhEhByQcNTn5yAmUik8fXf4mbNc0+uO/JkKdSyORcSinAPM8534pEyX3OZNzZB7Y2lnv3\
Wp92ss6sbx3vXS1vne/dqy6im4czN/ljZoiAooqqqpZbDK2lzg+ZQWGmdXW32JVlwNXDOwV1sqwM\
rdWCQszLoCHQzIMqht2aUFonbMVum/ZmexOAZbWCuckc4ChHDBnE8np/WBpZs0+1r1isU7hzODma\
EMxWNT3xlaAABWFa3bejND7wwC/JZ8sHXbbmwOZqXclrQQN64IFMIkwi88qqMDCCn22CaRIpTqJM\
VQ50Rg8VbcZERJiQgJ1fDaCwu/p4RMCkCikMMYqpqkPtiEBRmBCDwvj5fg8KF59c/210VvuB1msC\
oNX8kSaLrXlq46eXf39Vz+35k834fa/UGxJ6c9kRKPD6PhQpAlcv60Ym5uHZ8yf/Wo7wvUcPv9Nx\
SgLclGRtTAfPQLs0TjvgDft/f/LX85s0Pbu/sSDtdCLW5nTqDhSYM33sgUxPz1V5cc7/x/Mfr27y\
8+dL/tMAAAAASUVORK5CYII="

#define TEST_AUTH_RESPONSE "https://www.facebook.com/connect/login_success.html#access_token=133410120012716|2.Y417pjPZqMDUtb408DykaQ__.86400.1297656000-100001502212382|B4s6Bi6D4Qn1E87pmi4MTyiFDG8&expires_in=87757"

#ifdef DEBUG
#  define CLIENT_ID "103762123041508" 
#else
#  define CLIENT_ID "133410120012716" 
#endif

/*user_relationships,friends_relationships,user_religion_politics,friends_religion_politics,user_religion_politics,friends_religion_politics,user_education_history,friends_education_history,*/
#define LOGIN_SUCCESS "^http[s]{,1}://www\\.facebook\\.com/connect/login_success\\.html.*"

#define AUTH_REQUEST "<Request class='settings' function='authorization'><Params/></Request>"

#define RESPONSE_EMPTY "<?xml version=\"1.0\"?><response></response>"

#define ERROR_HEAD "<error_response xmlns='http://api.facebook.com/1.0/' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://api.facebook.com/1.0/ http://api.facebook.com/1.0/facebook.xsd'>"

#define MSG_AUTH_ERROR \
ERROR_HEAD\
"<error_code>1"DRV_AUTH_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_AUTH_ERROR"</error_msg>"\
"</error_response>"

#define MSG_AUTH_CANCEL \
ERROR_HEAD\
"<error_code>1"DRV_AUTH_CANCEL_CODE"</error_code>"\
"<error_msg>"DRV_AUTH_CANCEL"</error_msg>"\
"</error_response>"


#define MSG_NETWORK_ERROR \
ERROR_HEAD\
"<error_code>1"DRV_NETW_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_NETW_ERROR"</error_msg>"\
"</error_response>"

#define MSG_NETWORK_SERVER_ERROR \
ERROR_HEAD\
"<error_code>1"DRV_SERVER_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_SERVER_ERROR"</error_msg>"\
"</error_response>"

#define MSG_INFO \
"<info_response>"\
"</info_response>"

#define MSG_SETTINGS_SAVED_ERROR \
ERROR_HEAD\
"<error_code>1"DRV_SETT_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_SETT_ERROR"</error_msg>"\
"</error_response>"

#define MSG_FILE_SAVE_ERROR \
ERROR_HEAD\
"<error_code>1"DRV_FILE_SAVE_ERROR_CODE"</error_code>"\
"<error_msg>"DRV_FILE_SAVE_ERROR"</error_msg>"\
"</error_response>"

#define NOT_USE_DEFAULT_WEBAUTH_PARSER
#define NOT_USE_DEFAULT_JSON_PARSER

#endif

