<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="SID"/>

<xsl:variable name="RESPONSE" select="'Response'"/>  
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="METHOD" select="document('requests.xml')//requests/request[@class != 'general']"/>  


<xsl:template match="/">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">settings</xsl:attribute>
        <xsl:attribute name="function">getListMethods</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:for-each select="$METHOD"> 
                <xsl:if test="@access_type = 'public'">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="class">
                            <xsl:value-of select="@class"/>
                        </xsl:attribute>
                        <xsl:attribute name="function">
                            <xsl:value-of select="@function"/>
                        </xsl:attribute>
                    </xsl:element>
                </xsl:if>
            </xsl:for-each>        
         </xsl:element>
    </xsl:element>
</xsl:template>

</xsl:stylesheet>
