<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="text"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>

<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_query_response/df:user">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">systemMessages</xsl:attribute>
        <xsl:attribute name="function">infoMessage</xsl:attribute>
        <xsl:element name="{$PARAMS}">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">moduleName</xsl:attribute>
                <xsl:text>facebook</xsl:text>
            </xsl:element> 
            <xsl:choose>
                <xsl:when test="/df:fql_query_response/df:user/df:is_app_user = '1'">
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:text>430</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:text>Authorization successful</xsl:text>
                    </xsl:element> 
	        </xsl:when>
                <xsl:otherwise>
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">code</xsl:attribute>
                        <xsl:text>431</xsl:text>
                    </xsl:element> 
                    <xsl:element name="{$STRING}">
                        <xsl:attribute name="name">text</xsl:attribute>
                        <xsl:text>Authorization failed</xsl:text>
                    </xsl:element> 
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
    </xsl:element>
</xsl:template>

</xsl:stylesheet>
