<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
		 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="xml"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_multiquery_response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getPhotoComments</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='owner']/df:fql_result_set/df:user/df:uid"/>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="quantity" select="count(/df:fql_multiquery_response/df:fql_result[df:name='comments']/df:fql_result_set/df:comment)"/>
                <xsl:variable name="full" select="/df:fql_multiquery_response/df:fql_result[df:name='owner']/df:fql_result_set/df:user/df:anon"/> 
                <xsl:variable name="ownerId" select="substring-before($full,' ')" />
                <xsl:variable name="full1" select="substring-after($full,' ')" />
                <xsl:variable name="albumId" select="substring-before($full1,' ')" />
                <xsl:variable name="full2" select="substring-after($full1,' ')" />
                <xsl:variable name="photoId" select="substring-before($full2,' ')" />
                <xsl:variable name="offset" select="substring-after($full2,' ')" />
                <xsl:attribute name="name">commentsList</xsl:attribute>

                <xsl:attribute name="from">
                    <xsl:if test="not(number($offset))">
                        <xsl:value-of select="'0'"/> 
                    </xsl:if>
                    <xsl:if test="number($offset)">
                        <xsl:value-of select="$offset"/> 
                    </xsl:if>                 
                </xsl:attribute>
                <xsl:attribute name="to">
                    <xsl:if test="not(number($offset))">
                        <xsl:value-of select="number($quantity)"/>
                    </xsl:if>
                    <xsl:if test="number($offset)">
                        <xsl:value-of select="number($offset) + number($quantity)"/>
                    </xsl:if>                
                </xsl:attribute>

                <xsl:attribute name="ownerId">
                    <xsl:text>fb</xsl:text>
                    <xsl:value-of select="$ownerId"/>
                </xsl:attribute>

                <xsl:attribute name="albumId">
                    <xsl:text>fb</xsl:text>
                    <xsl:value-of select="$albumId"/>
                </xsl:attribute>

                <xsl:attribute name="photoId">
                    <xsl:text>fb</xsl:text>
                    <xsl:value-of select="$photoId"/>
                </xsl:attribute>

                <xsl:apply-templates select="/df:fql_multiquery_response/df:fql_result[df:name='comments']/df:fql_result_set/df:comment"/>
            </xsl:element> 
        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="df:comment">
    <xsl:if test="df:id">
        <xsl:element name="{$STRUCT}">
            <xsl:attribute name="name">comment</xsl:attribute>
            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:id"/>
            </xsl:attribute>

            <xsl:element name="{$STRING}">
               <xsl:attribute name="name">SenderId</xsl:attribute>
                <xsl:text>fb</xsl:text>
               <xsl:value-of select="df:fromid"/>
            </xsl:element>

            <xsl:if test="df:fromid">
                <xsl:element name="{$STRING}">
                   <xsl:attribute name="name">SenderName</xsl:attribute>
                    <xsl:choose>
                        <xsl:when test="df:fromid != '0'">
                            <xsl:variable name="fromid" select="df:fromid" />
                            <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='senders']/df:fql_result_set/df:user[df:uid=$fromid]/df:name"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="df:username"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
            </xsl:if>
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Time</xsl:attribute>
                <xsl:value-of select="df:time"/>
            </xsl:element>

            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">Text</xsl:attribute>
                <xsl:value-of select="df:text"/>
            </xsl:element>

        </xsl:element>
    </xsl:if>
</xsl:template>
</xsl:stylesheet>
