/*
 * profile.h - methods and structs for work with profile data
 * This file is part of libfacebook library
 *
 * Copyright (C) 2010 - Kirill Kulakov
 *
 * libfacebook library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libfacebook library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libfacebook library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _PROFILE_H_
#define _PROFILE_H_

#include <glib.h>
#define DEBUG
#ifdef DEBUG
#define msa_debug(...) g_debug(__VA_ARGS__)
#define msa_warning(...) g_warning(__VA_ARGS__)
#else
#define msa_debug(...)
#define msa_warning(...)
#endif
/*
 * Struct contains all required data for profile. Data load from program and store during work time.
 */
struct ProfileData {
    gchar *id;
    gchar *login;
    gchar *password;
    gchar *remixmid;
    gchar *remixsid;
    gchar *secret;
    struct ProfileData *next;
};

/**
 * list of profiles.
 */
const struct ProfileData *profile_list;

/**
 * Create empty profile with id.
 *
 * @param id - string for identify current profile
 * @return new profile entity
 */
struct ProfileData *profile_create(gchar *id);

/**
 * remove selected profile
 *
 * @param data - pointer to selected profile
 */
void profile_remove(struct ProfileData *data);

/**
 * Find profile in list, contains selected id.
 *
 * @param id - string which profile contains
 * @return found profile entity or NULL
 */
const struct ProfileData *profile_get_by_id(gchar *id);

#endif
