<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
		 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="xml"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_multiquery_response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">messages</xsl:attribute>
        <xsl:attribute name="function">
            <xsl:choose>
                <xsl:when test="/df:fql_multiquery_response/df:fql_result[df:name='folder']/df:fql_result_set/df:mailbox_folder/df:folder_id = '1'">
                    <xsl:text>updateOutboxMessages</xsl:text>
	        </xsl:when>
                <xsl:otherwise>
                    <xsl:text>updateInboxMessages</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
	</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='from']/df:fql_result_set/df:user/df:uid"/>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
		<xsl:variable name="quantity" select="count(/df:fql_multiquery_response/df:fql_result[df:name='messages']/df:fql_result_set/df:message)"/>
		<xsl:variable name="offset" select="/df:fql_multiquery_response/df:fql_result[df:name='from']/df:fql_result_set/df:user/df:anon"/>
                <xsl:attribute name="name">messageList</xsl:attribute>
                <xsl:attribute name="from">
                    <xsl:value-of select="$offset"/>
                </xsl:attribute>
                <xsl:attribute name="to">
                    <xsl:value-of select="number($offset) + number($quantity)"/>
                </xsl:attribute>

<!--
                <xsl:attribute name="quantity">
                    <xsl:element name="{$REQUEST}">
                        <xsl:attribute name="class">messages</xsl:attribute>
                        <xsl:attribute name="function">getCountOfMessages</xsl:attribute>
                        <xsl:element name="{$PARAMS}">
                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">FolderId</xsl:attribute>
                                <xsl:text>0</xsl:text>
                            </xsl:element>
                        </xsl:element>
                    </xsl:element>
                </xsl:attribute>
-->
                <xsl:apply-templates select="/df:fql_multiquery_response/df:fql_result[df:name='messages']/df:fql_result_set/df:message"/>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="df:message">
    <xsl:variable name="thread" select="df:thread_id"/>
    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">message</xsl:attribute>
        <xsl:attribute name="id">
            <xsl:text>fb</xsl:text>
        <xsl:value-of select="df:message_id"/>
        </xsl:attribute>

        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">SenderId</xsl:attribute>
            <xsl:text>fb</xsl:text>
           <xsl:value-of select="df:author_id"/>
        </xsl:element>
	<xsl:for-each select="/df:fql_multiquery_response/df:fql_result[df:name='threads']/df:fql_result_set/df:thread[df:thread_id=$thread][1]/df:recipients/df:uid">
            <xsl:element name="{$STRING}">
                <xsl:attribute name="name">RecipientId</xsl:attribute>
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="."/>
            </xsl:element>
	</xsl:for-each>
<!-- Should be removed -->
<!--
        <xsl:element name="{$REQUEST}">
            <xsl:attribute name="class">profile</xsl:attribute>
            <xsl:attribute name="function">getName</xsl:attribute>
            <xsl:element name="{$PARAMS}">
                    <xsl:attribute name="id">
                    <xsl:text>fb</xsl:text>
                    <xsl:value-of select="df:author_id"/>
                    </xsl:attribute>
            </xsl:element>
        </xsl:element>
-->
        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">Time</xsl:attribute>
            <xsl:value-of select="df:created_time"/>
        </xsl:element>
        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">Title</xsl:attribute>
            <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='threads']/df:fql_result_set/df:thread[df:thread_id=$thread]/df:subject"/>
        </xsl:element>
<!--
        <xsl:element name="{$REQUEST}">
            <xsl:attribute name="class">messages</xsl:attribute>
            <xsl:attribute name="function">getTitleOfThread</xsl:attribute>
            <xsl:element name="{$PARAMS}">
                <xsl:element name="{$STRING}">
                    <xsl:attribute name="ThreadId">
                        <xsl:value-of select="df:thread_id"/>
                    </xsl:attribute>
                </xsl:element>
            </xsl:element>
        </xsl:element>
-->

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">Status</xsl:attribute>
            <xsl:choose>
                <xsl:when test="/df:fql_multiquery_response/df:fql_result[df:name='threads']/df:fql_result_set/df:thread[df:thread_id=$thread]/df:unread">
                    <xsl:value-of select="1 - number(/df:fql_multiquery_response/df:fql_result[df:name='threads']/df:fql_result_set/df:thread[df:thread_id=$thread]/df:unread)"/>
	        </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>


        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">Text</xsl:attribute>
            <xsl:value-of select="df:body"/>
        </xsl:element>

    </xsl:element>
</xsl:template>
</xsl:stylesheet>
