<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="xml" />
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  

<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_multiquery_response">
    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">friends</xsl:attribute>
        <xsl:attribute name="function">updateListFriends</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:attribute name="id">
                <xsl:text>fb</xsl:text>
                <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='from']/df:fql_result_set/df:user/df:uid"/>
            </xsl:attribute>

            <xsl:element name="{$ARRAY}">
		<xsl:variable name="quantity" select="count(/df:fql_multiquery_response/df:fql_result[df:name='friends']/df:fql_result_set/df:user)"/>
		<xsl:variable name="offset" select="/df:fql_multiquery_response/df:fql_result[df:name='from']/df:fql_result_set/df:user/df:anon"/>
                <xsl:attribute name="name">ContactList</xsl:attribute>
                <xsl:attribute name="from">
                    <xsl:value-of select="$offset"/>
                </xsl:attribute>
                <xsl:attribute name="to">
                    <xsl:value-of select="number($offset) + number($quantity)"/>
                </xsl:attribute>
                <xsl:apply-templates select="/df:fql_multiquery_response/df:fql_result[df:name='friends']/df:fql_result_set/df:user"/>
            </xsl:element> 
        </xsl:element> 
    </xsl:element> 
</xsl:template>


<xsl:template match="df:user">
    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">Contact</xsl:attribute>
        <xsl:attribute name="id">
            <xsl:text>fb</xsl:text>
        <xsl:value-of select="df:uid"/>
        </xsl:attribute>
        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">FirstName</xsl:attribute>
           <xsl:value-of select="df:first_name"/>
        </xsl:element>
        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">LastName</xsl:attribute>
            <xsl:value-of select="df:last_name"/>
        </xsl:element>
        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">FriendStatus</xsl:attribute>
            <xsl:choose>
                <xsl:when test="df:online_presence = 'active'">
                    <xsl:text>1</xsl:text>
		            </xsl:when>
                <xsl:when test="df:online_presence = 'idle'">
                    <xsl:text>1</xsl:text>
		            </xsl:when>
                <xsl:otherwise>
                    <xsl:text>0</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:element>
        <xsl:element name="{$IMG}">
            <xsl:attribute name="name">FriendImg</xsl:attribute>
            <xsl:attribute name="uri">
                <xsl:value-of select="df:pic"/>
            </xsl:attribute>
        </xsl:element>
    </xsl:element>
</xsl:template>
</xsl:stylesheet>
