<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
	 xmlns:df="http://api.facebook.com/1.0/" exclude-result-prefixes="df">
<xsl:output method="xml"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="URL" select="'url'"/>
<xsl:variable name="SIG" select="'sig'"/>
<xsl:variable name="INNER_REQUEST" select="'InnerRequest'"/>
<xsl:variable name="REQUEST" select="'Request'"/>
<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>

<xsl:variable name="FUNCTION" select="/Request/@function"/>  
<xsl:include href="errors.xsl"/>

<xsl:template match="/df:fql_multiquery_response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">photos</xsl:attribute>
        <xsl:attribute name="function">getAlbums</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:attribute name="name">albumList</xsl:attribute>
                <xsl:attribute name="quantity">
                    <xsl:value-of select="count(/df:fql_multiquery_response/df:fql_result[df:name='albums']/df:fql_result_set/df:album)"/>
                </xsl:attribute>
                <xsl:attribute name="ownerId">
                    <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='owner']/df:fql_result_set/df:user/df:uid"/>
                </xsl:attribute>

<xsl:for-each select="/df:fql_multiquery_response/df:fql_result[df:name='albums']/df:fql_result_set/df:album">

    <xsl:element name="{$STRUCT}">
        <xsl:attribute name="name">album</xsl:attribute>
        <xsl:attribute name="id">
            <xsl:text>fb</xsl:text>
        <xsl:value-of select="df:aid"/>
        </xsl:attribute>

 
        <xsl:element name="{$STRING}">
           <xsl:attribute name="name">title</xsl:attribute>
           <xsl:value-of select="df:name"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">description</xsl:attribute>
            <xsl:value-of select="df:description"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">ownerId</xsl:attribute>
            <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:owner"/>
        </xsl:element>

        <xsl:element name="{$STRING}">
            <xsl:attribute name="name">thumbId</xsl:attribute>
            <xsl:text>fb</xsl:text>
            <xsl:value-of select="df:cover_pid"/>
        </xsl:element>

        <xsl:if test="df:cover_pid">
            <xsl:if test="df:cover_pid != '0'">
            	  <xsl:variable name="current_aid" select="df:aid"/>
                <xsl:element name="{$IMG}">
                    <xsl:attribute name="name">albumImg</xsl:attribute>
                    <xsl:attribute name="uri">
                        <xsl:value-of select="/df:fql_multiquery_response/df:fql_result[df:name='covers']/df:fql_result_set/df:photo[df:aid=$current_aid]/df:src"/>
                    </xsl:attribute>
                </xsl:element>
<!--
                <xsl:element name="{$REQUEST}">
                    <xsl:attribute name="class">photos</xsl:attribute>
                    <xsl:attribute name="function">getUrlById</xsl:attribute>
                    <xsl:element name="{$PARAMS}">
                        <xsl:attribute name="id">
                            <xsl:text>fb</xsl:text>
                            <xsl:value-of select="df:owner"/>
                        </xsl:attribute>
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">albumId</xsl:attribute>
                            <xsl:text>fb</xsl:text>
                            <xsl:value-of select="df:aid"/>
                        </xsl:element>
                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">photoId</xsl:attribute>
                            <xsl:text>fb</xsl:text>
                            <xsl:value-of select="df:cover_pid"/>
                        </xsl:element>
                    </xsl:element>
                </xsl:element>
-->
            </xsl:if>
        </xsl:if>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">created</xsl:attribute>
            <xsl:value-of select="df:created"/>
        </xsl:element>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">updated</xsl:attribute>
            <xsl:value-of select="df:modified"/>
        </xsl:element>

        <xsl:element name="{$NUMBER}">
            <xsl:attribute name="name">size</xsl:attribute>
            <xsl:value-of select="df:size"/>
        </xsl:element>

    </xsl:element>
</xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>

