/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
#ifndef NoteStore_H
#define NoteStore_H

#include <TProcessor.h>
#include "NoteStore_types.h"

namespace evernote { namespace edam {

class NoteStoreIf {
 public:
  virtual ~NoteStoreIf() {}
  virtual void getSyncState(SyncState& _return, const std::string& authenticationToken) = 0;
  virtual void getSyncChunk(SyncChunk& _return, const std::string& authenticationToken, const int32_t afterUSN, const int32_t maxEntries, const bool fullSyncOnly) = 0;
  virtual void listNotebooks(std::vector<evernote::edam::Notebook> & _return, const std::string& authenticationToken) = 0;
  virtual void getNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void getDefaultNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken) = 0;
  virtual void createNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken, const evernote::edam::Notebook& notebook) = 0;
  virtual int32_t updateNotebook(const std::string& authenticationToken, const evernote::edam::Notebook& notebook) = 0;
  virtual int32_t expungeNotebook(const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void listTags(std::vector<evernote::edam::Tag> & _return, const std::string& authenticationToken) = 0;
  virtual void listTagsByNotebook(std::vector<evernote::edam::Tag> & _return, const std::string& authenticationToken, const evernote::edam::Guid& notebookGuid) = 0;
  virtual void getTag(evernote::edam::Tag& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void createTag(evernote::edam::Tag& _return, const std::string& authenticationToken, const evernote::edam::Tag& tag) = 0;
  virtual int32_t updateTag(const std::string& authenticationToken, const evernote::edam::Tag& tag) = 0;
  virtual void untagAll(const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual int32_t expungeTag(const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void listSearches(std::vector<evernote::edam::SavedSearch> & _return, const std::string& authenticationToken) = 0;
  virtual void getSearch(evernote::edam::SavedSearch& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void createSearch(evernote::edam::SavedSearch& _return, const std::string& authenticationToken, const evernote::edam::SavedSearch& search) = 0;
  virtual int32_t updateSearch(const std::string& authenticationToken, const evernote::edam::SavedSearch& search) = 0;
  virtual int32_t expungeSearch(const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void findNotes(NoteList& _return, const std::string& authenticationToken, const NoteFilter& filter, const int32_t offset, const int32_t maxNotes) = 0;
  virtual void findNoteCounts(NoteCollectionCounts& _return, const std::string& authenticationToken, const NoteFilter& filter, const bool withTrash) = 0;
  virtual void getNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withContent, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData) = 0;
  virtual void getNoteContent(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void getNoteSearchText(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void getNoteTagNames(std::vector<std::string> & _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void createNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Note& note) = 0;
  virtual void updateNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Note& note) = 0;
  virtual int32_t deleteNote(const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual int32_t expungeNote(const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual int32_t expungeNotes(const std::string& authenticationToken, const std::vector<evernote::edam::Guid> & noteGuids) = 0;
  virtual int32_t expungeInactiveNotes(const std::string& authenticationToken) = 0;
  virtual void copyNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const evernote::edam::Guid& toNotebookGuid) = 0;
  virtual void listNoteVersions(std::vector<NoteVersionId> & _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid) = 0;
  virtual void getNoteVersion(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const int32_t updateSequenceNum, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData) = 0;
  virtual void getResource(evernote::edam::Resource& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withData, const bool withRecognition, const bool withAttributes, const bool withAlternateData) = 0;
  virtual int32_t updateResource(const std::string& authenticationToken, const evernote::edam::Resource& resource) = 0;
  virtual void getResourceData(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void getResourceByHash(evernote::edam::Resource& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const std::string& contentHash, const bool withData, const bool withRecognition, const bool withAlternateData) = 0;
  virtual void getResourceRecognition(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void getResourceAlternateData(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual void getResourceAttributes(evernote::edam::ResourceAttributes& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) = 0;
  virtual int64_t getAccountSize(const std::string& authenticationToken) = 0;
  virtual void getAds(std::vector<evernote::edam::Ad> & _return, const std::string& authenticationToken, const AdParameters& adParameters) = 0;
  virtual void getRandomAd(evernote::edam::Ad& _return, const std::string& authenticationToken, const AdParameters& adParameters) = 0;
  virtual void getPublicNotebook(evernote::edam::Notebook& _return, const evernote::edam::UserID userId, const std::string& publicUri) = 0;
  virtual void createSharedNotebook(evernote::edam::SharedNotebook& _return, const std::string& authenticationToken, const evernote::edam::SharedNotebook& sharedNotebook) = 0;
  virtual void listSharedNotebooks(std::vector<evernote::edam::SharedNotebook> & _return, const std::string& authenticationToken) = 0;
  virtual int32_t expungeSharedNotebooks(const std::string& authenticationToken, const std::vector<int64_t> & sharedNotebookIds) = 0;
  virtual void createLinkedNotebook(evernote::edam::LinkedNotebook& _return, const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook) = 0;
  virtual void updateLinkedNotebook(evernote::edam::LinkedNotebook& _return, const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook) = 0;
  virtual void listLinkedNotebooks(std::vector<evernote::edam::LinkedNotebook> & _return, const std::string& authenticationToken) = 0;
  virtual int32_t expungeLinkedNotebook(const std::string& authenticationToken, const int64_t linkedNotebookId) = 0;
  virtual void authenticateToSharedNotebook(evernote::edam::AuthenticationResult& _return, const std::string& shareKey, const std::string& authenticationToken) = 0;
  virtual void getSharedNotebookByAuth(evernote::edam::SharedNotebook& _return, const std::string& authenticationToken) = 0;
  virtual void emailNote(const std::string& authenticationToken, const NoteEmailParameters& parameters) = 0;
};

class NoteStoreNull : virtual public NoteStoreIf {
 public:
  virtual ~NoteStoreNull() {}
  void getSyncState(SyncState& /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  void getSyncChunk(SyncChunk& /* _return */, const std::string& /* authenticationToken */, const int32_t /* afterUSN */, const int32_t /* maxEntries */, const bool /* fullSyncOnly */) {
    return;
  }
  void listNotebooks(std::vector<evernote::edam::Notebook> & /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  void getNotebook(evernote::edam::Notebook& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void getDefaultNotebook(evernote::edam::Notebook& /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  void createNotebook(evernote::edam::Notebook& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Notebook& /* notebook */) {
    return;
  }
  int32_t updateNotebook(const std::string& /* authenticationToken */, const evernote::edam::Notebook& /* notebook */) {
    int32_t _return = 0;
    return _return;
  }
  int32_t expungeNotebook(const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    int32_t _return = 0;
    return _return;
  }
  void listTags(std::vector<evernote::edam::Tag> & /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  void listTagsByNotebook(std::vector<evernote::edam::Tag> & /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* notebookGuid */) {
    return;
  }
  void getTag(evernote::edam::Tag& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void createTag(evernote::edam::Tag& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Tag& /* tag */) {
    return;
  }
  int32_t updateTag(const std::string& /* authenticationToken */, const evernote::edam::Tag& /* tag */) {
    int32_t _return = 0;
    return _return;
  }
  void untagAll(const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  int32_t expungeTag(const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    int32_t _return = 0;
    return _return;
  }
  void listSearches(std::vector<evernote::edam::SavedSearch> & /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  void getSearch(evernote::edam::SavedSearch& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void createSearch(evernote::edam::SavedSearch& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::SavedSearch& /* search */) {
    return;
  }
  int32_t updateSearch(const std::string& /* authenticationToken */, const evernote::edam::SavedSearch& /* search */) {
    int32_t _return = 0;
    return _return;
  }
  int32_t expungeSearch(const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    int32_t _return = 0;
    return _return;
  }
  void findNotes(NoteList& /* _return */, const std::string& /* authenticationToken */, const NoteFilter& /* filter */, const int32_t /* offset */, const int32_t /* maxNotes */) {
    return;
  }
  void findNoteCounts(NoteCollectionCounts& /* _return */, const std::string& /* authenticationToken */, const NoteFilter& /* filter */, const bool /* withTrash */) {
    return;
  }
  void getNote(evernote::edam::Note& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */, const bool /* withContent */, const bool /* withResourcesData */, const bool /* withResourcesRecognition */, const bool /* withResourcesAlternateData */) {
    return;
  }
  void getNoteContent(std::string& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void getNoteSearchText(std::string& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void getNoteTagNames(std::vector<std::string> & /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void createNote(evernote::edam::Note& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Note& /* note */) {
    return;
  }
  void updateNote(evernote::edam::Note& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Note& /* note */) {
    return;
  }
  int32_t deleteNote(const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    int32_t _return = 0;
    return _return;
  }
  int32_t expungeNote(const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    int32_t _return = 0;
    return _return;
  }
  int32_t expungeNotes(const std::string& /* authenticationToken */, const std::vector<evernote::edam::Guid> & /* noteGuids */) {
    int32_t _return = 0;
    return _return;
  }
  int32_t expungeInactiveNotes(const std::string& /* authenticationToken */) {
    int32_t _return = 0;
    return _return;
  }
  void copyNote(evernote::edam::Note& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* noteGuid */, const evernote::edam::Guid& /* toNotebookGuid */) {
    return;
  }
  void listNoteVersions(std::vector<NoteVersionId> & /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* noteGuid */) {
    return;
  }
  void getNoteVersion(evernote::edam::Note& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* noteGuid */, const int32_t /* updateSequenceNum */, const bool /* withResourcesData */, const bool /* withResourcesRecognition */, const bool /* withResourcesAlternateData */) {
    return;
  }
  void getResource(evernote::edam::Resource& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */, const bool /* withData */, const bool /* withRecognition */, const bool /* withAttributes */, const bool /* withAlternateData */) {
    return;
  }
  int32_t updateResource(const std::string& /* authenticationToken */, const evernote::edam::Resource& /* resource */) {
    int32_t _return = 0;
    return _return;
  }
  void getResourceData(std::string& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void getResourceByHash(evernote::edam::Resource& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* noteGuid */, const std::string& /* contentHash */, const bool /* withData */, const bool /* withRecognition */, const bool /* withAlternateData */) {
    return;
  }
  void getResourceRecognition(std::string& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void getResourceAlternateData(std::string& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  void getResourceAttributes(evernote::edam::ResourceAttributes& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::Guid& /* guid */) {
    return;
  }
  int64_t getAccountSize(const std::string& /* authenticationToken */) {
    int64_t _return = 0;
    return _return;
  }
  void getAds(std::vector<evernote::edam::Ad> & /* _return */, const std::string& /* authenticationToken */, const AdParameters& /* adParameters */) {
    return;
  }
  void getRandomAd(evernote::edam::Ad& /* _return */, const std::string& /* authenticationToken */, const AdParameters& /* adParameters */) {
    return;
  }
  void getPublicNotebook(evernote::edam::Notebook& /* _return */, const evernote::edam::UserID /* userId */, const std::string& /* publicUri */) {
    return;
  }
  void createSharedNotebook(evernote::edam::SharedNotebook& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::SharedNotebook& /* sharedNotebook */) {
    return;
  }
  void listSharedNotebooks(std::vector<evernote::edam::SharedNotebook> & /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  int32_t expungeSharedNotebooks(const std::string& /* authenticationToken */, const std::vector<int64_t> & /* sharedNotebookIds */) {
    int32_t _return = 0;
    return _return;
  }
  void createLinkedNotebook(evernote::edam::LinkedNotebook& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::LinkedNotebook& /* linkedNotebook */) {
    return;
  }
  void updateLinkedNotebook(evernote::edam::LinkedNotebook& /* _return */, const std::string& /* authenticationToken */, const evernote::edam::LinkedNotebook& /* linkedNotebook */) {
    return;
  }
  void listLinkedNotebooks(std::vector<evernote::edam::LinkedNotebook> & /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  int32_t expungeLinkedNotebook(const std::string& /* authenticationToken */, const int64_t /* linkedNotebookId */) {
    int32_t _return = 0;
    return _return;
  }
  void authenticateToSharedNotebook(evernote::edam::AuthenticationResult& /* _return */, const std::string& /* shareKey */, const std::string& /* authenticationToken */) {
    return;
  }
  void getSharedNotebookByAuth(evernote::edam::SharedNotebook& /* _return */, const std::string& /* authenticationToken */) {
    return;
  }
  void emailNote(const std::string& /* authenticationToken */, const NoteEmailParameters& /* parameters */) {
    return;
  }
};

class NoteStore_getSyncState_args {
 public:

  NoteStore_getSyncState_args() : authenticationToken("") {
  }

  virtual ~NoteStore_getSyncState_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_getSyncState_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSyncState_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSyncState_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSyncState_pargs {
 public:


  virtual ~NoteStore_getSyncState_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSyncState_result {
 public:

  NoteStore_getSyncState_result() {
  }

  virtual ~NoteStore_getSyncState_result() throw() {}

  SyncState success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getSyncState_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSyncState_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSyncState_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSyncState_presult {
 public:


  virtual ~NoteStore_getSyncState_presult() throw() {}

  SyncState* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getSyncChunk_args {
 public:

  NoteStore_getSyncChunk_args() : authenticationToken(""), afterUSN(0), maxEntries(0), fullSyncOnly(0) {
  }

  virtual ~NoteStore_getSyncChunk_args() throw() {}

  std::string authenticationToken;
  int32_t afterUSN;
  int32_t maxEntries;
  bool fullSyncOnly;

  struct __isset {
    __isset() : authenticationToken(false), afterUSN(false), maxEntries(false), fullSyncOnly(false) {}
    bool authenticationToken;
    bool afterUSN;
    bool maxEntries;
    bool fullSyncOnly;
  } __isset;

  bool operator == (const NoteStore_getSyncChunk_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(afterUSN == rhs.afterUSN))
      return false;
    if (!(maxEntries == rhs.maxEntries))
      return false;
    if (!(fullSyncOnly == rhs.fullSyncOnly))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSyncChunk_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSyncChunk_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSyncChunk_pargs {
 public:


  virtual ~NoteStore_getSyncChunk_pargs() throw() {}

  const std::string* authenticationToken;
  const int32_t* afterUSN;
  const int32_t* maxEntries;
  const bool* fullSyncOnly;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSyncChunk_result {
 public:

  NoteStore_getSyncChunk_result() {
  }

  virtual ~NoteStore_getSyncChunk_result() throw() {}

  SyncChunk success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getSyncChunk_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSyncChunk_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSyncChunk_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSyncChunk_presult {
 public:


  virtual ~NoteStore_getSyncChunk_presult() throw() {}

  SyncChunk* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listNotebooks_args {
 public:

  NoteStore_listNotebooks_args() : authenticationToken("") {
  }

  virtual ~NoteStore_listNotebooks_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_listNotebooks_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listNotebooks_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listNotebooks_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listNotebooks_pargs {
 public:


  virtual ~NoteStore_listNotebooks_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listNotebooks_result {
 public:

  NoteStore_listNotebooks_result() {
  }

  virtual ~NoteStore_listNotebooks_result() throw() {}

  std::vector<evernote::edam::Notebook>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_listNotebooks_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listNotebooks_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listNotebooks_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listNotebooks_presult {
 public:


  virtual ~NoteStore_listNotebooks_presult() throw() {}

  std::vector<evernote::edam::Notebook> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getNotebook_args {
 public:

  NoteStore_getNotebook_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNotebook_pargs {
 public:


  virtual ~NoteStore_getNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNotebook_result {
 public:

  NoteStore_getNotebook_result() {
  }

  virtual ~NoteStore_getNotebook_result() throw() {}

  evernote::edam::Notebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNotebook_presult {
 public:


  virtual ~NoteStore_getNotebook_presult() throw() {}

  evernote::edam::Notebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getDefaultNotebook_args {
 public:

  NoteStore_getDefaultNotebook_args() : authenticationToken("") {
  }

  virtual ~NoteStore_getDefaultNotebook_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_getDefaultNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getDefaultNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getDefaultNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getDefaultNotebook_pargs {
 public:


  virtual ~NoteStore_getDefaultNotebook_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getDefaultNotebook_result {
 public:

  NoteStore_getDefaultNotebook_result() {
  }

  virtual ~NoteStore_getDefaultNotebook_result() throw() {}

  evernote::edam::Notebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getDefaultNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getDefaultNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getDefaultNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getDefaultNotebook_presult {
 public:


  virtual ~NoteStore_getDefaultNotebook_presult() throw() {}

  evernote::edam::Notebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_createNotebook_args {
 public:

  NoteStore_createNotebook_args() : authenticationToken("") {
  }

  virtual ~NoteStore_createNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Notebook notebook;

  struct __isset {
    __isset() : authenticationToken(false), notebook(false) {}
    bool authenticationToken;
    bool notebook;
  } __isset;

  bool operator == (const NoteStore_createNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(notebook == rhs.notebook))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createNotebook_pargs {
 public:


  virtual ~NoteStore_createNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Notebook* notebook;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createNotebook_result {
 public:

  NoteStore_createNotebook_result() {
  }

  virtual ~NoteStore_createNotebook_result() throw() {}

  evernote::edam::Notebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_createNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createNotebook_presult {
 public:


  virtual ~NoteStore_createNotebook_presult() throw() {}

  evernote::edam::Notebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_updateNotebook_args {
 public:

  NoteStore_updateNotebook_args() : authenticationToken("") {
  }

  virtual ~NoteStore_updateNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Notebook notebook;

  struct __isset {
    __isset() : authenticationToken(false), notebook(false) {}
    bool authenticationToken;
    bool notebook;
  } __isset;

  bool operator == (const NoteStore_updateNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(notebook == rhs.notebook))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateNotebook_pargs {
 public:


  virtual ~NoteStore_updateNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Notebook* notebook;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateNotebook_result {
 public:

  NoteStore_updateNotebook_result() : success(0) {
  }

  virtual ~NoteStore_updateNotebook_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_updateNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateNotebook_presult {
 public:


  virtual ~NoteStore_updateNotebook_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeNotebook_args {
 public:

  NoteStore_expungeNotebook_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_expungeNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_expungeNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNotebook_pargs {
 public:


  virtual ~NoteStore_expungeNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNotebook_result {
 public:

  NoteStore_expungeNotebook_result() : success(0) {
  }

  virtual ~NoteStore_expungeNotebook_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_expungeNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNotebook_presult {
 public:


  virtual ~NoteStore_expungeNotebook_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listTags_args {
 public:

  NoteStore_listTags_args() : authenticationToken("") {
  }

  virtual ~NoteStore_listTags_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_listTags_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listTags_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listTags_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listTags_pargs {
 public:


  virtual ~NoteStore_listTags_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listTags_result {
 public:

  NoteStore_listTags_result() {
  }

  virtual ~NoteStore_listTags_result() throw() {}

  std::vector<evernote::edam::Tag>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_listTags_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listTags_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listTags_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listTags_presult {
 public:


  virtual ~NoteStore_listTags_presult() throw() {}

  std::vector<evernote::edam::Tag> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listTagsByNotebook_args {
 public:

  NoteStore_listTagsByNotebook_args() : authenticationToken(""), notebookGuid("") {
  }

  virtual ~NoteStore_listTagsByNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid notebookGuid;

  struct __isset {
    __isset() : authenticationToken(false), notebookGuid(false) {}
    bool authenticationToken;
    bool notebookGuid;
  } __isset;

  bool operator == (const NoteStore_listTagsByNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(notebookGuid == rhs.notebookGuid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listTagsByNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listTagsByNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listTagsByNotebook_pargs {
 public:


  virtual ~NoteStore_listTagsByNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* notebookGuid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listTagsByNotebook_result {
 public:

  NoteStore_listTagsByNotebook_result() {
  }

  virtual ~NoteStore_listTagsByNotebook_result() throw() {}

  std::vector<evernote::edam::Tag>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_listTagsByNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listTagsByNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listTagsByNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listTagsByNotebook_presult {
 public:


  virtual ~NoteStore_listTagsByNotebook_presult() throw() {}

  std::vector<evernote::edam::Tag> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getTag_args {
 public:

  NoteStore_getTag_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getTag_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getTag_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getTag_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getTag_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getTag_pargs {
 public:


  virtual ~NoteStore_getTag_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getTag_result {
 public:

  NoteStore_getTag_result() {
  }

  virtual ~NoteStore_getTag_result() throw() {}

  evernote::edam::Tag success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getTag_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getTag_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getTag_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getTag_presult {
 public:


  virtual ~NoteStore_getTag_presult() throw() {}

  evernote::edam::Tag* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_createTag_args {
 public:

  NoteStore_createTag_args() : authenticationToken("") {
  }

  virtual ~NoteStore_createTag_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Tag tag;

  struct __isset {
    __isset() : authenticationToken(false), tag(false) {}
    bool authenticationToken;
    bool tag;
  } __isset;

  bool operator == (const NoteStore_createTag_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(tag == rhs.tag))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createTag_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createTag_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createTag_pargs {
 public:


  virtual ~NoteStore_createTag_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Tag* tag;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createTag_result {
 public:

  NoteStore_createTag_result() {
  }

  virtual ~NoteStore_createTag_result() throw() {}

  evernote::edam::Tag success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_createTag_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createTag_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createTag_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createTag_presult {
 public:


  virtual ~NoteStore_createTag_presult() throw() {}

  evernote::edam::Tag* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_updateTag_args {
 public:

  NoteStore_updateTag_args() : authenticationToken("") {
  }

  virtual ~NoteStore_updateTag_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Tag tag;

  struct __isset {
    __isset() : authenticationToken(false), tag(false) {}
    bool authenticationToken;
    bool tag;
  } __isset;

  bool operator == (const NoteStore_updateTag_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(tag == rhs.tag))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateTag_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateTag_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateTag_pargs {
 public:


  virtual ~NoteStore_updateTag_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Tag* tag;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateTag_result {
 public:

  NoteStore_updateTag_result() : success(0) {
  }

  virtual ~NoteStore_updateTag_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_updateTag_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateTag_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateTag_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateTag_presult {
 public:


  virtual ~NoteStore_updateTag_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_untagAll_args {
 public:

  NoteStore_untagAll_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_untagAll_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_untagAll_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_untagAll_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_untagAll_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_untagAll_pargs {
 public:


  virtual ~NoteStore_untagAll_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_untagAll_result {
 public:

  NoteStore_untagAll_result() {
  }

  virtual ~NoteStore_untagAll_result() throw() {}

  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : userException(false), systemException(false), notFoundException(false) {}
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_untagAll_result & rhs) const
  {
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_untagAll_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_untagAll_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_untagAll_presult {
 public:


  virtual ~NoteStore_untagAll_presult() throw() {}

  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : userException(false), systemException(false), notFoundException(false) {}
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeTag_args {
 public:

  NoteStore_expungeTag_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_expungeTag_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_expungeTag_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeTag_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeTag_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeTag_pargs {
 public:


  virtual ~NoteStore_expungeTag_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeTag_result {
 public:

  NoteStore_expungeTag_result() : success(0) {
  }

  virtual ~NoteStore_expungeTag_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_expungeTag_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeTag_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeTag_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeTag_presult {
 public:


  virtual ~NoteStore_expungeTag_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listSearches_args {
 public:

  NoteStore_listSearches_args() : authenticationToken("") {
  }

  virtual ~NoteStore_listSearches_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_listSearches_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listSearches_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listSearches_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listSearches_pargs {
 public:


  virtual ~NoteStore_listSearches_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listSearches_result {
 public:

  NoteStore_listSearches_result() {
  }

  virtual ~NoteStore_listSearches_result() throw() {}

  std::vector<evernote::edam::SavedSearch>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_listSearches_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listSearches_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listSearches_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listSearches_presult {
 public:


  virtual ~NoteStore_listSearches_presult() throw() {}

  std::vector<evernote::edam::SavedSearch> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getSearch_args {
 public:

  NoteStore_getSearch_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getSearch_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getSearch_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSearch_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSearch_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSearch_pargs {
 public:


  virtual ~NoteStore_getSearch_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSearch_result {
 public:

  NoteStore_getSearch_result() {
  }

  virtual ~NoteStore_getSearch_result() throw() {}

  evernote::edam::SavedSearch success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getSearch_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSearch_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSearch_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSearch_presult {
 public:


  virtual ~NoteStore_getSearch_presult() throw() {}

  evernote::edam::SavedSearch* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_createSearch_args {
 public:

  NoteStore_createSearch_args() : authenticationToken("") {
  }

  virtual ~NoteStore_createSearch_args() throw() {}

  std::string authenticationToken;
  evernote::edam::SavedSearch search;

  struct __isset {
    __isset() : authenticationToken(false), search(false) {}
    bool authenticationToken;
    bool search;
  } __isset;

  bool operator == (const NoteStore_createSearch_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(search == rhs.search))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createSearch_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createSearch_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createSearch_pargs {
 public:


  virtual ~NoteStore_createSearch_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::SavedSearch* search;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createSearch_result {
 public:

  NoteStore_createSearch_result() {
  }

  virtual ~NoteStore_createSearch_result() throw() {}

  evernote::edam::SavedSearch success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_createSearch_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createSearch_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createSearch_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createSearch_presult {
 public:


  virtual ~NoteStore_createSearch_presult() throw() {}

  evernote::edam::SavedSearch* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_updateSearch_args {
 public:

  NoteStore_updateSearch_args() : authenticationToken("") {
  }

  virtual ~NoteStore_updateSearch_args() throw() {}

  std::string authenticationToken;
  evernote::edam::SavedSearch search;

  struct __isset {
    __isset() : authenticationToken(false), search(false) {}
    bool authenticationToken;
    bool search;
  } __isset;

  bool operator == (const NoteStore_updateSearch_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(search == rhs.search))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateSearch_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateSearch_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateSearch_pargs {
 public:


  virtual ~NoteStore_updateSearch_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::SavedSearch* search;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateSearch_result {
 public:

  NoteStore_updateSearch_result() : success(0) {
  }

  virtual ~NoteStore_updateSearch_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_updateSearch_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateSearch_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateSearch_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateSearch_presult {
 public:


  virtual ~NoteStore_updateSearch_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeSearch_args {
 public:

  NoteStore_expungeSearch_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_expungeSearch_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_expungeSearch_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeSearch_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeSearch_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeSearch_pargs {
 public:


  virtual ~NoteStore_expungeSearch_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeSearch_result {
 public:

  NoteStore_expungeSearch_result() : success(0) {
  }

  virtual ~NoteStore_expungeSearch_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_expungeSearch_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeSearch_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeSearch_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeSearch_presult {
 public:


  virtual ~NoteStore_expungeSearch_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_findNotes_args {
 public:

  NoteStore_findNotes_args() : authenticationToken(""), offset(0), maxNotes(0) {
  }

  virtual ~NoteStore_findNotes_args() throw() {}

  std::string authenticationToken;
  NoteFilter filter;
  int32_t offset;
  int32_t maxNotes;

  struct __isset {
    __isset() : authenticationToken(false), filter(false), offset(false), maxNotes(false) {}
    bool authenticationToken;
    bool filter;
    bool offset;
    bool maxNotes;
  } __isset;

  bool operator == (const NoteStore_findNotes_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(filter == rhs.filter))
      return false;
    if (!(offset == rhs.offset))
      return false;
    if (!(maxNotes == rhs.maxNotes))
      return false;
    return true;
  }
  bool operator != (const NoteStore_findNotes_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_findNotes_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_findNotes_pargs {
 public:


  virtual ~NoteStore_findNotes_pargs() throw() {}

  const std::string* authenticationToken;
  const NoteFilter* filter;
  const int32_t* offset;
  const int32_t* maxNotes;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_findNotes_result {
 public:

  NoteStore_findNotes_result() {
  }

  virtual ~NoteStore_findNotes_result() throw() {}

  NoteList success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_findNotes_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_findNotes_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_findNotes_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_findNotes_presult {
 public:


  virtual ~NoteStore_findNotes_presult() throw() {}

  NoteList* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_findNoteCounts_args {
 public:

  NoteStore_findNoteCounts_args() : authenticationToken(""), withTrash(0) {
  }

  virtual ~NoteStore_findNoteCounts_args() throw() {}

  std::string authenticationToken;
  NoteFilter filter;
  bool withTrash;

  struct __isset {
    __isset() : authenticationToken(false), filter(false), withTrash(false) {}
    bool authenticationToken;
    bool filter;
    bool withTrash;
  } __isset;

  bool operator == (const NoteStore_findNoteCounts_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(filter == rhs.filter))
      return false;
    if (!(withTrash == rhs.withTrash))
      return false;
    return true;
  }
  bool operator != (const NoteStore_findNoteCounts_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_findNoteCounts_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_findNoteCounts_pargs {
 public:


  virtual ~NoteStore_findNoteCounts_pargs() throw() {}

  const std::string* authenticationToken;
  const NoteFilter* filter;
  const bool* withTrash;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_findNoteCounts_result {
 public:

  NoteStore_findNoteCounts_result() {
  }

  virtual ~NoteStore_findNoteCounts_result() throw() {}

  NoteCollectionCounts success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_findNoteCounts_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_findNoteCounts_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_findNoteCounts_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_findNoteCounts_presult {
 public:


  virtual ~NoteStore_findNoteCounts_presult() throw() {}

  NoteCollectionCounts* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getNote_args {
 public:

  NoteStore_getNote_args() : authenticationToken(""), guid(""), withContent(0), withResourcesData(0), withResourcesRecognition(0), withResourcesAlternateData(0) {
  }

  virtual ~NoteStore_getNote_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;
  bool withContent;
  bool withResourcesData;
  bool withResourcesRecognition;
  bool withResourcesAlternateData;

  struct __isset {
    __isset() : authenticationToken(false), guid(false), withContent(false), withResourcesData(false), withResourcesRecognition(false), withResourcesAlternateData(false) {}
    bool authenticationToken;
    bool guid;
    bool withContent;
    bool withResourcesData;
    bool withResourcesRecognition;
    bool withResourcesAlternateData;
  } __isset;

  bool operator == (const NoteStore_getNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    if (!(withContent == rhs.withContent))
      return false;
    if (!(withResourcesData == rhs.withResourcesData))
      return false;
    if (!(withResourcesRecognition == rhs.withResourcesRecognition))
      return false;
    if (!(withResourcesAlternateData == rhs.withResourcesAlternateData))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNote_pargs {
 public:


  virtual ~NoteStore_getNote_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;
  const bool* withContent;
  const bool* withResourcesData;
  const bool* withResourcesRecognition;
  const bool* withResourcesAlternateData;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNote_result {
 public:

  NoteStore_getNote_result() {
  }

  virtual ~NoteStore_getNote_result() throw() {}

  evernote::edam::Note success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getNote_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNote_presult {
 public:


  virtual ~NoteStore_getNote_presult() throw() {}

  evernote::edam::Note* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getNoteContent_args {
 public:

  NoteStore_getNoteContent_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getNoteContent_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getNoteContent_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteContent_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteContent_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteContent_pargs {
 public:


  virtual ~NoteStore_getNoteContent_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteContent_result {
 public:

  NoteStore_getNoteContent_result() : success("") {
  }

  virtual ~NoteStore_getNoteContent_result() throw() {}

  std::string success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getNoteContent_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteContent_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteContent_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteContent_presult {
 public:


  virtual ~NoteStore_getNoteContent_presult() throw() {}

  std::string* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getNoteSearchText_args {
 public:

  NoteStore_getNoteSearchText_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getNoteSearchText_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getNoteSearchText_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteSearchText_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteSearchText_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteSearchText_pargs {
 public:


  virtual ~NoteStore_getNoteSearchText_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteSearchText_result {
 public:

  NoteStore_getNoteSearchText_result() : success("") {
  }

  virtual ~NoteStore_getNoteSearchText_result() throw() {}

  std::string success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getNoteSearchText_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteSearchText_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteSearchText_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteSearchText_presult {
 public:


  virtual ~NoteStore_getNoteSearchText_presult() throw() {}

  std::string* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getNoteTagNames_args {
 public:

  NoteStore_getNoteTagNames_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getNoteTagNames_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getNoteTagNames_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteTagNames_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteTagNames_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteTagNames_pargs {
 public:


  virtual ~NoteStore_getNoteTagNames_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteTagNames_result {
 public:

  NoteStore_getNoteTagNames_result() {
  }

  virtual ~NoteStore_getNoteTagNames_result() throw() {}

  std::vector<std::string>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getNoteTagNames_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteTagNames_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteTagNames_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteTagNames_presult {
 public:


  virtual ~NoteStore_getNoteTagNames_presult() throw() {}

  std::vector<std::string> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_createNote_args {
 public:

  NoteStore_createNote_args() : authenticationToken("") {
  }

  virtual ~NoteStore_createNote_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Note note;

  struct __isset {
    __isset() : authenticationToken(false), note(false) {}
    bool authenticationToken;
    bool note;
  } __isset;

  bool operator == (const NoteStore_createNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(note == rhs.note))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createNote_pargs {
 public:


  virtual ~NoteStore_createNote_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Note* note;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createNote_result {
 public:

  NoteStore_createNote_result() {
  }

  virtual ~NoteStore_createNote_result() throw() {}

  evernote::edam::Note success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_createNote_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createNote_presult {
 public:


  virtual ~NoteStore_createNote_presult() throw() {}

  evernote::edam::Note* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_updateNote_args {
 public:

  NoteStore_updateNote_args() : authenticationToken("") {
  }

  virtual ~NoteStore_updateNote_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Note note;

  struct __isset {
    __isset() : authenticationToken(false), note(false) {}
    bool authenticationToken;
    bool note;
  } __isset;

  bool operator == (const NoteStore_updateNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(note == rhs.note))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateNote_pargs {
 public:


  virtual ~NoteStore_updateNote_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Note* note;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateNote_result {
 public:

  NoteStore_updateNote_result() {
  }

  virtual ~NoteStore_updateNote_result() throw() {}

  evernote::edam::Note success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_updateNote_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateNote_presult {
 public:


  virtual ~NoteStore_updateNote_presult() throw() {}

  evernote::edam::Note* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_deleteNote_args {
 public:

  NoteStore_deleteNote_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_deleteNote_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_deleteNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_deleteNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_deleteNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_deleteNote_pargs {
 public:


  virtual ~NoteStore_deleteNote_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_deleteNote_result {
 public:

  NoteStore_deleteNote_result() : success(0) {
  }

  virtual ~NoteStore_deleteNote_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_deleteNote_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_deleteNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_deleteNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_deleteNote_presult {
 public:


  virtual ~NoteStore_deleteNote_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeNote_args {
 public:

  NoteStore_expungeNote_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_expungeNote_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_expungeNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNote_pargs {
 public:


  virtual ~NoteStore_expungeNote_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNote_result {
 public:

  NoteStore_expungeNote_result() : success(0) {
  }

  virtual ~NoteStore_expungeNote_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_expungeNote_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNote_presult {
 public:


  virtual ~NoteStore_expungeNote_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeNotes_args {
 public:

  NoteStore_expungeNotes_args() : authenticationToken("") {
  }

  virtual ~NoteStore_expungeNotes_args() throw() {}

  std::string authenticationToken;
  std::vector<evernote::edam::Guid>  noteGuids;

  struct __isset {
    __isset() : authenticationToken(false), noteGuids(false) {}
    bool authenticationToken;
    bool noteGuids;
  } __isset;

  bool operator == (const NoteStore_expungeNotes_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(noteGuids == rhs.noteGuids))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeNotes_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeNotes_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNotes_pargs {
 public:


  virtual ~NoteStore_expungeNotes_pargs() throw() {}

  const std::string* authenticationToken;
  const std::vector<evernote::edam::Guid> * noteGuids;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNotes_result {
 public:

  NoteStore_expungeNotes_result() : success(0) {
  }

  virtual ~NoteStore_expungeNotes_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_expungeNotes_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeNotes_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeNotes_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeNotes_presult {
 public:


  virtual ~NoteStore_expungeNotes_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeInactiveNotes_args {
 public:

  NoteStore_expungeInactiveNotes_args() : authenticationToken("") {
  }

  virtual ~NoteStore_expungeInactiveNotes_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_expungeInactiveNotes_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeInactiveNotes_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeInactiveNotes_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeInactiveNotes_pargs {
 public:


  virtual ~NoteStore_expungeInactiveNotes_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeInactiveNotes_result {
 public:

  NoteStore_expungeInactiveNotes_result() : success(0) {
  }

  virtual ~NoteStore_expungeInactiveNotes_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_expungeInactiveNotes_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeInactiveNotes_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeInactiveNotes_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeInactiveNotes_presult {
 public:


  virtual ~NoteStore_expungeInactiveNotes_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_copyNote_args {
 public:

  NoteStore_copyNote_args() : authenticationToken(""), noteGuid(""), toNotebookGuid("") {
  }

  virtual ~NoteStore_copyNote_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid noteGuid;
  evernote::edam::Guid toNotebookGuid;

  struct __isset {
    __isset() : authenticationToken(false), noteGuid(false), toNotebookGuid(false) {}
    bool authenticationToken;
    bool noteGuid;
    bool toNotebookGuid;
  } __isset;

  bool operator == (const NoteStore_copyNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(noteGuid == rhs.noteGuid))
      return false;
    if (!(toNotebookGuid == rhs.toNotebookGuid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_copyNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_copyNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_copyNote_pargs {
 public:


  virtual ~NoteStore_copyNote_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* noteGuid;
  const evernote::edam::Guid* toNotebookGuid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_copyNote_result {
 public:

  NoteStore_copyNote_result() {
  }

  virtual ~NoteStore_copyNote_result() throw() {}

  evernote::edam::Note success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_copyNote_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_copyNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_copyNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_copyNote_presult {
 public:


  virtual ~NoteStore_copyNote_presult() throw() {}

  evernote::edam::Note* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listNoteVersions_args {
 public:

  NoteStore_listNoteVersions_args() : authenticationToken(""), noteGuid("") {
  }

  virtual ~NoteStore_listNoteVersions_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid noteGuid;

  struct __isset {
    __isset() : authenticationToken(false), noteGuid(false) {}
    bool authenticationToken;
    bool noteGuid;
  } __isset;

  bool operator == (const NoteStore_listNoteVersions_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(noteGuid == rhs.noteGuid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listNoteVersions_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listNoteVersions_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listNoteVersions_pargs {
 public:


  virtual ~NoteStore_listNoteVersions_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* noteGuid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listNoteVersions_result {
 public:

  NoteStore_listNoteVersions_result() {
  }

  virtual ~NoteStore_listNoteVersions_result() throw() {}

  std::vector<NoteVersionId>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_listNoteVersions_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listNoteVersions_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listNoteVersions_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listNoteVersions_presult {
 public:


  virtual ~NoteStore_listNoteVersions_presult() throw() {}

  std::vector<NoteVersionId> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getNoteVersion_args {
 public:

  NoteStore_getNoteVersion_args() : authenticationToken(""), noteGuid(""), updateSequenceNum(0), withResourcesData(0), withResourcesRecognition(0), withResourcesAlternateData(0) {
  }

  virtual ~NoteStore_getNoteVersion_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid noteGuid;
  int32_t updateSequenceNum;
  bool withResourcesData;
  bool withResourcesRecognition;
  bool withResourcesAlternateData;

  struct __isset {
    __isset() : authenticationToken(false), noteGuid(false), updateSequenceNum(false), withResourcesData(false), withResourcesRecognition(false), withResourcesAlternateData(false) {}
    bool authenticationToken;
    bool noteGuid;
    bool updateSequenceNum;
    bool withResourcesData;
    bool withResourcesRecognition;
    bool withResourcesAlternateData;
  } __isset;

  bool operator == (const NoteStore_getNoteVersion_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(noteGuid == rhs.noteGuid))
      return false;
    if (!(updateSequenceNum == rhs.updateSequenceNum))
      return false;
    if (!(withResourcesData == rhs.withResourcesData))
      return false;
    if (!(withResourcesRecognition == rhs.withResourcesRecognition))
      return false;
    if (!(withResourcesAlternateData == rhs.withResourcesAlternateData))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteVersion_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteVersion_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteVersion_pargs {
 public:


  virtual ~NoteStore_getNoteVersion_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* noteGuid;
  const int32_t* updateSequenceNum;
  const bool* withResourcesData;
  const bool* withResourcesRecognition;
  const bool* withResourcesAlternateData;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteVersion_result {
 public:

  NoteStore_getNoteVersion_result() {
  }

  virtual ~NoteStore_getNoteVersion_result() throw() {}

  evernote::edam::Note success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getNoteVersion_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getNoteVersion_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getNoteVersion_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getNoteVersion_presult {
 public:


  virtual ~NoteStore_getNoteVersion_presult() throw() {}

  evernote::edam::Note* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getResource_args {
 public:

  NoteStore_getResource_args() : authenticationToken(""), guid(""), withData(0), withRecognition(0), withAttributes(0), withAlternateData(0) {
  }

  virtual ~NoteStore_getResource_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;
  bool withData;
  bool withRecognition;
  bool withAttributes;
  bool withAlternateData;

  struct __isset {
    __isset() : authenticationToken(false), guid(false), withData(false), withRecognition(false), withAttributes(false), withAlternateData(false) {}
    bool authenticationToken;
    bool guid;
    bool withData;
    bool withRecognition;
    bool withAttributes;
    bool withAlternateData;
  } __isset;

  bool operator == (const NoteStore_getResource_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    if (!(withData == rhs.withData))
      return false;
    if (!(withRecognition == rhs.withRecognition))
      return false;
    if (!(withAttributes == rhs.withAttributes))
      return false;
    if (!(withAlternateData == rhs.withAlternateData))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResource_pargs {
 public:


  virtual ~NoteStore_getResource_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;
  const bool* withData;
  const bool* withRecognition;
  const bool* withAttributes;
  const bool* withAlternateData;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResource_result {
 public:

  NoteStore_getResource_result() {
  }

  virtual ~NoteStore_getResource_result() throw() {}

  evernote::edam::Resource success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResource_presult {
 public:


  virtual ~NoteStore_getResource_presult() throw() {}

  evernote::edam::Resource* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_updateResource_args {
 public:

  NoteStore_updateResource_args() : authenticationToken("") {
  }

  virtual ~NoteStore_updateResource_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Resource resource;

  struct __isset {
    __isset() : authenticationToken(false), resource(false) {}
    bool authenticationToken;
    bool resource;
  } __isset;

  bool operator == (const NoteStore_updateResource_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(resource == rhs.resource))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateResource_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateResource_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateResource_pargs {
 public:


  virtual ~NoteStore_updateResource_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Resource* resource;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateResource_result {
 public:

  NoteStore_updateResource_result() : success(0) {
  }

  virtual ~NoteStore_updateResource_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_updateResource_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateResource_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateResource_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateResource_presult {
 public:


  virtual ~NoteStore_updateResource_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getResourceData_args {
 public:

  NoteStore_getResourceData_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getResourceData_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getResourceData_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceData_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceData_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceData_pargs {
 public:


  virtual ~NoteStore_getResourceData_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceData_result {
 public:

  NoteStore_getResourceData_result() : success("") {
  }

  virtual ~NoteStore_getResourceData_result() throw() {}

  std::string success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getResourceData_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceData_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceData_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceData_presult {
 public:


  virtual ~NoteStore_getResourceData_presult() throw() {}

  std::string* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getResourceByHash_args {
 public:

  NoteStore_getResourceByHash_args() : authenticationToken(""), noteGuid(""), contentHash(""), withData(0), withRecognition(0), withAlternateData(0) {
  }

  virtual ~NoteStore_getResourceByHash_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid noteGuid;
  std::string contentHash;
  bool withData;
  bool withRecognition;
  bool withAlternateData;

  struct __isset {
    __isset() : authenticationToken(false), noteGuid(false), contentHash(false), withData(false), withRecognition(false), withAlternateData(false) {}
    bool authenticationToken;
    bool noteGuid;
    bool contentHash;
    bool withData;
    bool withRecognition;
    bool withAlternateData;
  } __isset;

  bool operator == (const NoteStore_getResourceByHash_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(noteGuid == rhs.noteGuid))
      return false;
    if (!(contentHash == rhs.contentHash))
      return false;
    if (!(withData == rhs.withData))
      return false;
    if (!(withRecognition == rhs.withRecognition))
      return false;
    if (!(withAlternateData == rhs.withAlternateData))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceByHash_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceByHash_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceByHash_pargs {
 public:


  virtual ~NoteStore_getResourceByHash_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* noteGuid;
  const std::string* contentHash;
  const bool* withData;
  const bool* withRecognition;
  const bool* withAlternateData;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceByHash_result {
 public:

  NoteStore_getResourceByHash_result() {
  }

  virtual ~NoteStore_getResourceByHash_result() throw() {}

  evernote::edam::Resource success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getResourceByHash_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceByHash_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceByHash_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceByHash_presult {
 public:


  virtual ~NoteStore_getResourceByHash_presult() throw() {}

  evernote::edam::Resource* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getResourceRecognition_args {
 public:

  NoteStore_getResourceRecognition_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getResourceRecognition_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getResourceRecognition_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceRecognition_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceRecognition_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceRecognition_pargs {
 public:


  virtual ~NoteStore_getResourceRecognition_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceRecognition_result {
 public:

  NoteStore_getResourceRecognition_result() : success("") {
  }

  virtual ~NoteStore_getResourceRecognition_result() throw() {}

  std::string success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getResourceRecognition_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceRecognition_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceRecognition_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceRecognition_presult {
 public:


  virtual ~NoteStore_getResourceRecognition_presult() throw() {}

  std::string* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getResourceAlternateData_args {
 public:

  NoteStore_getResourceAlternateData_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getResourceAlternateData_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getResourceAlternateData_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceAlternateData_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceAlternateData_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceAlternateData_pargs {
 public:


  virtual ~NoteStore_getResourceAlternateData_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceAlternateData_result {
 public:

  NoteStore_getResourceAlternateData_result() : success("") {
  }

  virtual ~NoteStore_getResourceAlternateData_result() throw() {}

  std::string success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getResourceAlternateData_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceAlternateData_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceAlternateData_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceAlternateData_presult {
 public:


  virtual ~NoteStore_getResourceAlternateData_presult() throw() {}

  std::string* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getResourceAttributes_args {
 public:

  NoteStore_getResourceAttributes_args() : authenticationToken(""), guid("") {
  }

  virtual ~NoteStore_getResourceAttributes_args() throw() {}

  std::string authenticationToken;
  evernote::edam::Guid guid;

  struct __isset {
    __isset() : authenticationToken(false), guid(false) {}
    bool authenticationToken;
    bool guid;
  } __isset;

  bool operator == (const NoteStore_getResourceAttributes_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(guid == rhs.guid))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceAttributes_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceAttributes_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceAttributes_pargs {
 public:


  virtual ~NoteStore_getResourceAttributes_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::Guid* guid;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceAttributes_result {
 public:

  NoteStore_getResourceAttributes_result() {
  }

  virtual ~NoteStore_getResourceAttributes_result() throw() {}

  evernote::edam::ResourceAttributes success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getResourceAttributes_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getResourceAttributes_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getResourceAttributes_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getResourceAttributes_presult {
 public:


  virtual ~NoteStore_getResourceAttributes_presult() throw() {}

  evernote::edam::ResourceAttributes* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false), notFoundException(false) {}
    bool success;
    bool userException;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getAccountSize_args {
 public:

  NoteStore_getAccountSize_args() : authenticationToken("") {
  }

  virtual ~NoteStore_getAccountSize_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_getAccountSize_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getAccountSize_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getAccountSize_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getAccountSize_pargs {
 public:


  virtual ~NoteStore_getAccountSize_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getAccountSize_result {
 public:

  NoteStore_getAccountSize_result() : success(0) {
  }

  virtual ~NoteStore_getAccountSize_result() throw() {}

  int64_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getAccountSize_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getAccountSize_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getAccountSize_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getAccountSize_presult {
 public:


  virtual ~NoteStore_getAccountSize_presult() throw() {}

  int64_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getAds_args {
 public:

  NoteStore_getAds_args() : authenticationToken("") {
  }

  virtual ~NoteStore_getAds_args() throw() {}

  std::string authenticationToken;
  AdParameters adParameters;

  struct __isset {
    __isset() : authenticationToken(false), adParameters(false) {}
    bool authenticationToken;
    bool adParameters;
  } __isset;

  bool operator == (const NoteStore_getAds_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(adParameters == rhs.adParameters))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getAds_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getAds_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getAds_pargs {
 public:


  virtual ~NoteStore_getAds_pargs() throw() {}

  const std::string* authenticationToken;
  const AdParameters* adParameters;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getAds_result {
 public:

  NoteStore_getAds_result() {
  }

  virtual ~NoteStore_getAds_result() throw() {}

  std::vector<evernote::edam::Ad>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getAds_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getAds_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getAds_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getAds_presult {
 public:


  virtual ~NoteStore_getAds_presult() throw() {}

  std::vector<evernote::edam::Ad> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getRandomAd_args {
 public:

  NoteStore_getRandomAd_args() : authenticationToken("") {
  }

  virtual ~NoteStore_getRandomAd_args() throw() {}

  std::string authenticationToken;
  AdParameters adParameters;

  struct __isset {
    __isset() : authenticationToken(false), adParameters(false) {}
    bool authenticationToken;
    bool adParameters;
  } __isset;

  bool operator == (const NoteStore_getRandomAd_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(adParameters == rhs.adParameters))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getRandomAd_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getRandomAd_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getRandomAd_pargs {
 public:


  virtual ~NoteStore_getRandomAd_pargs() throw() {}

  const std::string* authenticationToken;
  const AdParameters* adParameters;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getRandomAd_result {
 public:

  NoteStore_getRandomAd_result() {
  }

  virtual ~NoteStore_getRandomAd_result() throw() {}

  evernote::edam::Ad success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getRandomAd_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getRandomAd_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getRandomAd_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getRandomAd_presult {
 public:


  virtual ~NoteStore_getRandomAd_presult() throw() {}

  evernote::edam::Ad* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), systemException(false) {}
    bool success;
    bool userException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getPublicNotebook_args {
 public:

  NoteStore_getPublicNotebook_args() : userId(0), publicUri("") {
  }

  virtual ~NoteStore_getPublicNotebook_args() throw() {}

  evernote::edam::UserID userId;
  std::string publicUri;

  struct __isset {
    __isset() : userId(false), publicUri(false) {}
    bool userId;
    bool publicUri;
  } __isset;

  bool operator == (const NoteStore_getPublicNotebook_args & rhs) const
  {
    if (!(userId == rhs.userId))
      return false;
    if (!(publicUri == rhs.publicUri))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getPublicNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getPublicNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getPublicNotebook_pargs {
 public:


  virtual ~NoteStore_getPublicNotebook_pargs() throw() {}

  const evernote::edam::UserID* userId;
  const std::string* publicUri;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getPublicNotebook_result {
 public:

  NoteStore_getPublicNotebook_result() {
  }

  virtual ~NoteStore_getPublicNotebook_result() throw() {}

  evernote::edam::Notebook success;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), systemException(false), notFoundException(false) {}
    bool success;
    bool systemException;
    bool notFoundException;
  } __isset;

  bool operator == (const NoteStore_getPublicNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getPublicNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getPublicNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getPublicNotebook_presult {
 public:


  virtual ~NoteStore_getPublicNotebook_presult() throw() {}

  evernote::edam::Notebook* success;
  evernote::edam::EDAMSystemException systemException;
  evernote::edam::EDAMNotFoundException notFoundException;

  struct __isset {
    __isset() : success(false), systemException(false), notFoundException(false) {}
    bool success;
    bool systemException;
    bool notFoundException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_createSharedNotebook_args {
 public:

  NoteStore_createSharedNotebook_args() : authenticationToken("") {
  }

  virtual ~NoteStore_createSharedNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::SharedNotebook sharedNotebook;

  struct __isset {
    __isset() : authenticationToken(false), sharedNotebook(false) {}
    bool authenticationToken;
    bool sharedNotebook;
  } __isset;

  bool operator == (const NoteStore_createSharedNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(sharedNotebook == rhs.sharedNotebook))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createSharedNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createSharedNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createSharedNotebook_pargs {
 public:


  virtual ~NoteStore_createSharedNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::SharedNotebook* sharedNotebook;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createSharedNotebook_result {
 public:

  NoteStore_createSharedNotebook_result() {
  }

  virtual ~NoteStore_createSharedNotebook_result() throw() {}

  evernote::edam::SharedNotebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_createSharedNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createSharedNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createSharedNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createSharedNotebook_presult {
 public:


  virtual ~NoteStore_createSharedNotebook_presult() throw() {}

  evernote::edam::SharedNotebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listSharedNotebooks_args {
 public:

  NoteStore_listSharedNotebooks_args() : authenticationToken("") {
  }

  virtual ~NoteStore_listSharedNotebooks_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_listSharedNotebooks_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listSharedNotebooks_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listSharedNotebooks_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listSharedNotebooks_pargs {
 public:


  virtual ~NoteStore_listSharedNotebooks_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listSharedNotebooks_result {
 public:

  NoteStore_listSharedNotebooks_result() {
  }

  virtual ~NoteStore_listSharedNotebooks_result() throw() {}

  std::vector<evernote::edam::SharedNotebook>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_listSharedNotebooks_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listSharedNotebooks_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listSharedNotebooks_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listSharedNotebooks_presult {
 public:


  virtual ~NoteStore_listSharedNotebooks_presult() throw() {}

  std::vector<evernote::edam::SharedNotebook> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeSharedNotebooks_args {
 public:

  NoteStore_expungeSharedNotebooks_args() : authenticationToken("") {
  }

  virtual ~NoteStore_expungeSharedNotebooks_args() throw() {}

  std::string authenticationToken;
  std::vector<int64_t>  sharedNotebookIds;

  struct __isset {
    __isset() : authenticationToken(false), sharedNotebookIds(false) {}
    bool authenticationToken;
    bool sharedNotebookIds;
  } __isset;

  bool operator == (const NoteStore_expungeSharedNotebooks_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(sharedNotebookIds == rhs.sharedNotebookIds))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeSharedNotebooks_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeSharedNotebooks_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeSharedNotebooks_pargs {
 public:


  virtual ~NoteStore_expungeSharedNotebooks_pargs() throw() {}

  const std::string* authenticationToken;
  const std::vector<int64_t> * sharedNotebookIds;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeSharedNotebooks_result {
 public:

  NoteStore_expungeSharedNotebooks_result() : success(0) {
  }

  virtual ~NoteStore_expungeSharedNotebooks_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_expungeSharedNotebooks_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeSharedNotebooks_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeSharedNotebooks_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeSharedNotebooks_presult {
 public:


  virtual ~NoteStore_expungeSharedNotebooks_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_createLinkedNotebook_args {
 public:

  NoteStore_createLinkedNotebook_args() : authenticationToken("") {
  }

  virtual ~NoteStore_createLinkedNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::LinkedNotebook linkedNotebook;

  struct __isset {
    __isset() : authenticationToken(false), linkedNotebook(false) {}
    bool authenticationToken;
    bool linkedNotebook;
  } __isset;

  bool operator == (const NoteStore_createLinkedNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(linkedNotebook == rhs.linkedNotebook))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createLinkedNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createLinkedNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createLinkedNotebook_pargs {
 public:


  virtual ~NoteStore_createLinkedNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::LinkedNotebook* linkedNotebook;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createLinkedNotebook_result {
 public:

  NoteStore_createLinkedNotebook_result() {
  }

  virtual ~NoteStore_createLinkedNotebook_result() throw() {}

  evernote::edam::LinkedNotebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_createLinkedNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_createLinkedNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_createLinkedNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_createLinkedNotebook_presult {
 public:


  virtual ~NoteStore_createLinkedNotebook_presult() throw() {}

  evernote::edam::LinkedNotebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_updateLinkedNotebook_args {
 public:

  NoteStore_updateLinkedNotebook_args() : authenticationToken("") {
  }

  virtual ~NoteStore_updateLinkedNotebook_args() throw() {}

  std::string authenticationToken;
  evernote::edam::LinkedNotebook linkedNotebook;

  struct __isset {
    __isset() : authenticationToken(false), linkedNotebook(false) {}
    bool authenticationToken;
    bool linkedNotebook;
  } __isset;

  bool operator == (const NoteStore_updateLinkedNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(linkedNotebook == rhs.linkedNotebook))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateLinkedNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateLinkedNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateLinkedNotebook_pargs {
 public:


  virtual ~NoteStore_updateLinkedNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const evernote::edam::LinkedNotebook* linkedNotebook;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateLinkedNotebook_result {
 public:

  NoteStore_updateLinkedNotebook_result() {
  }

  virtual ~NoteStore_updateLinkedNotebook_result() throw() {}

  evernote::edam::LinkedNotebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_updateLinkedNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_updateLinkedNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_updateLinkedNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_updateLinkedNotebook_presult {
 public:


  virtual ~NoteStore_updateLinkedNotebook_presult() throw() {}

  evernote::edam::LinkedNotebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_listLinkedNotebooks_args {
 public:

  NoteStore_listLinkedNotebooks_args() : authenticationToken("") {
  }

  virtual ~NoteStore_listLinkedNotebooks_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_listLinkedNotebooks_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listLinkedNotebooks_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listLinkedNotebooks_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listLinkedNotebooks_pargs {
 public:


  virtual ~NoteStore_listLinkedNotebooks_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listLinkedNotebooks_result {
 public:

  NoteStore_listLinkedNotebooks_result() {
  }

  virtual ~NoteStore_listLinkedNotebooks_result() throw() {}

  std::vector<evernote::edam::LinkedNotebook>  success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_listLinkedNotebooks_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_listLinkedNotebooks_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_listLinkedNotebooks_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_listLinkedNotebooks_presult {
 public:


  virtual ~NoteStore_listLinkedNotebooks_presult() throw() {}

  std::vector<evernote::edam::LinkedNotebook> * success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_expungeLinkedNotebook_args {
 public:

  NoteStore_expungeLinkedNotebook_args() : authenticationToken(""), linkedNotebookId(0) {
  }

  virtual ~NoteStore_expungeLinkedNotebook_args() throw() {}

  std::string authenticationToken;
  int64_t linkedNotebookId;

  struct __isset {
    __isset() : authenticationToken(false), linkedNotebookId(false) {}
    bool authenticationToken;
    bool linkedNotebookId;
  } __isset;

  bool operator == (const NoteStore_expungeLinkedNotebook_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(linkedNotebookId == rhs.linkedNotebookId))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeLinkedNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeLinkedNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeLinkedNotebook_pargs {
 public:


  virtual ~NoteStore_expungeLinkedNotebook_pargs() throw() {}

  const std::string* authenticationToken;
  const int64_t* linkedNotebookId;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeLinkedNotebook_result {
 public:

  NoteStore_expungeLinkedNotebook_result() : success(0) {
  }

  virtual ~NoteStore_expungeLinkedNotebook_result() throw() {}

  int32_t success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_expungeLinkedNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_expungeLinkedNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_expungeLinkedNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_expungeLinkedNotebook_presult {
 public:


  virtual ~NoteStore_expungeLinkedNotebook_presult() throw() {}

  int32_t* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_authenticateToSharedNotebook_args {
 public:

  NoteStore_authenticateToSharedNotebook_args() : shareKey(""), authenticationToken("") {
  }

  virtual ~NoteStore_authenticateToSharedNotebook_args() throw() {}

  std::string shareKey;
  std::string authenticationToken;

  struct __isset {
    __isset() : shareKey(false), authenticationToken(false) {}
    bool shareKey;
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_authenticateToSharedNotebook_args & rhs) const
  {
    if (!(shareKey == rhs.shareKey))
      return false;
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_authenticateToSharedNotebook_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_authenticateToSharedNotebook_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_authenticateToSharedNotebook_pargs {
 public:


  virtual ~NoteStore_authenticateToSharedNotebook_pargs() throw() {}

  const std::string* shareKey;
  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_authenticateToSharedNotebook_result {
 public:

  NoteStore_authenticateToSharedNotebook_result() {
  }

  virtual ~NoteStore_authenticateToSharedNotebook_result() throw() {}

  evernote::edam::AuthenticationResult success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_authenticateToSharedNotebook_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_authenticateToSharedNotebook_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_authenticateToSharedNotebook_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_authenticateToSharedNotebook_presult {
 public:


  virtual ~NoteStore_authenticateToSharedNotebook_presult() throw() {}

  evernote::edam::AuthenticationResult* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_getSharedNotebookByAuth_args {
 public:

  NoteStore_getSharedNotebookByAuth_args() : authenticationToken("") {
  }

  virtual ~NoteStore_getSharedNotebookByAuth_args() throw() {}

  std::string authenticationToken;

  struct __isset {
    __isset() : authenticationToken(false) {}
    bool authenticationToken;
  } __isset;

  bool operator == (const NoteStore_getSharedNotebookByAuth_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSharedNotebookByAuth_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSharedNotebookByAuth_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSharedNotebookByAuth_pargs {
 public:


  virtual ~NoteStore_getSharedNotebookByAuth_pargs() throw() {}

  const std::string* authenticationToken;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSharedNotebookByAuth_result {
 public:

  NoteStore_getSharedNotebookByAuth_result() {
  }

  virtual ~NoteStore_getSharedNotebookByAuth_result() throw() {}

  evernote::edam::SharedNotebook success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_getSharedNotebookByAuth_result & rhs) const
  {
    if (!(success == rhs.success))
      return false;
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_getSharedNotebookByAuth_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_getSharedNotebookByAuth_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_getSharedNotebookByAuth_presult {
 public:


  virtual ~NoteStore_getSharedNotebookByAuth_presult() throw() {}

  evernote::edam::SharedNotebook* success;
  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : success(false), userException(false), notFoundException(false), systemException(false) {}
    bool success;
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStore_emailNote_args {
 public:

  NoteStore_emailNote_args() : authenticationToken("") {
  }

  virtual ~NoteStore_emailNote_args() throw() {}

  std::string authenticationToken;
  NoteEmailParameters parameters;

  struct __isset {
    __isset() : authenticationToken(false), parameters(false) {}
    bool authenticationToken;
    bool parameters;
  } __isset;

  bool operator == (const NoteStore_emailNote_args & rhs) const
  {
    if (!(authenticationToken == rhs.authenticationToken))
      return false;
    if (!(parameters == rhs.parameters))
      return false;
    return true;
  }
  bool operator != (const NoteStore_emailNote_args &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_emailNote_args & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_emailNote_pargs {
 public:


  virtual ~NoteStore_emailNote_pargs() throw() {}

  const std::string* authenticationToken;
  const NoteEmailParameters* parameters;

  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_emailNote_result {
 public:

  NoteStore_emailNote_result() {
  }

  virtual ~NoteStore_emailNote_result() throw() {}

  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : userException(false), notFoundException(false), systemException(false) {}
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  bool operator == (const NoteStore_emailNote_result & rhs) const
  {
    if (!(userException == rhs.userException))
      return false;
    if (!(notFoundException == rhs.notFoundException))
      return false;
    if (!(systemException == rhs.systemException))
      return false;
    return true;
  }
  bool operator != (const NoteStore_emailNote_result &rhs) const {
    return !(*this == rhs);
  }

  bool operator < (const NoteStore_emailNote_result & ) const;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);
  uint32_t write(::apache::thrift::protocol::TProtocol* oprot) const;

};

class NoteStore_emailNote_presult {
 public:


  virtual ~NoteStore_emailNote_presult() throw() {}

  evernote::edam::EDAMUserException userException;
  evernote::edam::EDAMNotFoundException notFoundException;
  evernote::edam::EDAMSystemException systemException;

  struct __isset {
    __isset() : userException(false), notFoundException(false), systemException(false) {}
    bool userException;
    bool notFoundException;
    bool systemException;
  } __isset;

  uint32_t read(::apache::thrift::protocol::TProtocol* iprot);

};

class NoteStoreClient : virtual public NoteStoreIf {
 public:
  NoteStoreClient(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> prot) :
    piprot_(prot),
    poprot_(prot) {
    iprot_ = prot.get();
    oprot_ = prot.get();
  }
  NoteStoreClient(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> iprot, boost::shared_ptr< ::apache::thrift::protocol::TProtocol> oprot) :
    piprot_(iprot),
    poprot_(oprot) {
    iprot_ = iprot.get();
    oprot_ = oprot.get();
  }
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> getInputProtocol() {
    return piprot_;
  }
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> getOutputProtocol() {
    return poprot_;
  }
  void getSyncState(SyncState& _return, const std::string& authenticationToken);
  void send_getSyncState(const std::string& authenticationToken);
  void recv_getSyncState(SyncState& _return);
  void getSyncChunk(SyncChunk& _return, const std::string& authenticationToken, const int32_t afterUSN, const int32_t maxEntries, const bool fullSyncOnly);
  void send_getSyncChunk(const std::string& authenticationToken, const int32_t afterUSN, const int32_t maxEntries, const bool fullSyncOnly);
  void recv_getSyncChunk(SyncChunk& _return);
  void listNotebooks(std::vector<evernote::edam::Notebook> & _return, const std::string& authenticationToken);
  void send_listNotebooks(const std::string& authenticationToken);
  void recv_listNotebooks(std::vector<evernote::edam::Notebook> & _return);
  void getNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getNotebook(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getNotebook(evernote::edam::Notebook& _return);
  void getDefaultNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken);
  void send_getDefaultNotebook(const std::string& authenticationToken);
  void recv_getDefaultNotebook(evernote::edam::Notebook& _return);
  void createNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken, const evernote::edam::Notebook& notebook);
  void send_createNotebook(const std::string& authenticationToken, const evernote::edam::Notebook& notebook);
  void recv_createNotebook(evernote::edam::Notebook& _return);
  int32_t updateNotebook(const std::string& authenticationToken, const evernote::edam::Notebook& notebook);
  void send_updateNotebook(const std::string& authenticationToken, const evernote::edam::Notebook& notebook);
  int32_t recv_updateNotebook();
  int32_t expungeNotebook(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_expungeNotebook(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  int32_t recv_expungeNotebook();
  void listTags(std::vector<evernote::edam::Tag> & _return, const std::string& authenticationToken);
  void send_listTags(const std::string& authenticationToken);
  void recv_listTags(std::vector<evernote::edam::Tag> & _return);
  void listTagsByNotebook(std::vector<evernote::edam::Tag> & _return, const std::string& authenticationToken, const evernote::edam::Guid& notebookGuid);
  void send_listTagsByNotebook(const std::string& authenticationToken, const evernote::edam::Guid& notebookGuid);
  void recv_listTagsByNotebook(std::vector<evernote::edam::Tag> & _return);
  void getTag(evernote::edam::Tag& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getTag(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getTag(evernote::edam::Tag& _return);
  void createTag(evernote::edam::Tag& _return, const std::string& authenticationToken, const evernote::edam::Tag& tag);
  void send_createTag(const std::string& authenticationToken, const evernote::edam::Tag& tag);
  void recv_createTag(evernote::edam::Tag& _return);
  int32_t updateTag(const std::string& authenticationToken, const evernote::edam::Tag& tag);
  void send_updateTag(const std::string& authenticationToken, const evernote::edam::Tag& tag);
  int32_t recv_updateTag();
  void untagAll(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_untagAll(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_untagAll();
  int32_t expungeTag(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_expungeTag(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  int32_t recv_expungeTag();
  void listSearches(std::vector<evernote::edam::SavedSearch> & _return, const std::string& authenticationToken);
  void send_listSearches(const std::string& authenticationToken);
  void recv_listSearches(std::vector<evernote::edam::SavedSearch> & _return);
  void getSearch(evernote::edam::SavedSearch& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getSearch(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getSearch(evernote::edam::SavedSearch& _return);
  void createSearch(evernote::edam::SavedSearch& _return, const std::string& authenticationToken, const evernote::edam::SavedSearch& search);
  void send_createSearch(const std::string& authenticationToken, const evernote::edam::SavedSearch& search);
  void recv_createSearch(evernote::edam::SavedSearch& _return);
  int32_t updateSearch(const std::string& authenticationToken, const evernote::edam::SavedSearch& search);
  void send_updateSearch(const std::string& authenticationToken, const evernote::edam::SavedSearch& search);
  int32_t recv_updateSearch();
  int32_t expungeSearch(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_expungeSearch(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  int32_t recv_expungeSearch();
  void findNotes(NoteList& _return, const std::string& authenticationToken, const NoteFilter& filter, const int32_t offset, const int32_t maxNotes);
  void send_findNotes(const std::string& authenticationToken, const NoteFilter& filter, const int32_t offset, const int32_t maxNotes);
  void recv_findNotes(NoteList& _return);
  void findNoteCounts(NoteCollectionCounts& _return, const std::string& authenticationToken, const NoteFilter& filter, const bool withTrash);
  void send_findNoteCounts(const std::string& authenticationToken, const NoteFilter& filter, const bool withTrash);
  void recv_findNoteCounts(NoteCollectionCounts& _return);
  void getNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withContent, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData);
  void send_getNote(const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withContent, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData);
  void recv_getNote(evernote::edam::Note& _return);
  void getNoteContent(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getNoteContent(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getNoteContent(std::string& _return);
  void getNoteSearchText(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getNoteSearchText(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getNoteSearchText(std::string& _return);
  void getNoteTagNames(std::vector<std::string> & _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getNoteTagNames(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getNoteTagNames(std::vector<std::string> & _return);
  void createNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Note& note);
  void send_createNote(const std::string& authenticationToken, const evernote::edam::Note& note);
  void recv_createNote(evernote::edam::Note& _return);
  void updateNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Note& note);
  void send_updateNote(const std::string& authenticationToken, const evernote::edam::Note& note);
  void recv_updateNote(evernote::edam::Note& _return);
  int32_t deleteNote(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_deleteNote(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  int32_t recv_deleteNote();
  int32_t expungeNote(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_expungeNote(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  int32_t recv_expungeNote();
  int32_t expungeNotes(const std::string& authenticationToken, const std::vector<evernote::edam::Guid> & noteGuids);
  void send_expungeNotes(const std::string& authenticationToken, const std::vector<evernote::edam::Guid> & noteGuids);
  int32_t recv_expungeNotes();
  int32_t expungeInactiveNotes(const std::string& authenticationToken);
  void send_expungeInactiveNotes(const std::string& authenticationToken);
  int32_t recv_expungeInactiveNotes();
  void copyNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const evernote::edam::Guid& toNotebookGuid);
  void send_copyNote(const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const evernote::edam::Guid& toNotebookGuid);
  void recv_copyNote(evernote::edam::Note& _return);
  void listNoteVersions(std::vector<NoteVersionId> & _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid);
  void send_listNoteVersions(const std::string& authenticationToken, const evernote::edam::Guid& noteGuid);
  void recv_listNoteVersions(std::vector<NoteVersionId> & _return);
  void getNoteVersion(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const int32_t updateSequenceNum, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData);
  void send_getNoteVersion(const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const int32_t updateSequenceNum, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData);
  void recv_getNoteVersion(evernote::edam::Note& _return);
  void getResource(evernote::edam::Resource& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withData, const bool withRecognition, const bool withAttributes, const bool withAlternateData);
  void send_getResource(const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withData, const bool withRecognition, const bool withAttributes, const bool withAlternateData);
  void recv_getResource(evernote::edam::Resource& _return);
  int32_t updateResource(const std::string& authenticationToken, const evernote::edam::Resource& resource);
  void send_updateResource(const std::string& authenticationToken, const evernote::edam::Resource& resource);
  int32_t recv_updateResource();
  void getResourceData(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getResourceData(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getResourceData(std::string& _return);
  void getResourceByHash(evernote::edam::Resource& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const std::string& contentHash, const bool withData, const bool withRecognition, const bool withAlternateData);
  void send_getResourceByHash(const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const std::string& contentHash, const bool withData, const bool withRecognition, const bool withAlternateData);
  void recv_getResourceByHash(evernote::edam::Resource& _return);
  void getResourceRecognition(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getResourceRecognition(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getResourceRecognition(std::string& _return);
  void getResourceAlternateData(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getResourceAlternateData(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getResourceAlternateData(std::string& _return);
  void getResourceAttributes(evernote::edam::ResourceAttributes& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void send_getResourceAttributes(const std::string& authenticationToken, const evernote::edam::Guid& guid);
  void recv_getResourceAttributes(evernote::edam::ResourceAttributes& _return);
  int64_t getAccountSize(const std::string& authenticationToken);
  void send_getAccountSize(const std::string& authenticationToken);
  int64_t recv_getAccountSize();
  void getAds(std::vector<evernote::edam::Ad> & _return, const std::string& authenticationToken, const AdParameters& adParameters);
  void send_getAds(const std::string& authenticationToken, const AdParameters& adParameters);
  void recv_getAds(std::vector<evernote::edam::Ad> & _return);
  void getRandomAd(evernote::edam::Ad& _return, const std::string& authenticationToken, const AdParameters& adParameters);
  void send_getRandomAd(const std::string& authenticationToken, const AdParameters& adParameters);
  void recv_getRandomAd(evernote::edam::Ad& _return);
  void getPublicNotebook(evernote::edam::Notebook& _return, const evernote::edam::UserID userId, const std::string& publicUri);
  void send_getPublicNotebook(const evernote::edam::UserID userId, const std::string& publicUri);
  void recv_getPublicNotebook(evernote::edam::Notebook& _return);
  void createSharedNotebook(evernote::edam::SharedNotebook& _return, const std::string& authenticationToken, const evernote::edam::SharedNotebook& sharedNotebook);
  void send_createSharedNotebook(const std::string& authenticationToken, const evernote::edam::SharedNotebook& sharedNotebook);
  void recv_createSharedNotebook(evernote::edam::SharedNotebook& _return);
  void listSharedNotebooks(std::vector<evernote::edam::SharedNotebook> & _return, const std::string& authenticationToken);
  void send_listSharedNotebooks(const std::string& authenticationToken);
  void recv_listSharedNotebooks(std::vector<evernote::edam::SharedNotebook> & _return);
  int32_t expungeSharedNotebooks(const std::string& authenticationToken, const std::vector<int64_t> & sharedNotebookIds);
  void send_expungeSharedNotebooks(const std::string& authenticationToken, const std::vector<int64_t> & sharedNotebookIds);
  int32_t recv_expungeSharedNotebooks();
  void createLinkedNotebook(evernote::edam::LinkedNotebook& _return, const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook);
  void send_createLinkedNotebook(const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook);
  void recv_createLinkedNotebook(evernote::edam::LinkedNotebook& _return);
  void updateLinkedNotebook(evernote::edam::LinkedNotebook& _return, const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook);
  void send_updateLinkedNotebook(const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook);
  void recv_updateLinkedNotebook(evernote::edam::LinkedNotebook& _return);
  void listLinkedNotebooks(std::vector<evernote::edam::LinkedNotebook> & _return, const std::string& authenticationToken);
  void send_listLinkedNotebooks(const std::string& authenticationToken);
  void recv_listLinkedNotebooks(std::vector<evernote::edam::LinkedNotebook> & _return);
  int32_t expungeLinkedNotebook(const std::string& authenticationToken, const int64_t linkedNotebookId);
  void send_expungeLinkedNotebook(const std::string& authenticationToken, const int64_t linkedNotebookId);
  int32_t recv_expungeLinkedNotebook();
  void authenticateToSharedNotebook(evernote::edam::AuthenticationResult& _return, const std::string& shareKey, const std::string& authenticationToken);
  void send_authenticateToSharedNotebook(const std::string& shareKey, const std::string& authenticationToken);
  void recv_authenticateToSharedNotebook(evernote::edam::AuthenticationResult& _return);
  void getSharedNotebookByAuth(evernote::edam::SharedNotebook& _return, const std::string& authenticationToken);
  void send_getSharedNotebookByAuth(const std::string& authenticationToken);
  void recv_getSharedNotebookByAuth(evernote::edam::SharedNotebook& _return);
  void emailNote(const std::string& authenticationToken, const NoteEmailParameters& parameters);
  void send_emailNote(const std::string& authenticationToken, const NoteEmailParameters& parameters);
  void recv_emailNote();
 protected:
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> piprot_;
  boost::shared_ptr< ::apache::thrift::protocol::TProtocol> poprot_;
  ::apache::thrift::protocol::TProtocol* iprot_;
  ::apache::thrift::protocol::TProtocol* oprot_;
};

class NoteStoreProcessor : virtual public ::apache::thrift::TProcessor {
 protected:
  boost::shared_ptr<NoteStoreIf> iface_;
  virtual bool process_fn(::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot, std::string& fname, int32_t seqid);
 private:
  std::map<std::string, void (NoteStoreProcessor::*)(int32_t, ::apache::thrift::protocol::TProtocol*, ::apache::thrift::protocol::TProtocol*)> processMap_;
  void process_getSyncState(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getSyncChunk(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listNotebooks(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getDefaultNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_createNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_updateNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listTags(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listTagsByNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getTag(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_createTag(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_updateTag(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_untagAll(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeTag(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listSearches(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getSearch(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_createSearch(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_updateSearch(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeSearch(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_findNotes(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_findNoteCounts(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getNoteContent(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getNoteSearchText(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getNoteTagNames(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_createNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_updateNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_deleteNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeNotes(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeInactiveNotes(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_copyNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listNoteVersions(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getNoteVersion(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getResource(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_updateResource(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getResourceData(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getResourceByHash(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getResourceRecognition(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getResourceAlternateData(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getResourceAttributes(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getAccountSize(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getAds(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getRandomAd(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getPublicNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_createSharedNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listSharedNotebooks(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeSharedNotebooks(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_createLinkedNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_updateLinkedNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_listLinkedNotebooks(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_expungeLinkedNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_authenticateToSharedNotebook(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_getSharedNotebookByAuth(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
  void process_emailNote(int32_t seqid, ::apache::thrift::protocol::TProtocol* iprot, ::apache::thrift::protocol::TProtocol* oprot);
 public:
  NoteStoreProcessor(boost::shared_ptr<NoteStoreIf> iface) :
    iface_(iface) {
    processMap_["getSyncState"] = &NoteStoreProcessor::process_getSyncState;
    processMap_["getSyncChunk"] = &NoteStoreProcessor::process_getSyncChunk;
    processMap_["listNotebooks"] = &NoteStoreProcessor::process_listNotebooks;
    processMap_["getNotebook"] = &NoteStoreProcessor::process_getNotebook;
    processMap_["getDefaultNotebook"] = &NoteStoreProcessor::process_getDefaultNotebook;
    processMap_["createNotebook"] = &NoteStoreProcessor::process_createNotebook;
    processMap_["updateNotebook"] = &NoteStoreProcessor::process_updateNotebook;
    processMap_["expungeNotebook"] = &NoteStoreProcessor::process_expungeNotebook;
    processMap_["listTags"] = &NoteStoreProcessor::process_listTags;
    processMap_["listTagsByNotebook"] = &NoteStoreProcessor::process_listTagsByNotebook;
    processMap_["getTag"] = &NoteStoreProcessor::process_getTag;
    processMap_["createTag"] = &NoteStoreProcessor::process_createTag;
    processMap_["updateTag"] = &NoteStoreProcessor::process_updateTag;
    processMap_["untagAll"] = &NoteStoreProcessor::process_untagAll;
    processMap_["expungeTag"] = &NoteStoreProcessor::process_expungeTag;
    processMap_["listSearches"] = &NoteStoreProcessor::process_listSearches;
    processMap_["getSearch"] = &NoteStoreProcessor::process_getSearch;
    processMap_["createSearch"] = &NoteStoreProcessor::process_createSearch;
    processMap_["updateSearch"] = &NoteStoreProcessor::process_updateSearch;
    processMap_["expungeSearch"] = &NoteStoreProcessor::process_expungeSearch;
    processMap_["findNotes"] = &NoteStoreProcessor::process_findNotes;
    processMap_["findNoteCounts"] = &NoteStoreProcessor::process_findNoteCounts;
    processMap_["getNote"] = &NoteStoreProcessor::process_getNote;
    processMap_["getNoteContent"] = &NoteStoreProcessor::process_getNoteContent;
    processMap_["getNoteSearchText"] = &NoteStoreProcessor::process_getNoteSearchText;
    processMap_["getNoteTagNames"] = &NoteStoreProcessor::process_getNoteTagNames;
    processMap_["createNote"] = &NoteStoreProcessor::process_createNote;
    processMap_["updateNote"] = &NoteStoreProcessor::process_updateNote;
    processMap_["deleteNote"] = &NoteStoreProcessor::process_deleteNote;
    processMap_["expungeNote"] = &NoteStoreProcessor::process_expungeNote;
    processMap_["expungeNotes"] = &NoteStoreProcessor::process_expungeNotes;
    processMap_["expungeInactiveNotes"] = &NoteStoreProcessor::process_expungeInactiveNotes;
    processMap_["copyNote"] = &NoteStoreProcessor::process_copyNote;
    processMap_["listNoteVersions"] = &NoteStoreProcessor::process_listNoteVersions;
    processMap_["getNoteVersion"] = &NoteStoreProcessor::process_getNoteVersion;
    processMap_["getResource"] = &NoteStoreProcessor::process_getResource;
    processMap_["updateResource"] = &NoteStoreProcessor::process_updateResource;
    processMap_["getResourceData"] = &NoteStoreProcessor::process_getResourceData;
    processMap_["getResourceByHash"] = &NoteStoreProcessor::process_getResourceByHash;
    processMap_["getResourceRecognition"] = &NoteStoreProcessor::process_getResourceRecognition;
    processMap_["getResourceAlternateData"] = &NoteStoreProcessor::process_getResourceAlternateData;
    processMap_["getResourceAttributes"] = &NoteStoreProcessor::process_getResourceAttributes;
    processMap_["getAccountSize"] = &NoteStoreProcessor::process_getAccountSize;
    processMap_["getAds"] = &NoteStoreProcessor::process_getAds;
    processMap_["getRandomAd"] = &NoteStoreProcessor::process_getRandomAd;
    processMap_["getPublicNotebook"] = &NoteStoreProcessor::process_getPublicNotebook;
    processMap_["createSharedNotebook"] = &NoteStoreProcessor::process_createSharedNotebook;
    processMap_["listSharedNotebooks"] = &NoteStoreProcessor::process_listSharedNotebooks;
    processMap_["expungeSharedNotebooks"] = &NoteStoreProcessor::process_expungeSharedNotebooks;
    processMap_["createLinkedNotebook"] = &NoteStoreProcessor::process_createLinkedNotebook;
    processMap_["updateLinkedNotebook"] = &NoteStoreProcessor::process_updateLinkedNotebook;
    processMap_["listLinkedNotebooks"] = &NoteStoreProcessor::process_listLinkedNotebooks;
    processMap_["expungeLinkedNotebook"] = &NoteStoreProcessor::process_expungeLinkedNotebook;
    processMap_["authenticateToSharedNotebook"] = &NoteStoreProcessor::process_authenticateToSharedNotebook;
    processMap_["getSharedNotebookByAuth"] = &NoteStoreProcessor::process_getSharedNotebookByAuth;
    processMap_["emailNote"] = &NoteStoreProcessor::process_emailNote;
  }

  virtual bool process(boost::shared_ptr< ::apache::thrift::protocol::TProtocol> piprot, boost::shared_ptr< ::apache::thrift::protocol::TProtocol> poprot);
  virtual ~NoteStoreProcessor() {}
};

class NoteStoreMultiface : virtual public NoteStoreIf {
 public:
  NoteStoreMultiface(std::vector<boost::shared_ptr<NoteStoreIf> >& ifaces) : ifaces_(ifaces) {
  }
  virtual ~NoteStoreMultiface() {}
 protected:
  std::vector<boost::shared_ptr<NoteStoreIf> > ifaces_;
  NoteStoreMultiface() {}
  void add(boost::shared_ptr<NoteStoreIf> iface) {
    ifaces_.push_back(iface);
  }
 public:
  void getSyncState(SyncState& _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getSyncState(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->getSyncState(_return, authenticationToken);
      }
    }
  }

  void getSyncChunk(SyncChunk& _return, const std::string& authenticationToken, const int32_t afterUSN, const int32_t maxEntries, const bool fullSyncOnly) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getSyncChunk(_return, authenticationToken, afterUSN, maxEntries, fullSyncOnly);
        return;
      } else {
        ifaces_[i]->getSyncChunk(_return, authenticationToken, afterUSN, maxEntries, fullSyncOnly);
      }
    }
  }

  void listNotebooks(std::vector<evernote::edam::Notebook> & _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listNotebooks(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->listNotebooks(_return, authenticationToken);
      }
    }
  }

  void getNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getNotebook(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getNotebook(_return, authenticationToken, guid);
      }
    }
  }

  void getDefaultNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getDefaultNotebook(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->getDefaultNotebook(_return, authenticationToken);
      }
    }
  }

  void createNotebook(evernote::edam::Notebook& _return, const std::string& authenticationToken, const evernote::edam::Notebook& notebook) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->createNotebook(_return, authenticationToken, notebook);
        return;
      } else {
        ifaces_[i]->createNotebook(_return, authenticationToken, notebook);
      }
    }
  }

  int32_t updateNotebook(const std::string& authenticationToken, const evernote::edam::Notebook& notebook) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->updateNotebook(authenticationToken, notebook);
      } else {
        ifaces_[i]->updateNotebook(authenticationToken, notebook);
      }
    }
  }

  int32_t expungeNotebook(const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeNotebook(authenticationToken, guid);
      } else {
        ifaces_[i]->expungeNotebook(authenticationToken, guid);
      }
    }
  }

  void listTags(std::vector<evernote::edam::Tag> & _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listTags(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->listTags(_return, authenticationToken);
      }
    }
  }

  void listTagsByNotebook(std::vector<evernote::edam::Tag> & _return, const std::string& authenticationToken, const evernote::edam::Guid& notebookGuid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listTagsByNotebook(_return, authenticationToken, notebookGuid);
        return;
      } else {
        ifaces_[i]->listTagsByNotebook(_return, authenticationToken, notebookGuid);
      }
    }
  }

  void getTag(evernote::edam::Tag& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getTag(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getTag(_return, authenticationToken, guid);
      }
    }
  }

  void createTag(evernote::edam::Tag& _return, const std::string& authenticationToken, const evernote::edam::Tag& tag) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->createTag(_return, authenticationToken, tag);
        return;
      } else {
        ifaces_[i]->createTag(_return, authenticationToken, tag);
      }
    }
  }

  int32_t updateTag(const std::string& authenticationToken, const evernote::edam::Tag& tag) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->updateTag(authenticationToken, tag);
      } else {
        ifaces_[i]->updateTag(authenticationToken, tag);
      }
    }
  }

  void untagAll(const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->untagAll(authenticationToken, guid);
    }
  }

  int32_t expungeTag(const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeTag(authenticationToken, guid);
      } else {
        ifaces_[i]->expungeTag(authenticationToken, guid);
      }
    }
  }

  void listSearches(std::vector<evernote::edam::SavedSearch> & _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listSearches(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->listSearches(_return, authenticationToken);
      }
    }
  }

  void getSearch(evernote::edam::SavedSearch& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getSearch(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getSearch(_return, authenticationToken, guid);
      }
    }
  }

  void createSearch(evernote::edam::SavedSearch& _return, const std::string& authenticationToken, const evernote::edam::SavedSearch& search) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->createSearch(_return, authenticationToken, search);
        return;
      } else {
        ifaces_[i]->createSearch(_return, authenticationToken, search);
      }
    }
  }

  int32_t updateSearch(const std::string& authenticationToken, const evernote::edam::SavedSearch& search) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->updateSearch(authenticationToken, search);
      } else {
        ifaces_[i]->updateSearch(authenticationToken, search);
      }
    }
  }

  int32_t expungeSearch(const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeSearch(authenticationToken, guid);
      } else {
        ifaces_[i]->expungeSearch(authenticationToken, guid);
      }
    }
  }

  void findNotes(NoteList& _return, const std::string& authenticationToken, const NoteFilter& filter, const int32_t offset, const int32_t maxNotes) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->findNotes(_return, authenticationToken, filter, offset, maxNotes);
        return;
      } else {
        ifaces_[i]->findNotes(_return, authenticationToken, filter, offset, maxNotes);
      }
    }
  }

  void findNoteCounts(NoteCollectionCounts& _return, const std::string& authenticationToken, const NoteFilter& filter, const bool withTrash) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->findNoteCounts(_return, authenticationToken, filter, withTrash);
        return;
      } else {
        ifaces_[i]->findNoteCounts(_return, authenticationToken, filter, withTrash);
      }
    }
  }

  void getNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withContent, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getNote(_return, authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
        return;
      } else {
        ifaces_[i]->getNote(_return, authenticationToken, guid, withContent, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
      }
    }
  }

  void getNoteContent(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getNoteContent(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getNoteContent(_return, authenticationToken, guid);
      }
    }
  }

  void getNoteSearchText(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getNoteSearchText(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getNoteSearchText(_return, authenticationToken, guid);
      }
    }
  }

  void getNoteTagNames(std::vector<std::string> & _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getNoteTagNames(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getNoteTagNames(_return, authenticationToken, guid);
      }
    }
  }

  void createNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Note& note) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->createNote(_return, authenticationToken, note);
        return;
      } else {
        ifaces_[i]->createNote(_return, authenticationToken, note);
      }
    }
  }

  void updateNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Note& note) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->updateNote(_return, authenticationToken, note);
        return;
      } else {
        ifaces_[i]->updateNote(_return, authenticationToken, note);
      }
    }
  }

  int32_t deleteNote(const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->deleteNote(authenticationToken, guid);
      } else {
        ifaces_[i]->deleteNote(authenticationToken, guid);
      }
    }
  }

  int32_t expungeNote(const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeNote(authenticationToken, guid);
      } else {
        ifaces_[i]->expungeNote(authenticationToken, guid);
      }
    }
  }

  int32_t expungeNotes(const std::string& authenticationToken, const std::vector<evernote::edam::Guid> & noteGuids) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeNotes(authenticationToken, noteGuids);
      } else {
        ifaces_[i]->expungeNotes(authenticationToken, noteGuids);
      }
    }
  }

  int32_t expungeInactiveNotes(const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeInactiveNotes(authenticationToken);
      } else {
        ifaces_[i]->expungeInactiveNotes(authenticationToken);
      }
    }
  }

  void copyNote(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const evernote::edam::Guid& toNotebookGuid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->copyNote(_return, authenticationToken, noteGuid, toNotebookGuid);
        return;
      } else {
        ifaces_[i]->copyNote(_return, authenticationToken, noteGuid, toNotebookGuid);
      }
    }
  }

  void listNoteVersions(std::vector<NoteVersionId> & _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listNoteVersions(_return, authenticationToken, noteGuid);
        return;
      } else {
        ifaces_[i]->listNoteVersions(_return, authenticationToken, noteGuid);
      }
    }
  }

  void getNoteVersion(evernote::edam::Note& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const int32_t updateSequenceNum, const bool withResourcesData, const bool withResourcesRecognition, const bool withResourcesAlternateData) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getNoteVersion(_return, authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
        return;
      } else {
        ifaces_[i]->getNoteVersion(_return, authenticationToken, noteGuid, updateSequenceNum, withResourcesData, withResourcesRecognition, withResourcesAlternateData);
      }
    }
  }

  void getResource(evernote::edam::Resource& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid, const bool withData, const bool withRecognition, const bool withAttributes, const bool withAlternateData) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getResource(_return, authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData);
        return;
      } else {
        ifaces_[i]->getResource(_return, authenticationToken, guid, withData, withRecognition, withAttributes, withAlternateData);
      }
    }
  }

  int32_t updateResource(const std::string& authenticationToken, const evernote::edam::Resource& resource) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->updateResource(authenticationToken, resource);
      } else {
        ifaces_[i]->updateResource(authenticationToken, resource);
      }
    }
  }

  void getResourceData(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getResourceData(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getResourceData(_return, authenticationToken, guid);
      }
    }
  }

  void getResourceByHash(evernote::edam::Resource& _return, const std::string& authenticationToken, const evernote::edam::Guid& noteGuid, const std::string& contentHash, const bool withData, const bool withRecognition, const bool withAlternateData) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getResourceByHash(_return, authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData);
        return;
      } else {
        ifaces_[i]->getResourceByHash(_return, authenticationToken, noteGuid, contentHash, withData, withRecognition, withAlternateData);
      }
    }
  }

  void getResourceRecognition(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getResourceRecognition(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getResourceRecognition(_return, authenticationToken, guid);
      }
    }
  }

  void getResourceAlternateData(std::string& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getResourceAlternateData(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getResourceAlternateData(_return, authenticationToken, guid);
      }
    }
  }

  void getResourceAttributes(evernote::edam::ResourceAttributes& _return, const std::string& authenticationToken, const evernote::edam::Guid& guid) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getResourceAttributes(_return, authenticationToken, guid);
        return;
      } else {
        ifaces_[i]->getResourceAttributes(_return, authenticationToken, guid);
      }
    }
  }

  int64_t getAccountSize(const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->getAccountSize(authenticationToken);
      } else {
        ifaces_[i]->getAccountSize(authenticationToken);
      }
    }
  }

  void getAds(std::vector<evernote::edam::Ad> & _return, const std::string& authenticationToken, const AdParameters& adParameters) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getAds(_return, authenticationToken, adParameters);
        return;
      } else {
        ifaces_[i]->getAds(_return, authenticationToken, adParameters);
      }
    }
  }

  void getRandomAd(evernote::edam::Ad& _return, const std::string& authenticationToken, const AdParameters& adParameters) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getRandomAd(_return, authenticationToken, adParameters);
        return;
      } else {
        ifaces_[i]->getRandomAd(_return, authenticationToken, adParameters);
      }
    }
  }

  void getPublicNotebook(evernote::edam::Notebook& _return, const evernote::edam::UserID userId, const std::string& publicUri) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getPublicNotebook(_return, userId, publicUri);
        return;
      } else {
        ifaces_[i]->getPublicNotebook(_return, userId, publicUri);
      }
    }
  }

  void createSharedNotebook(evernote::edam::SharedNotebook& _return, const std::string& authenticationToken, const evernote::edam::SharedNotebook& sharedNotebook) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->createSharedNotebook(_return, authenticationToken, sharedNotebook);
        return;
      } else {
        ifaces_[i]->createSharedNotebook(_return, authenticationToken, sharedNotebook);
      }
    }
  }

  void listSharedNotebooks(std::vector<evernote::edam::SharedNotebook> & _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listSharedNotebooks(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->listSharedNotebooks(_return, authenticationToken);
      }
    }
  }

  int32_t expungeSharedNotebooks(const std::string& authenticationToken, const std::vector<int64_t> & sharedNotebookIds) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeSharedNotebooks(authenticationToken, sharedNotebookIds);
      } else {
        ifaces_[i]->expungeSharedNotebooks(authenticationToken, sharedNotebookIds);
      }
    }
  }

  void createLinkedNotebook(evernote::edam::LinkedNotebook& _return, const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->createLinkedNotebook(_return, authenticationToken, linkedNotebook);
        return;
      } else {
        ifaces_[i]->createLinkedNotebook(_return, authenticationToken, linkedNotebook);
      }
    }
  }

  void updateLinkedNotebook(evernote::edam::LinkedNotebook& _return, const std::string& authenticationToken, const evernote::edam::LinkedNotebook& linkedNotebook) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->updateLinkedNotebook(_return, authenticationToken, linkedNotebook);
        return;
      } else {
        ifaces_[i]->updateLinkedNotebook(_return, authenticationToken, linkedNotebook);
      }
    }
  }

  void listLinkedNotebooks(std::vector<evernote::edam::LinkedNotebook> & _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->listLinkedNotebooks(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->listLinkedNotebooks(_return, authenticationToken);
      }
    }
  }

  int32_t expungeLinkedNotebook(const std::string& authenticationToken, const int64_t linkedNotebookId) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        return ifaces_[i]->expungeLinkedNotebook(authenticationToken, linkedNotebookId);
      } else {
        ifaces_[i]->expungeLinkedNotebook(authenticationToken, linkedNotebookId);
      }
    }
  }

  void authenticateToSharedNotebook(evernote::edam::AuthenticationResult& _return, const std::string& shareKey, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->authenticateToSharedNotebook(_return, shareKey, authenticationToken);
        return;
      } else {
        ifaces_[i]->authenticateToSharedNotebook(_return, shareKey, authenticationToken);
      }
    }
  }

  void getSharedNotebookByAuth(evernote::edam::SharedNotebook& _return, const std::string& authenticationToken) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      if (i == sz - 1) {
        ifaces_[i]->getSharedNotebookByAuth(_return, authenticationToken);
        return;
      } else {
        ifaces_[i]->getSharedNotebookByAuth(_return, authenticationToken);
      }
    }
  }

  void emailNote(const std::string& authenticationToken, const NoteEmailParameters& parameters) {
    uint32_t sz = ifaces_.size();
    for (uint32_t i = 0; i < sz; ++i) {
      ifaces_[i]->emailNote(authenticationToken, parameters);
    }
  }

};

}} // namespace

#endif
