package cryptlib;

import java.nio.*;

public class crypt
{

	/* Additional defines for compilers that provide extended function and 
	   function-parameter checking */
	
	
	
	/****************************************************************************
	*																			*
	*							Algorithm and Object Types						*
	*																			*
	****************************************************************************/
	
	/* Algorithm and mode types */
	
	// CRYPT_ALGO_TYPE
	public static final int ALGO_NONE               = 0  ; // No encryption
	public static final int ALGO_DES                = 1  ; // DES
	public static final int ALGO_3DES               = 2  ; // Triple DES
	public static final int ALGO_IDEA               = 3  ; // IDEA
	public static final int ALGO_CAST               = 4  ; // CAST-128
	public static final int ALGO_RC2                = 5  ; // RC2
	public static final int ALGO_RC4                = 6  ; // RC4
	public static final int ALGO_RC5                = 7  ; // RC5
	public static final int ALGO_AES                = 8  ; // AES
	public static final int ALGO_BLOWFISH           = 9  ; // Blowfish
	public static final int ALGO_SKIPJACK           = 10 ; // Skipjack
	public static final int ALGO_DH                 = 100; // Diffie-Hellman
	public static final int ALGO_RSA                = 101; // RSA
	public static final int ALGO_DSA                = 102; // DSA
	public static final int ALGO_ELGAMAL            = 103; // ElGamal
	public static final int ALGO_KEA                = 104; // KEA
	public static final int ALGO_ECDSA              = 105; // ECDSA
	public static final int ALGO_ECDH               = 106; // ECDH
	public static final int ALGO_MD2                = 200; // MD2
	public static final int ALGO_MD4                = 201; // MD4
	public static final int ALGO_MD5                = 202; // MD5
	public static final int ALGO_SHA1               = 203; // SHA/SHA1
	public static final int ALGO_SHA                = 203; // Older form
	public static final int ALGO_RIPEMD160          = 204; // RIPE-MD 160
	public static final int ALGO_SHA2               = 205; // SHA-256
	public static final int ALGO_SHA256             = 205; // Alternate name
	public static final int ALGO_SHAng              = 206; // Future SHA-nextgen standard
	public static final int ALGO_HMAC_MD5           = 300; // HMAC-MD5
	public static final int ALGO_HMAC_SHA1          = 301; // HMAC-SHA
	public static final int ALGO_HMAC_SHA           = 301; // Older form
	public static final int ALGO_HMAC_RIPEMD160     = 302; // HMAC-RIPEMD-160
	public static final int ALGO_HMAC_SHA2          = 303; // HMAC-SHA2
	public static final int ALGO_HMAC_SHAng         = 304; // HMAC-future-SHA-nextgen
	public static final int ALGO_LAST               = 305; // Last possible crypt algo value
	public static final int ALGO_FIRST_CONVENTIONAL = 1  ;
	public static final int ALGO_LAST_CONVENTIONAL  = 99 ;
	public static final int ALGO_FIRST_PKC          = 100;
	public static final int ALGO_LAST_PKC           = 199;
	public static final int ALGO_FIRST_HASH         = 200;
	public static final int ALGO_LAST_HASH          = 299;
	public static final int ALGO_FIRST_MAC          = 300;
	public static final int ALGO_LAST_MAC           = 399; // End of mac algo.range
	
	// CRYPT_MODE_TYPE
	public static final int MODE_NONE = 0; // No encryption mode
	public static final int MODE_ECB  = 1; // ECB
	public static final int MODE_CBC  = 2; // CBC
	public static final int MODE_CFB  = 3; // CFB
	public static final int MODE_OFB  = 4; // OFB
	public static final int MODE_GCM  = 5; // GCM
	public static final int MODE_LAST = 6; // Last possible crypt mode value
	
	
	/* Keyset subtypes */
	
	// CRYPT_KEYSET_TYPE
	public static final int KEYSET_NONE           = 0; // No keyset type
	public static final int KEYSET_FILE           = 1; // Generic flat file keyset
	public static final int KEYSET_HTTP           = 2; // Web page containing cert/CRL
	public static final int KEYSET_LDAP           = 3; // LDAP directory service
	public static final int KEYSET_ODBC           = 4; // Generic ODBC interface
	public static final int KEYSET_DATABASE       = 5; // Generic RDBMS interface
	public static final int KEYSET_ODBC_STORE     = 6; // ODBC certificate store
	public static final int KEYSET_DATABASE_STORE = 7; // Database certificate store
	public static final int KEYSET_LAST           = 8; // Last possible keyset type
	
	/* Device subtypes */
	
	// CRYPT_DEVICE_TYPE
	public static final int DEVICE_NONE      = 0; // No crypto device
	public static final int DEVICE_FORTEZZA  = 1; // Fortezza card
	public static final int DEVICE_PKCS11    = 2; // PKCS #11 crypto token
	public static final int DEVICE_CRYPTOAPI = 3; // Microsoft CryptoAPI
	public static final int DEVICE_HARDWARE  = 4; // Generic crypo HW plugin
	public static final int DEVICE_LAST      = 5; // Last possible crypto device type
	
	/* Certificate subtypes */
	
	// CRYPT_CERTTYPE_TYPE
	public static final int CERTTYPE_NONE               = 0 ; // No certificate type
	public static final int CERTTYPE_CERTIFICATE        = 1 ; // Certificate
	public static final int CERTTYPE_ATTRIBUTE_CERT     = 2 ; // Attribute certificate
	public static final int CERTTYPE_CERTCHAIN          = 3 ; // PKCS #7 certificate chain
	public static final int CERTTYPE_CERTREQUEST        = 4 ; // PKCS #10 certification request
	public static final int CERTTYPE_REQUEST_CERT       = 5 ; // CRMF certification request
	public static final int CERTTYPE_REQUEST_REVOCATION = 6 ; // CRMF revocation request
	public static final int CERTTYPE_CRL                = 7 ; // CRL
	public static final int CERTTYPE_CMS_ATTRIBUTES     = 8 ; // CMS attributes
	public static final int CERTTYPE_RTCS_REQUEST       = 9 ; // RTCS request
	public static final int CERTTYPE_RTCS_RESPONSE      = 10; // RTCS response
	public static final int CERTTYPE_OCSP_REQUEST       = 11; // OCSP request
	public static final int CERTTYPE_OCSP_RESPONSE      = 12; // OCSP response
	public static final int CERTTYPE_PKIUSER            = 13; // PKI user information
	public static final int CERTTYPE_LAST               = 14; // Last possible cert.type
	
	/* Envelope/data format subtypes */
	
	// CRYPT_FORMAT_TYPE
	public static final int FORMAT_NONE     = 0; // No format type
	public static final int FORMAT_AUTO     = 1; // Deenv, auto-determine type
	public static final int FORMAT_CRYPTLIB = 2; // cryptlib native format
	public static final int FORMAT_CMS      = 3; // PKCS #7 / CMS / S/MIME fmt.
	public static final int FORMAT_PKCS7    = 3;
	public static final int FORMAT_SMIME    = 4; // As CMS with MSG-style behaviour
	public static final int FORMAT_PGP      = 5; // PGP format
	public static final int FORMAT_LAST     = 6; // Last possible format type
	
	/* Session subtypes */
	
	// CRYPT_SESSION_TYPE
	public static final int SESSION_NONE             = 0 ; // No session type
	public static final int SESSION_SSH              = 1 ; // SSH
	public static final int SESSION_SSH_SERVER       = 2 ; // SSH server
	public static final int SESSION_SSL              = 3 ; // SSL/TLS
	public static final int SESSION_SSL_SERVER       = 4 ; // SSL/TLS server
	public static final int SESSION_RTCS             = 5 ; // RTCS
	public static final int SESSION_RTCS_SERVER      = 6 ; // RTCS server
	public static final int SESSION_OCSP             = 7 ; // OCSP
	public static final int SESSION_OCSP_SERVER      = 8 ; // OCSP server
	public static final int SESSION_TSP              = 9 ; // TSP
	public static final int SESSION_TSP_SERVER       = 10; // TSP server
	public static final int SESSION_CMP              = 11; // CMP
	public static final int SESSION_CMP_SERVER       = 12; // CMP server
	public static final int SESSION_SCEP             = 13; // SCEP
	public static final int SESSION_SCEP_SERVER      = 14; // SCEP server
	public static final int SESSION_CERTSTORE_SERVER = 15; // HTTP cert store interface
	public static final int SESSION_LAST             = 16; // Last possible session type
	
	/* User subtypes */
	
	// CRYPT_USER_TYPE
	public static final int USER_NONE   = 0; // No user type
	public static final int USER_NORMAL = 1; // Normal user
	public static final int USER_SO     = 2; // Security officer
	public static final int USER_CA     = 3; // CA user
	public static final int USER_LAST   = 4; // Last possible user type
	
	/****************************************************************************
	*																			*
	*								Attribute Types								*
	*																			*
	****************************************************************************/
	
	/* Attribute types.  These are arranged in the following order:
	
		PROPERTY	- Object property
		ATTRIBUTE	- Generic attributes
		OPTION		- Global or object-specific config.option
		CTXINFO		- Context-specific attribute
		CERTINFO	- Certificate-specific attribute
		KEYINFO		- Keyset-specific attribute
		DEVINFO		- Device-specific attribute
		ENVINFO		- Envelope-specific attribute
		SESSINFO	- Session-specific attribute
		USERINFO	- User-specific attribute */
	
	// CRYPT_ATTRIBUTE_TYPE
	public static final int ATTRIBUTE_NONE                              = 0   ; // Non-value
	public static final int PROPERTY_FIRST                              = 1   ; // *******************
	public static final int PROPERTY_HIGHSECURITY                       = 2   ; // Owned+non-forwardcount+locked
	public static final int PROPERTY_OWNER                              = 3   ; // Object owner
	public static final int PROPERTY_FORWARDCOUNT                       = 4   ; // No.of times object can be forwarded
	public static final int PROPERTY_LOCKED                             = 5   ; // Whether properties can be chged/read
	public static final int PROPERTY_USAGECOUNT                         = 6   ; // Usage count before object expires
	public static final int PROPERTY_NONEXPORTABLE                      = 7   ; // Whether key is nonexp.from context
	public static final int PROPERTY_LAST                               = 8   ;
	public static final int GENERIC_FIRST                               = 9   ; // Extended error information
	public static final int ATTRIBUTE_ERRORTYPE                         = 10  ; // Type of last error
	public static final int ATTRIBUTE_ERRORLOCUS                        = 11  ; // Locus of last error
	public static final int ATTRIBUTE_ERRORMESSAGE                      = 12  ; // Detailed error description
	public static final int ATTRIBUTE_CURRENT_GROUP                     = 13  ; // Cursor mgt: Group in attribute list
	public static final int ATTRIBUTE_CURRENT                           = 14  ; // Cursor mgt: Entry in attribute list
	public static final int ATTRIBUTE_CURRENT_INSTANCE                  = 15  ; // Cursor mgt: Instance in attribute list
	public static final int ATTRIBUTE_BUFFERSIZE                        = 16  ; // Internal data buffer size
	public static final int GENERIC_LAST                                = 17  ;
	public static final int OPTION_FIRST                                = 100 ; // **************************
	public static final int OPTION_INFO_DESCRIPTION                     = 101 ; // Text description
	public static final int OPTION_INFO_COPYRIGHT                       = 102 ; // Copyright notice
	public static final int OPTION_INFO_MAJORVERSION                    = 103 ; // Major release version
	public static final int OPTION_INFO_MINORVERSION                    = 104 ; // Minor release version
	public static final int OPTION_INFO_STEPPING                        = 105 ; // Release stepping
	public static final int OPTION_ENCR_ALGO                            = 106 ; // Encryption algorithm
	public static final int OPTION_ENCR_HASH                            = 107 ; // Hash algorithm
	public static final int OPTION_ENCR_MAC                             = 108 ; // MAC algorithm
	public static final int OPTION_PKC_ALGO                             = 109 ; // Public-key encryption algorithm
	public static final int OPTION_PKC_KEYSIZE                          = 110 ; // Public-key encryption key size
	public static final int OPTION_SIG_ALGO                             = 111 ; // Signature algorithm
	public static final int OPTION_SIG_KEYSIZE                          = 112 ; // Signature keysize
	public static final int OPTION_KEYING_ALGO                          = 113 ; // Key processing algorithm
	public static final int OPTION_KEYING_ITERATIONS                    = 114 ; // Key processing iterations
	public static final int OPTION_CERT_SIGNUNRECOGNISEDATTRIBUTES      = 115 ; // Whether to sign unrecog.attrs
	public static final int OPTION_CERT_VALIDITY                        = 116 ; // Certificate validity period
	public static final int OPTION_CERT_UPDATEINTERVAL                  = 117 ; // CRL update interval
	public static final int OPTION_CERT_COMPLIANCELEVEL                 = 118 ; // PKIX compliance level for cert chks.
	public static final int OPTION_CERT_REQUIREPOLICY                   = 119 ; // Whether explicit policy req'd for certs
	public static final int OPTION_CMS_DEFAULTATTRIBUTES                = 120 ; // Add default CMS attributes
	public static final int OPTION_SMIME_DEFAULTATTRIBUTES              = 120 ; // LDAP keyset options
	public static final int OPTION_KEYS_LDAP_OBJECTCLASS                = 121 ; // Object class
	public static final int OPTION_KEYS_LDAP_OBJECTTYPE                 = 122 ; // Object type to fetch
	public static final int OPTION_KEYS_LDAP_FILTER                     = 123 ; // Query filter
	public static final int OPTION_KEYS_LDAP_CACERTNAME                 = 124 ; // CA certificate attribute name
	public static final int OPTION_KEYS_LDAP_CERTNAME                   = 125 ; // Certificate attribute name
	public static final int OPTION_KEYS_LDAP_CRLNAME                    = 126 ; // CRL attribute name
	public static final int OPTION_KEYS_LDAP_EMAILNAME                  = 127 ; // Email attribute name
	public static final int OPTION_DEVICE_PKCS11_DVR01                  = 128 ; // Name of first PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR02                  = 129 ; // Name of second PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR03                  = 130 ; // Name of third PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR04                  = 131 ; // Name of fourth PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_DVR05                  = 132 ; // Name of fifth PKCS #11 driver
	public static final int OPTION_DEVICE_PKCS11_HARDWAREONLY           = 133 ; // Use only hardware mechanisms
	public static final int OPTION_NET_SOCKS_SERVER                     = 134 ; // Socks server name
	public static final int OPTION_NET_SOCKS_USERNAME                   = 135 ; // Socks user name
	public static final int OPTION_NET_HTTP_PROXY                       = 136 ; // Web proxy server
	public static final int OPTION_NET_CONNECTTIMEOUT                   = 137 ; // Timeout for network connection setup
	public static final int OPTION_NET_READTIMEOUT                      = 138 ; // Timeout for network reads
	public static final int OPTION_NET_WRITETIMEOUT                     = 139 ; // Timeout for network writes
	public static final int OPTION_MISC_ASYNCINIT                       = 140 ; // Whether to init cryptlib async'ly
	public static final int OPTION_MISC_SIDECHANNELPROTECTION           = 141 ; // Protect against side-channel attacks
	public static final int OPTION_CONFIGCHANGED                        = 142 ; // Whether in-mem.opts match on-disk ones
	public static final int OPTION_SELFTESTOK                           = 143 ; // Whether self-test was completed and OK
	public static final int OPTION_LAST                                 = 144 ;
	public static final int CTXINFO_FIRST                               = 1000; // ********************
	public static final int CTXINFO_ALGO                                = 1001; // Algorithm
	public static final int CTXINFO_MODE                                = 1002; // Mode
	public static final int CTXINFO_NAME_ALGO                           = 1003; // Algorithm name
	public static final int CTXINFO_NAME_MODE                           = 1004; // Mode name
	public static final int CTXINFO_KEYSIZE                             = 1005; // Key size in bytes
	public static final int CTXINFO_BLOCKSIZE                           = 1006; // Block size
	public static final int CTXINFO_IVSIZE                              = 1007; // IV size
	public static final int CTXINFO_KEYING_ALGO                         = 1008; // Key processing algorithm
	public static final int CTXINFO_KEYING_ITERATIONS                   = 1009; // Key processing iterations
	public static final int CTXINFO_KEYING_SALT                         = 1010; // Key processing salt
	public static final int CTXINFO_KEYING_VALUE                        = 1011; // Value used to derive key
	public static final int CTXINFO_KEY                                 = 1012; // Key
	public static final int CTXINFO_KEY_COMPONENTS                      = 1013; // Public-key components
	public static final int CTXINFO_IV                                  = 1014; // IV
	public static final int CTXINFO_HASHVALUE                           = 1015; // Hash value
	public static final int CTXINFO_LABEL                               = 1016; // Label for private/secret key
	public static final int CTXINFO_PERSISTENT                          = 1017; // Obj.is backed by device or keyset
	public static final int CTXINFO_LAST                                = 1018;
	public static final int CERTINFO_FIRST                              = 2000; // ************************
	public static final int CERTINFO_SELFSIGNED                         = 2001; // Cert is self-signed
	public static final int CERTINFO_IMMUTABLE                          = 2002; // Cert is signed and immutable
	public static final int CERTINFO_XYZZY                              = 2003; // Cert is a magic just-works cert
	public static final int CERTINFO_CERTTYPE                           = 2004; // Certificate object type
	public static final int CERTINFO_FINGERPRINT                        = 2005; // Certificate fingerprints
	public static final int CERTINFO_FINGERPRINT_MD5                    = 2005;
	public static final int CERTINFO_FINGERPRINT_SHA1                   = 2006;
	public static final int CERTINFO_FINGERPRINT_SHA                    = 2006;
	public static final int CERTINFO_FINGERPRINT_SHA2                   = 2007;
	public static final int CERTINFO_FINGERPRINT_SHAng                  = 2008;
	public static final int CERTINFO_CURRENT_CERTIFICATE                = 2009; // Cursor mgt: Rel.pos in chain/CRL/OCSP
	public static final int CERTINFO_TRUSTED_USAGE                      = 2010; // Usage that cert is trusted for
	public static final int CERTINFO_TRUSTED_IMPLICIT                   = 2011; // Whether cert is implicitly trusted
	public static final int CERTINFO_SIGNATURELEVEL                     = 2012; // Amount of detail to include in sigs.
	public static final int CERTINFO_VERSION                            = 2013; // Cert.format version
	public static final int CERTINFO_SERIALNUMBER                       = 2014; // Serial number
	public static final int CERTINFO_SUBJECTPUBLICKEYINFO               = 2015; // Public key
	public static final int CERTINFO_CERTIFICATE                        = 2016; // User certificate
	public static final int CERTINFO_USERCERTIFICATE                    = 2016;
	public static final int CERTINFO_CACERTIFICATE                      = 2017; // CA certificate
	public static final int CERTINFO_ISSUERNAME                         = 2018; // Issuer DN
	public static final int CERTINFO_VALIDFROM                          = 2019; // Cert valid-from time
	public static final int CERTINFO_VALIDTO                            = 2020; // Cert valid-to time
	public static final int CERTINFO_SUBJECTNAME                        = 2021; // Subject DN
	public static final int CERTINFO_ISSUERUNIQUEID                     = 2022; // Issuer unique ID
	public static final int CERTINFO_SUBJECTUNIQUEID                    = 2023; // Subject unique ID
	public static final int CERTINFO_CERTREQUEST                        = 2024; // Cert.request (DN + public key)
	public static final int CERTINFO_THISUPDATE                         = 2025; // CRL/OCSP current-update time
	public static final int CERTINFO_NEXTUPDATE                         = 2026; // CRL/OCSP next-update time
	public static final int CERTINFO_REVOCATIONDATE                     = 2027; // CRL/OCSP cert-revocation time
	public static final int CERTINFO_REVOCATIONSTATUS                   = 2028; // OCSP revocation status
	public static final int CERTINFO_CERTSTATUS                         = 2029; // RTCS certificate status
	public static final int CERTINFO_DN                                 = 2030; // Currently selected DN in string form
	public static final int CERTINFO_PKIUSER_ID                         = 2031; // PKI user ID
	public static final int CERTINFO_PKIUSER_ISSUEPASSWORD              = 2032; // PKI user issue password
	public static final int CERTINFO_PKIUSER_REVPASSWORD                = 2033; // PKI user revocation password
	public static final int CERTINFO_COUNTRYNAME                        = 2100; // countryName
	public static final int CERTINFO_STATEORPROVINCENAME                = 2101; // stateOrProvinceName
	public static final int CERTINFO_LOCALITYNAME                       = 2102; // localityName
	public static final int CERTINFO_ORGANIZATIONNAME                   = 2103; // organizationName
	public static final int CERTINFO_ORGANISATIONNAME                   = 2103;
	public static final int CERTINFO_ORGANIZATIONALUNITNAME             = 2104; // organizationalUnitName
	public static final int CERTINFO_ORGANISATIONALUNITNAME             = 2104;
	public static final int CERTINFO_COMMONNAME                         = 2105; // commonName
	public static final int CERTINFO_OTHERNAME_TYPEID                   = 2106; // otherName.typeID
	public static final int CERTINFO_OTHERNAME_VALUE                    = 2107; // otherName.value
	public static final int CERTINFO_RFC822NAME                         = 2108; // rfc822Name
	public static final int CERTINFO_EMAIL                              = 2108;
	public static final int CERTINFO_DNSNAME                            = 2109; // dNSName
	public static final int CERTINFO_DIRECTORYNAME                      = 2110; // directoryName
	public static final int CERTINFO_EDIPARTYNAME_NAMEASSIGNER          = 2111; // ediPartyName.nameAssigner
	public static final int CERTINFO_EDIPARTYNAME_PARTYNAME             = 2112; // ediPartyName.partyName
	public static final int CERTINFO_UNIFORMRESOURCEIDENTIFIER          = 2113; // uniformResourceIdentifier
	public static final int CERTINFO_IPADDRESS                          = 2114; // iPAddress
	public static final int CERTINFO_REGISTEREDID                       = 2115; // registeredID
	public static final int CERTINFO_CHALLENGEPASSWORD                  = 2200; // 1 3 6 1 4 1 3029 3 1 4 cRLExtReason
	public static final int CERTINFO_CRLEXTREASON                       = 2201; // 1 3 6 1 4 1 3029 3 1 5 keyFeatures
	public static final int CERTINFO_KEYFEATURES                        = 2202; // 1 3 6 1 5 5 7 1 1 authorityInfoAccess
	public static final int CERTINFO_AUTHORITYINFOACCESS                = 2203;
	public static final int CERTINFO_AUTHORITYINFO_RTCS                 = 2204; // accessDescription.accessLocation
	public static final int CERTINFO_AUTHORITYINFO_OCSP                 = 2205; // accessDescription.accessLocation
	public static final int CERTINFO_AUTHORITYINFO_CAISSUERS            = 2206; // accessDescription.accessLocation
	public static final int CERTINFO_AUTHORITYINFO_CERTSTORE            = 2207; // accessDescription.accessLocation
	public static final int CERTINFO_AUTHORITYINFO_CRLS                 = 2208; // accessDescription.accessLocation
	public static final int CERTINFO_BIOMETRICINFO                      = 2209;
	public static final int CERTINFO_BIOMETRICINFO_TYPE                 = 2210; // biometricData.typeOfData
	public static final int CERTINFO_BIOMETRICINFO_HASHALGO             = 2211; // biometricData.hashAlgorithm
	public static final int CERTINFO_BIOMETRICINFO_HASH                 = 2212; // biometricData.dataHash
	public static final int CERTINFO_BIOMETRICINFO_URL                  = 2213; // biometricData.sourceDataUri
	public static final int CERTINFO_QCSTATEMENT                        = 2214;
	public static final int CERTINFO_QCSTATEMENT_SEMANTICS              = 2215; // qcStatement.statementInfo.semanticsIdentifier
	public static final int CERTINFO_QCSTATEMENT_REGISTRATIONAUTHORITY  = 2216; // qcStatement.statementInfo.nameRegistrationAuthorities
	public static final int CERTINFO_IPADDRESSBLOCKS                    = 2217;
	public static final int CERTINFO_IPADDRESSBLOCKS_ADDRESSFAMILY      = 2218; // addressFamily
	public static final int CERTINFO_IPADDRESSBLOCKS_INHERIT            = 2219;
	public static final int CERTINFO_IPADDRESSBLOCKS_PREFIX             = 2220; // ipAddress.addressPrefix
	public static final int CERTINFO_IPADDRESSBLOCKS_MIN                = 2221; // ipAddress.addressRangeMin
	public static final int CERTINFO_IPADDRESSBLOCKS_MAX                = 2222; // ipAddress.addressRangeMax
	public static final int CERTINFO_AUTONOMOUSSYSIDS                   = 2223; // CRYPT_CERTINFO_AUTONOMOUSSYSIDS_ASNUM_INHERIT,// asNum.inherit
	public static final int CERTINFO_AUTONOMOUSSYSIDS_ASNUM_INHERIT     = 2224;
	public static final int CERTINFO_AUTONOMOUSSYSIDS_ASNUM_ID          = 2225; // asNum.id
	public static final int CERTINFO_AUTONOMOUSSYSIDS_ASNUM_MIN         = 2226; // asNum.min
	public static final int CERTINFO_AUTONOMOUSSYSIDS_ASNUM_MAX         = 2227; // asNum.max
	public static final int CERTINFO_OCSP_NONCE                         = 2228; // nonce
	public static final int CERTINFO_OCSP_RESPONSE                      = 2229;
	public static final int CERTINFO_OCSP_RESPONSE_OCSP                 = 2230; // OCSP standard response
	public static final int CERTINFO_OCSP_NOCHECK                       = 2231; // 1 3 6 1 5 5 7 48 1 6 ocspArchiveCutoff
	public static final int CERTINFO_OCSP_ARCHIVECUTOFF                 = 2232; // 1 3 6 1 5 5 7 48 1 11 subjectInfoAccess
	public static final int CERTINFO_SUBJECTINFOACCESS                  = 2233;
	public static final int CERTINFO_SUBJECTINFO_TIMESTAMPING           = 2234; // accessDescription.accessLocation
	public static final int CERTINFO_SUBJECTINFO_CAREPOSITORY           = 2235; // accessDescription.accessLocation
	public static final int CERTINFO_SUBJECTINFO_SIGNEDOBJECTREPOSITORY = 2236; // accessDescription.accessLocation
	public static final int CERTINFO_SUBJECTINFO_RPKIMANIFEST           = 2237; // accessDescription.accessLocation
	public static final int CERTINFO_SUBJECTINFO_SIGNEDOBJECT           = 2238; // accessDescription.accessLocation
	public static final int CERTINFO_SIGG_DATEOFCERTGEN                 = 2239; // 1 3 36 8 3 2 siggProcuration
	public static final int CERTINFO_SIGG_PROCURATION                   = 2240;
	public static final int CERTINFO_SIGG_PROCURE_COUNTRY               = 2241; // country
	public static final int CERTINFO_SIGG_PROCURE_TYPEOFSUBSTITUTION    = 2242; // typeOfSubstitution
	public static final int CERTINFO_SIGG_PROCURE_SIGNINGFOR            = 2243; // signingFor.thirdPerson
	public static final int CERTINFO_SIGG_ADMISSIONS                    = 2244;
	public static final int CERTINFO_SIGG_ADMISSIONS_AUTHORITY          = 2245; // authority
	public static final int CERTINFO_SIGG_ADMISSIONS_NAMINGAUTHID       = 2246; // namingAuth.iD
	public static final int CERTINFO_SIGG_ADMISSIONS_NAMINGAUTHURL      = 2247; // namingAuth.uRL
	public static final int CERTINFO_SIGG_ADMISSIONS_NAMINGAUTHTEXT     = 2248; // namingAuth.text
	public static final int CERTINFO_SIGG_ADMISSIONS_PROFESSIONITEM     = 2249; // professionItem
	public static final int CERTINFO_SIGG_ADMISSIONS_PROFESSIONOID      = 2250; // professionOID
	public static final int CERTINFO_SIGG_ADMISSIONS_REGISTRATIONNUMBER = 2251; // registrationNumber
	public static final int CERTINFO_SIGG_MONETARYLIMIT                 = 2252;
	public static final int CERTINFO_SIGG_MONETARY_CURRENCY             = 2253; // currency
	public static final int CERTINFO_SIGG_MONETARY_AMOUNT               = 2254; // amount
	public static final int CERTINFO_SIGG_MONETARY_EXPONENT             = 2255; // exponent
	public static final int CERTINFO_SIGG_DECLARATIONOFMAJORITY         = 2256;
	public static final int CERTINFO_SIGG_DECLARATIONOFMAJORITY_COUNTRY = 2257; // fullAgeAtCountry
	public static final int CERTINFO_SIGG_RESTRICTION                   = 2258; // 1 3 36 8 3 13 siggCertHash
	public static final int CERTINFO_SIGG_CERTHASH                      = 2259; // 1 3 36 8 3 15 siggAdditionalInformation
	public static final int CERTINFO_SIGG_ADDITIONALINFORMATION         = 2260; // 1 3 101 1 4 1 strongExtranet
	public static final int CERTINFO_STRONGEXTRANET                     = 2261;
	public static final int CERTINFO_STRONGEXTRANET_ZONE                = 2262; // sxNetIDList.sxNetID.zone
	public static final int CERTINFO_STRONGEXTRANET_ID                  = 2263; // sxNetIDList.sxNetID.id
	public static final int CERTINFO_SUBJECTDIRECTORYATTRIBUTES         = 2264;
	public static final int CERTINFO_SUBJECTDIR_TYPE                    = 2265; // attribute.type
	public static final int CERTINFO_SUBJECTDIR_VALUES                  = 2266; // attribute.values
	public static final int CERTINFO_SUBJECTKEYIDENTIFIER               = 2267; // 2 5 29 15 keyUsage
	public static final int CERTINFO_KEYUSAGE                           = 2268; // 2 5 29 16 privateKeyUsagePeriod
	public static final int CERTINFO_PRIVATEKEYUSAGEPERIOD              = 2269;
	public static final int CERTINFO_PRIVATEKEY_NOTBEFORE               = 2270; // notBefore
	public static final int CERTINFO_PRIVATEKEY_NOTAFTER                = 2271; // notAfter
	public static final int CERTINFO_SUBJECTALTNAME                     = 2272; // 2 5 29 18 issuerAltName
	public static final int CERTINFO_ISSUERALTNAME                      = 2273; // 2 5 29 19 basicConstraints
	public static final int CERTINFO_BASICCONSTRAINTS                   = 2274;
	public static final int CERTINFO_CA                                 = 2275; // cA
	public static final int CERTINFO_AUTHORITY                          = 2275;
	public static final int CERTINFO_PATHLENCONSTRAINT                  = 2276; // pathLenConstraint
	public static final int CERTINFO_CRLNUMBER                          = 2277; // 2 5 29 21 cRLReason
	public static final int CERTINFO_CRLREASON                          = 2278; // 2 5 29 23 holdInstructionCode
	public static final int CERTINFO_HOLDINSTRUCTIONCODE                = 2279; // 2 5 29 24 invalidityDate
	public static final int CERTINFO_INVALIDITYDATE                     = 2280; // 2 5 29 27 deltaCRLIndicator
	public static final int CERTINFO_DELTACRLINDICATOR                  = 2281; // 2 5 29 28 issuingDistributionPoint
	public static final int CERTINFO_ISSUINGDISTRIBUTIONPOINT           = 2282;
	public static final int CERTINFO_ISSUINGDIST_FULLNAME               = 2283; // distributionPointName.fullName
	public static final int CERTINFO_ISSUINGDIST_USERCERTSONLY          = 2284; // onlyContainsUserCerts
	public static final int CERTINFO_ISSUINGDIST_CACERTSONLY            = 2285; // onlyContainsCACerts
	public static final int CERTINFO_ISSUINGDIST_SOMEREASONSONLY        = 2286; // onlySomeReasons
	public static final int CERTINFO_ISSUINGDIST_INDIRECTCRL            = 2287; // indirectCRL
	public static final int CERTINFO_CERTIFICATEISSUER                  = 2288; // 2 5 29 30 nameConstraints
	public static final int CERTINFO_NAMECONSTRAINTS                    = 2289;
	public static final int CERTINFO_PERMITTEDSUBTREES                  = 2290; // permittedSubtrees
	public static final int CERTINFO_EXCLUDEDSUBTREES                   = 2291; // excludedSubtrees
	public static final int CERTINFO_CRLDISTRIBUTIONPOINT               = 2292;
	public static final int CERTINFO_CRLDIST_FULLNAME                   = 2293; // distributionPointName.fullName
	public static final int CERTINFO_CRLDIST_REASONS                    = 2294; // reasons
	public static final int CERTINFO_CRLDIST_CRLISSUER                  = 2295; // cRLIssuer
	public static final int CERTINFO_CERTIFICATEPOLICIES                = 2296;
	public static final int CERTINFO_CERTPOLICYID                       = 2297; // policyInformation.policyIdentifier
	public static final int CERTINFO_CERTPOLICY_CPSURI                  = 2298; // policyInformation.policyQualifiers.qualifier.cPSuri
	public static final int CERTINFO_CERTPOLICY_ORGANIZATION            = 2299; // policyInformation.policyQualifiers.qualifier.userNotice.noticeRef.organization
	public static final int CERTINFO_CERTPOLICY_NOTICENUMBERS           = 2300; // policyInformation.policyQualifiers.qualifier.userNotice.noticeRef.noticeNumbers
	public static final int CERTINFO_CERTPOLICY_EXPLICITTEXT            = 2301; // policyInformation.policyQualifiers.qualifier.userNotice.explicitText
	public static final int CERTINFO_POLICYMAPPINGS                     = 2302;
	public static final int CERTINFO_ISSUERDOMAINPOLICY                 = 2303; // policyMappings.issuerDomainPolicy
	public static final int CERTINFO_SUBJECTDOMAINPOLICY                = 2304; // policyMappings.subjectDomainPolicy
	public static final int CERTINFO_AUTHORITYKEYIDENTIFIER             = 2305;
	public static final int CERTINFO_AUTHORITY_KEYIDENTIFIER            = 2306; // keyIdentifier
	public static final int CERTINFO_AUTHORITY_CERTISSUER               = 2307; // authorityCertIssuer
	public static final int CERTINFO_AUTHORITY_CERTSERIALNUMBER         = 2308; // authorityCertSerialNumber
	public static final int CERTINFO_POLICYCONSTRAINTS                  = 2309;
	public static final int CERTINFO_REQUIREEXPLICITPOLICY              = 2310; // policyConstraints.requireExplicitPolicy
	public static final int CERTINFO_INHIBITPOLICYMAPPING               = 2311; // policyConstraints.inhibitPolicyMapping
	public static final int CERTINFO_EXTKEYUSAGE                        = 2312;
	public static final int CERTINFO_EXTKEY_MS_INDIVIDUALCODESIGNING    = 2313; // individualCodeSigning
	public static final int CERTINFO_EXTKEY_MS_COMMERCIALCODESIGNING    = 2314; // commercialCodeSigning
	public static final int CERTINFO_EXTKEY_MS_CERTTRUSTLISTSIGNING     = 2315; // certTrustListSigning
	public static final int CERTINFO_EXTKEY_MS_TIMESTAMPSIGNING         = 2316; // timeStampSigning
	public static final int CERTINFO_EXTKEY_MS_SERVERGATEDCRYPTO        = 2317; // serverGatedCrypto
	public static final int CERTINFO_EXTKEY_MS_ENCRYPTEDFILESYSTEM      = 2318; // encrypedFileSystem
	public static final int CERTINFO_EXTKEY_SERVERAUTH                  = 2319; // serverAuth
	public static final int CERTINFO_EXTKEY_CLIENTAUTH                  = 2320; // clientAuth
	public static final int CERTINFO_EXTKEY_CODESIGNING                 = 2321; // codeSigning
	public static final int CERTINFO_EXTKEY_EMAILPROTECTION             = 2322; // emailProtection
	public static final int CERTINFO_EXTKEY_IPSECENDSYSTEM              = 2323; // ipsecEndSystem
	public static final int CERTINFO_EXTKEY_IPSECTUNNEL                 = 2324; // ipsecTunnel
	public static final int CERTINFO_EXTKEY_IPSECUSER                   = 2325; // ipsecUser
	public static final int CERTINFO_EXTKEY_TIMESTAMPING                = 2326; // timeStamping
	public static final int CERTINFO_EXTKEY_OCSPSIGNING                 = 2327; // ocspSigning
	public static final int CERTINFO_EXTKEY_DIRECTORYSERVICE            = 2328; // directoryService
	public static final int CERTINFO_EXTKEY_ANYKEYUSAGE                 = 2329; // anyExtendedKeyUsage
	public static final int CERTINFO_EXTKEY_NS_SERVERGATEDCRYPTO        = 2330; // serverGatedCrypto
	public static final int CERTINFO_EXTKEY_VS_SERVERGATEDCRYPTO_CA     = 2331; // serverGatedCrypto CA
	public static final int CERTINFO_CRLSTREAMIDENTIFIER                = 2332; // 2 5 29 46 freshestCRL
	public static final int CERTINFO_FRESHESTCRL                        = 2333;
	public static final int CERTINFO_FRESHESTCRL_FULLNAME               = 2334; // distributionPointName.fullName
	public static final int CERTINFO_FRESHESTCRL_REASONS                = 2335; // reasons
	public static final int CERTINFO_FRESHESTCRL_CRLISSUER              = 2336; // cRLIssuer
	public static final int CERTINFO_ORDEREDLIST                        = 2337; // 2 5 29 51 baseUpdateTime
	public static final int CERTINFO_BASEUPDATETIME                     = 2338; // 2 5 29 53 deltaInfo
	public static final int CERTINFO_DELTAINFO                          = 2339;
	public static final int CERTINFO_DELTAINFO_LOCATION                 = 2340; // deltaLocation
	public static final int CERTINFO_DELTAINFO_NEXTDELTA                = 2341; // nextDelta
	public static final int CERTINFO_INHIBITANYPOLICY                   = 2342; // 2 5 29 58 toBeRevoked
	public static final int CERTINFO_TOBEREVOKED                        = 2343;
	public static final int CERTINFO_TOBEREVOKED_CERTISSUER             = 2344; // certificateIssuer
	public static final int CERTINFO_TOBEREVOKED_REASONCODE             = 2345; // reasonCode
	public static final int CERTINFO_TOBEREVOKED_REVOCATIONTIME         = 2346; // revocationTime
	public static final int CERTINFO_TOBEREVOKED_CERTSERIALNUMBER       = 2347; // certSerialNumber
	public static final int CERTINFO_REVOKEDGROUPS                      = 2348;
	public static final int CERTINFO_REVOKEDGROUPS_CERTISSUER           = 2349; // certificateIssuer
	public static final int CERTINFO_REVOKEDGROUPS_REASONCODE           = 2350; // reasonCode
	public static final int CERTINFO_REVOKEDGROUPS_INVALIDITYDATE       = 2351; // invalidityDate
	public static final int CERTINFO_REVOKEDGROUPS_STARTINGNUMBER       = 2352; // startingNumber
	public static final int CERTINFO_REVOKEDGROUPS_ENDINGNUMBER         = 2353; // endingNumber
	public static final int CERTINFO_EXPIREDCERTSONCRL                  = 2354; // 2 5 29 63 aaIssuingDistributionPoint
	public static final int CERTINFO_AAISSUINGDISTRIBUTIONPOINT         = 2355;
	public static final int CERTINFO_AAISSUINGDIST_FULLNAME             = 2356; // distributionPointName.fullName
	public static final int CERTINFO_AAISSUINGDIST_SOMEREASONSONLY      = 2357; // onlySomeReasons
	public static final int CERTINFO_AAISSUINGDIST_INDIRECTCRL          = 2358; // indirectCRL
	public static final int CERTINFO_AAISSUINGDIST_USERATTRCERTS        = 2359; // containsUserAttributeCerts
	public static final int CERTINFO_AAISSUINGDIST_AACERTS              = 2360; // containsAACerts
	public static final int CERTINFO_AAISSUINGDIST_SOACERTS             = 2361; // containsSOAPublicKeyCerts
	public static final int CERTINFO_NS_CERTTYPE                        = 2362; // netscape-cert-type
	public static final int CERTINFO_NS_BASEURL                         = 2363; // netscape-base-url
	public static final int CERTINFO_NS_REVOCATIONURL                   = 2364; // netscape-revocation-url
	public static final int CERTINFO_NS_CAREVOCATIONURL                 = 2365; // netscape-ca-revocation-url
	public static final int CERTINFO_NS_CERTRENEWALURL                  = 2366; // netscape-cert-renewal-url
	public static final int CERTINFO_NS_CAPOLICYURL                     = 2367; // netscape-ca-policy-url
	public static final int CERTINFO_NS_SSLSERVERNAME                   = 2368; // netscape-ssl-server-name
	public static final int CERTINFO_NS_COMMENT                         = 2369; // netscape-comment
	public static final int CERTINFO_SET_HASHEDROOTKEY                  = 2370;
	public static final int CERTINFO_SET_ROOTKEYTHUMBPRINT              = 2371; // rootKeyThumbPrint
	public static final int CERTINFO_SET_CERTIFICATETYPE                = 2372; // 2 23 42 7 2 SET merchantData
	public static final int CERTINFO_SET_MERCHANTDATA                   = 2373;
	public static final int CERTINFO_SET_MERID                          = 2374; // merID
	public static final int CERTINFO_SET_MERACQUIRERBIN                 = 2375; // merAcquirerBIN
	public static final int CERTINFO_SET_MERCHANTLANGUAGE               = 2376; // merNames.language
	public static final int CERTINFO_SET_MERCHANTNAME                   = 2377; // merNames.name
	public static final int CERTINFO_SET_MERCHANTCITY                   = 2378; // merNames.city
	public static final int CERTINFO_SET_MERCHANTSTATEPROVINCE          = 2379; // merNames.stateProvince
	public static final int CERTINFO_SET_MERCHANTPOSTALCODE             = 2380; // merNames.postalCode
	public static final int CERTINFO_SET_MERCHANTCOUNTRYNAME            = 2381; // merNames.countryName
	public static final int CERTINFO_SET_MERCOUNTRY                     = 2382; // merCountry
	public static final int CERTINFO_SET_MERAUTHFLAG                    = 2383; // merAuthFlag
	public static final int CERTINFO_SET_CERTCARDREQUIRED               = 2384; // 2 23 42 7 4 SET tunneling
	public static final int CERTINFO_SET_TUNNELING                      = 2385;
	public static final int CERTINFO_SET_TUNNELLING                     = 2385;
	public static final int CERTINFO_SET_TUNNELINGFLAG                  = 2386; // tunneling
	public static final int CERTINFO_SET_TUNNELLINGFLAG                 = 2386;
	public static final int CERTINFO_SET_TUNNELINGALGID                 = 2387; // tunnelingAlgID
	public static final int CERTINFO_SET_TUNNELLINGALGID                = 2387; // S/MIME attributes
	public static final int CERTINFO_CMS_CONTENTTYPE                    = 2500; // 1 2 840 113549 1 9 4 messageDigest
	public static final int CERTINFO_CMS_MESSAGEDIGEST                  = 2501; // 1 2 840 113549 1 9 5 signingTime
	public static final int CERTINFO_CMS_SIGNINGTIME                    = 2502; // 1 2 840 113549 1 9 6 counterSignature
	public static final int CERTINFO_CMS_COUNTERSIGNATURE               = 2503; // counterSignature
	public static final int CERTINFO_CMS_SIGNINGDESCRIPTION             = 2504; // 1 2 840 113549 1 9 15 sMIMECapabilities
	public static final int CERTINFO_CMS_SMIMECAPABILITIES              = 2505;
	public static final int CERTINFO_CMS_SMIMECAP_3DES                  = 2506; // 3DES encryption
	public static final int CERTINFO_CMS_SMIMECAP_AES                   = 2507; // AES encryption
	public static final int CERTINFO_CMS_SMIMECAP_CAST128               = 2508; // CAST-128 encryption
	public static final int CERTINFO_CMS_SMIMECAP_IDEA                  = 2509; // IDEA encryption
	public static final int CERTINFO_CMS_SMIMECAP_RC2                   = 2510; // RC2 encryption (w.128 key)
	public static final int CERTINFO_CMS_SMIMECAP_RC5                   = 2511; // RC5 encryption (w.128 key)
	public static final int CERTINFO_CMS_SMIMECAP_SKIPJACK              = 2512; // Skipjack encryption
	public static final int CERTINFO_CMS_SMIMECAP_DES                   = 2513; // DES encryption
	public static final int CERTINFO_CMS_SMIMECAP_SHAng                 = 2514; // SHA2-ng hash
	public static final int CERTINFO_CMS_SMIMECAP_SHA2                  = 2515; // SHA2-256 hash
	public static final int CERTINFO_CMS_SMIMECAP_SHA1                  = 2516; // SHA1 hash
	public static final int CERTINFO_CMS_SMIMECAP_HMAC_SHAng            = 2517; // HMAC-SHA2-ng MAC
	public static final int CERTINFO_CMS_SMIMECAP_HMAC_SHA2             = 2518; // HMAC-SHA2-256 MAC
	public static final int CERTINFO_CMS_SMIMECAP_HMAC_SHA1             = 2519; // HMAC-SHA1 MAC
	public static final int CERTINFO_CMS_SMIMECAP_AUTHENC256            = 2520; // AuthEnc w.256-bit key
	public static final int CERTINFO_CMS_SMIMECAP_AUTHENC128            = 2521; // AuthEnc w.128-bit key
	public static final int CERTINFO_CMS_SMIMECAP_RSA_SHAng             = 2522; // RSA with SHA-ng signing
	public static final int CERTINFO_CMS_SMIMECAP_RSA_SHA2              = 2523; // RSA with SHA2-256 signing
	public static final int CERTINFO_CMS_SMIMECAP_RSA_SHA1              = 2524; // RSA with SHA1 signing
	public static final int CERTINFO_CMS_SMIMECAP_DSA_SHA1              = 2525; // DSA with SHA-1 signing
	public static final int CERTINFO_CMS_SMIMECAP_ECDSA_SHAng           = 2526; // ECDSA with SHA-ng signing
	public static final int CERTINFO_CMS_SMIMECAP_ECDSA_SHA2            = 2527; // ECDSA with SHA2-256 signing
	public static final int CERTINFO_CMS_SMIMECAP_ECDSA_SHA1            = 2528; // ECDSA with SHA-1 signing
	public static final int CERTINFO_CMS_SMIMECAP_PREFERSIGNEDDATA      = 2529; // preferSignedData
	public static final int CERTINFO_CMS_SMIMECAP_CANNOTDECRYPTANY      = 2530; // canNotDecryptAny
	public static final int CERTINFO_CMS_SMIMECAP_PREFERBINARYINSIDE    = 2531; // preferBinaryInside
	public static final int CERTINFO_CMS_RECEIPTREQUEST                 = 2532;
	public static final int CERTINFO_CMS_RECEIPT_CONTENTIDENTIFIER      = 2533; // contentIdentifier
	public static final int CERTINFO_CMS_RECEIPT_FROM                   = 2534; // receiptsFrom
	public static final int CERTINFO_CMS_RECEIPT_TO                     = 2535; // receiptsTo
	public static final int CERTINFO_CMS_SECURITYLABEL                  = 2536;
	public static final int CERTINFO_CMS_SECLABEL_POLICY                = 2537; // securityPolicyIdentifier
	public static final int CERTINFO_CMS_SECLABEL_CLASSIFICATION        = 2538; // securityClassification
	public static final int CERTINFO_CMS_SECLABEL_PRIVACYMARK           = 2539; // privacyMark
	public static final int CERTINFO_CMS_SECLABEL_CATTYPE               = 2540; // securityCategories.securityCategory.type
	public static final int CERTINFO_CMS_SECLABEL_CATVALUE              = 2541; // securityCategories.securityCategory.value
	public static final int CERTINFO_CMS_MLEXPANSIONHISTORY             = 2542;
	public static final int CERTINFO_CMS_MLEXP_ENTITYIDENTIFIER         = 2543; // mlData.mailListIdentifier.issuerAndSerialNumber
	public static final int CERTINFO_CMS_MLEXP_TIME                     = 2544; // mlData.expansionTime
	public static final int CERTINFO_CMS_MLEXP_NONE                     = 2545; // mlData.mlReceiptPolicy.none
	public static final int CERTINFO_CMS_MLEXP_INSTEADOF                = 2546; // mlData.mlReceiptPolicy.insteadOf.generalNames.generalName
	public static final int CERTINFO_CMS_MLEXP_INADDITIONTO             = 2547; // mlData.mlReceiptPolicy.inAdditionTo.generalNames.generalName
	public static final int CERTINFO_CMS_CONTENTHINTS                   = 2548;
	public static final int CERTINFO_CMS_CONTENTHINT_DESCRIPTION        = 2549; // contentDescription
	public static final int CERTINFO_CMS_CONTENTHINT_TYPE               = 2550; // contentType
	public static final int CERTINFO_CMS_EQUIVALENTLABEL                = 2551;
	public static final int CERTINFO_CMS_EQVLABEL_POLICY                = 2552; // securityPolicyIdentifier
	public static final int CERTINFO_CMS_EQVLABEL_CLASSIFICATION        = 2553; // securityClassification
	public static final int CERTINFO_CMS_EQVLABEL_PRIVACYMARK           = 2554; // privacyMark
	public static final int CERTINFO_CMS_EQVLABEL_CATTYPE               = 2555; // securityCategories.securityCategory.type
	public static final int CERTINFO_CMS_EQVLABEL_CATVALUE              = 2556; // securityCategories.securityCategory.value
	public static final int CERTINFO_CMS_SIGNINGCERTIFICATE             = 2557;
	public static final int CERTINFO_CMS_SIGNINGCERT_ESSCERTID          = 2558; // certs.essCertID
	public static final int CERTINFO_CMS_SIGNINGCERT_POLICIES           = 2559; // policies.policyInformation.policyIdentifier
	public static final int CERTINFO_CMS_SIGNINGCERTIFICATEV2           = 2560;
	public static final int CERTINFO_CMS_SIGNINGCERTV2_ESSCERTIDV2      = 2561; // certs.essCertID
	public static final int CERTINFO_CMS_SIGNINGCERTV2_POLICIES         = 2562; // policies.policyInformation.policyIdentifier
	public static final int CERTINFO_CMS_SIGNATUREPOLICYID              = 2563;
	public static final int CERTINFO_CMS_SIGPOLICYID                    = 2564; // sigPolicyID
	public static final int CERTINFO_CMS_SIGPOLICYHASH                  = 2565; // sigPolicyHash
	public static final int CERTINFO_CMS_SIGPOLICY_CPSURI               = 2566; // sigPolicyQualifiers.sigPolicyQualifier.cPSuri
	public static final int CERTINFO_CMS_SIGPOLICY_ORGANIZATION         = 2567; // sigPolicyQualifiers.sigPolicyQualifier.userNotice.noticeRef.organization
	public static final int CERTINFO_CMS_SIGPOLICY_NOTICENUMBERS        = 2568; // sigPolicyQualifiers.sigPolicyQualifier.userNotice.noticeRef.noticeNumbers
	public static final int CERTINFO_CMS_SIGPOLICY_EXPLICITTEXT         = 2569; // sigPolicyQualifiers.sigPolicyQualifier.userNotice.explicitText
	public static final int CERTINFO_CMS_SIGTYPEIDENTIFIER              = 2570;
	public static final int CERTINFO_CMS_SIGTYPEID_ORIGINATORSIG        = 2571; // originatorSig
	public static final int CERTINFO_CMS_SIGTYPEID_DOMAINSIG            = 2572; // domainSig
	public static final int CERTINFO_CMS_SIGTYPEID_ADDITIONALATTRIBUTES = 2573; // additionalAttributesSig
	public static final int CERTINFO_CMS_SIGTYPEID_REVIEWSIG            = 2574; // reviewSig
	public static final int CERTINFO_CMS_NONCE                          = 2575; // randomNonce
	public static final int CERTINFO_SCEP_MESSAGETYPE                   = 2576; // messageType
	public static final int CERTINFO_SCEP_PKISTATUS                     = 2577; // pkiStatus
	public static final int CERTINFO_SCEP_FAILINFO                      = 2578; // failInfo
	public static final int CERTINFO_SCEP_SENDERNONCE                   = 2579; // senderNonce
	public static final int CERTINFO_SCEP_RECIPIENTNONCE                = 2580; // recipientNonce
	public static final int CERTINFO_SCEP_TRANSACTIONID                 = 2581; // transID
	public static final int CERTINFO_CMS_SPCAGENCYINFO                  = 2582;
	public static final int CERTINFO_CMS_SPCAGENCYURL                   = 2583; // spcAgencyInfo.url
	public static final int CERTINFO_CMS_SPCSTATEMENTTYPE               = 2584;
	public static final int CERTINFO_CMS_SPCSTMT_INDIVIDUALCODESIGNING  = 2585; // individualCodeSigning
	public static final int CERTINFO_CMS_SPCSTMT_COMMERCIALCODESIGNING  = 2586; // commercialCodeSigning
	public static final int CERTINFO_CMS_SPCOPUSINFO                    = 2587;
	public static final int CERTINFO_CMS_SPCOPUSINFO_NAME               = 2588; // spcOpusInfo.name
	public static final int CERTINFO_CMS_SPCOPUSINFO_URL                = 2589; // spcOpusInfo.url
	public static final int CERTINFO_LAST                               = 2590;
	public static final int KEYINFO_FIRST                               = 3000; // *******************
	public static final int KEYINFO_QUERY                               = 3001; // Keyset query
	public static final int KEYINFO_QUERY_REQUESTS                      = 3002; // Query of requests in cert store
	public static final int KEYINFO_LAST                                = 3003;
	public static final int DEVINFO_FIRST                               = 4000; // *******************
	public static final int DEVINFO_INITIALISE                          = 4001; // Initialise device for use
	public static final int DEVINFO_INITIALIZE                          = 4001;
	public static final int DEVINFO_AUTHENT_USER                        = 4002; // Authenticate user to device
	public static final int DEVINFO_AUTHENT_SUPERVISOR                  = 4003; // Authenticate supervisor to dev.
	public static final int DEVINFO_SET_AUTHENT_USER                    = 4004; // Set user authent.value
	public static final int DEVINFO_SET_AUTHENT_SUPERVISOR              = 4005; // Set supervisor auth.val.
	public static final int DEVINFO_ZEROISE                             = 4006; // Zeroise device
	public static final int DEVINFO_ZEROIZE                             = 4006;
	public static final int DEVINFO_LOGGEDIN                            = 4007; // Whether user is logged in
	public static final int DEVINFO_LABEL                               = 4008; // Device/token label
	public static final int DEVINFO_LAST                                = 4009;
	public static final int ENVINFO_FIRST                               = 5000; // *********************
	public static final int ENVINFO_DATASIZE                            = 5001; // Data size information
	public static final int ENVINFO_COMPRESSION                         = 5002; // Compression information
	public static final int ENVINFO_CONTENTTYPE                         = 5003; // Inner CMS content type
	public static final int ENVINFO_DETACHEDSIGNATURE                   = 5004; // Detached signature
	public static final int ENVINFO_SIGNATURE_RESULT                    = 5005; // Signature check result
	public static final int ENVINFO_INTEGRITY                           = 5006; // Integrity-protection level
	public static final int ENVINFO_PASSWORD                            = 5007; // User password
	public static final int ENVINFO_KEY                                 = 5008; // Conventional encryption key
	public static final int ENVINFO_SIGNATURE                           = 5009; // Signature/signature check key
	public static final int ENVINFO_SIGNATURE_EXTRADATA                 = 5010; // Extra information added to CMS sigs
	public static final int ENVINFO_RECIPIENT                           = 5011; // Recipient email address
	public static final int ENVINFO_PUBLICKEY                           = 5012; // PKC encryption key
	public static final int ENVINFO_PRIVATEKEY                          = 5013; // PKC decryption key
	public static final int ENVINFO_PRIVATEKEY_LABEL                    = 5014; // Label of PKC decryption key
	public static final int ENVINFO_ORIGINATOR                          = 5015; // Originator info/key
	public static final int ENVINFO_SESSIONKEY                          = 5016; // Session key
	public static final int ENVINFO_HASH                                = 5017; // Hash value
	public static final int ENVINFO_TIMESTAMP                           = 5018; // Timestamp information
	public static final int ENVINFO_KEYSET_SIGCHECK                     = 5019; // Signature check keyset
	public static final int ENVINFO_KEYSET_ENCRYPT                      = 5020; // PKC encryption keyset
	public static final int ENVINFO_KEYSET_DECRYPT                      = 5021; // PKC decryption keyset
	public static final int ENVINFO_LAST                                = 5022;
	public static final int SESSINFO_FIRST                              = 6000; // ********************
	public static final int SESSINFO_ACTIVE                             = 6001; // Whether session is active
	public static final int SESSINFO_CONNECTIONACTIVE                   = 6002; // Whether network connection is active
	public static final int SESSINFO_USERNAME                           = 6003; // User name
	public static final int SESSINFO_PASSWORD                           = 6004; // Password
	public static final int SESSINFO_PRIVATEKEY                         = 6005; // Server/client private key
	public static final int SESSINFO_KEYSET                             = 6006; // Certificate store
	public static final int SESSINFO_AUTHRESPONSE                       = 6007; // Session authorisation OK
	public static final int SESSINFO_SERVER_NAME                        = 6008; // Server name
	public static final int SESSINFO_SERVER_PORT                        = 6009; // Server port number
	public static final int SESSINFO_SERVER_FINGERPRINT                 = 6010; // Server key fingerprint
	public static final int SESSINFO_CLIENT_NAME                        = 6011; // Client name
	public static final int SESSINFO_CLIENT_PORT                        = 6012; // Client port number
	public static final int SESSINFO_SESSION                            = 6013; // Transport mechanism
	public static final int SESSINFO_NETWORKSOCKET                      = 6014; // User-supplied network socket
	public static final int SESSINFO_VERSION                            = 6015; // Protocol version
	public static final int SESSINFO_REQUEST                            = 6016; // Cert.request object
	public static final int SESSINFO_RESPONSE                           = 6017; // Cert.response object
	public static final int SESSINFO_CACERTIFICATE                      = 6018; // Issuing CA certificate
	public static final int SESSINFO_CMP_REQUESTTYPE                    = 6019; // Request type
	public static final int SESSINFO_CMP_PRIVKEYSET                     = 6020; // Private-key keyset
	public static final int SESSINFO_SSH_CHANNEL                        = 6021; // SSH current channel
	public static final int SESSINFO_SSH_CHANNEL_TYPE                   = 6022; // SSH channel type
	public static final int SESSINFO_SSH_CHANNEL_ARG1                   = 6023; // SSH channel argument 1
	public static final int SESSINFO_SSH_CHANNEL_ARG2                   = 6024; // SSH channel argument 2
	public static final int SESSINFO_SSH_CHANNEL_ACTIVE                 = 6025; // SSH channel active
	public static final int SESSINFO_SSL_OPTIONS                        = 6026; // SSL/TLS protocol options
	public static final int SESSINFO_TSP_MSGIMPRINT                     = 6027; // TSP message imprint
	public static final int SESSINFO_LAST                               = 6028;
	public static final int USERINFO_FIRST                              = 7000; // ********************
	public static final int USERINFO_PASSWORD                           = 7001; // Password
	public static final int USERINFO_CAKEY_CERTSIGN                     = 7002; // CA cert signing key
	public static final int USERINFO_CAKEY_CRLSIGN                      = 7003; // CA CRL signing key
	public static final int USERINFO_CAKEY_RTCSSIGN                     = 7004; // CA RTCS signing key
	public static final int USERINFO_CAKEY_OCSPSIGN                     = 7005; // CA OCSP signing key
	public static final int USERINFO_LAST                               = 7006;
	public static final int ATTRIBUTE_LAST                              = 7006;
	
	/****************************************************************************
	*																			*
	*						Attribute Subtypes and Related Values				*
	*																			*
	****************************************************************************/
	
	/* Flags for the X.509 keyUsage extension */
	
	public static final int KEYUSAGE_NONE                            = 0x000;
	public static final int KEYUSAGE_DIGITALSIGNATURE                = 0x001;
	public static final int KEYUSAGE_NONREPUDIATION                  = 0x002;
	public static final int KEYUSAGE_KEYENCIPHERMENT                 = 0x004;
	public static final int KEYUSAGE_DATAENCIPHERMENT                = 0x008;
	public static final int KEYUSAGE_KEYAGREEMENT                    = 0x010;
	public static final int KEYUSAGE_KEYCERTSIGN                     = 0x020;
	public static final int KEYUSAGE_CRLSIGN                         = 0x040;
	public static final int KEYUSAGE_ENCIPHERONLY                    = 0x080;
	public static final int KEYUSAGE_DECIPHERONLY                    = 0x100;
	public static final int KEYUSAGE_LAST                            = 0x200; // Last possible value
	
	/* X.509 cRLReason and cryptlib cRLExtReason codes */
	
	public static final int CRLREASON_UNSPECIFIED          = 0 ;
	public static final int CRLREASON_KEYCOMPROMISE        = 1 ;
	public static final int CRLREASON_CACOMPROMISE         = 2 ;
	public static final int CRLREASON_AFFILIATIONCHANGED   = 3 ;
	public static final int CRLREASON_SUPERSEDED           = 4 ;
	public static final int CRLREASON_CESSATIONOFOPERATION = 5 ;
	public static final int CRLREASON_CERTIFICATEHOLD      = 6 ;
	public static final int CRLREASON_REMOVEFROMCRL        = 8 ;
	public static final int CRLREASON_PRIVILEGEWITHDRAWN   = 9 ;
	public static final int CRLREASON_AACOMPROMISE         = 10;
	public static final int CRLREASON_LAST                 = 11; // End of standard CRL reasons
	public static final int CRLREASON_NEVERVALID           = 20;
	public static final int CRLEXTREASON_LAST              = 21;
	
	/* X.509 CRL reason flags.  These identify the same thing as the cRLReason
	   codes but allow for multiple reasons to be specified.  Note that these
	   don't follow the X.509 naming since in that scheme the enumerated types
	   and bitflags have the same names */
	
	public static final int CRLREASONFLAG_UNUSED                     = 0x001;
	public static final int CRLREASONFLAG_KEYCOMPROMISE              = 0x002;
	public static final int CRLREASONFLAG_CACOMPROMISE               = 0x004;
	public static final int CRLREASONFLAG_AFFILIATIONCHANGED         = 0x008;
	public static final int CRLREASONFLAG_SUPERSEDED                 = 0x010;
	public static final int CRLREASONFLAG_CESSATIONOFOPERATION       = 0x020;
	public static final int CRLREASONFLAG_CERTIFICATEHOLD            = 0x040;
	public static final int CRLREASONFLAG_LAST                       = 0x080; // Last poss.value
	
	/* X.509 CRL holdInstruction codes */
	
	public static final int HOLDINSTRUCTION_NONE        = 0;
	public static final int HOLDINSTRUCTION_CALLISSUER  = 1;
	public static final int HOLDINSTRUCTION_REJECT      = 2;
	public static final int HOLDINSTRUCTION_PICKUPTOKEN = 3;
	public static final int HOLDINSTRUCTION_LAST        = 4;
	
	/* Certificate checking compliance levels */
	
	public static final int COMPLIANCELEVEL_OBLIVIOUS    = 0;
	public static final int COMPLIANCELEVEL_REDUCED      = 1;
	public static final int COMPLIANCELEVEL_STANDARD     = 2;
	public static final int COMPLIANCELEVEL_PKIX_PARTIAL = 3;
	public static final int COMPLIANCELEVEL_PKIX_FULL    = 4;
	public static final int COMPLIANCELEVEL_LAST         = 5;
	
	/* Flags for the Netscape netscape-cert-type extension */
	
	public static final int NS_CERTTYPE_SSLCLIENT                    = 0x001;
	public static final int NS_CERTTYPE_SSLSERVER                    = 0x002;
	public static final int NS_CERTTYPE_SMIME                        = 0x004;
	public static final int NS_CERTTYPE_OBJECTSIGNING                = 0x008;
	public static final int NS_CERTTYPE_RESERVED                     = 0x010;
	public static final int NS_CERTTYPE_SSLCA                        = 0x020;
	public static final int NS_CERTTYPE_SMIMECA                      = 0x040;
	public static final int NS_CERTTYPE_OBJECTSIGNINGCA              = 0x080;
	public static final int NS_CERTTYPE_LAST                         = 0x100; // Last possible value
	
	/* Flags for the SET certificate-type extension */
	
	public static final int SET_CERTTYPE_CARD                        = 0x001;
	public static final int SET_CERTTYPE_MER                         = 0x002;
	public static final int SET_CERTTYPE_PGWY                        = 0x004;
	public static final int SET_CERTTYPE_CCA                         = 0x008;
	public static final int SET_CERTTYPE_MCA                         = 0x010;
	public static final int SET_CERTTYPE_PCA                         = 0x020;
	public static final int SET_CERTTYPE_GCA                         = 0x040;
	public static final int SET_CERTTYPE_BCA                         = 0x080;
	public static final int SET_CERTTYPE_RCA                         = 0x100;
	public static final int SET_CERTTYPE_ACQ                         = 0x200;
	public static final int SET_CERTTYPE_LAST                        = 0x400; // Last possible value
	
	/* CMS contentType values */
	
	// CRYPT_CONTENT_TYPE
	public static final int CONTENT_NONE                   = 0 ;
	public static final int CONTENT_DATA                   = 1 ;
	public static final int CONTENT_SIGNEDDATA             = 2 ;
	public static final int CONTENT_ENVELOPEDDATA          = 3 ;
	public static final int CONTENT_SIGNEDANDENVELOPEDDATA = 4 ;
	public static final int CONTENT_DIGESTEDDATA           = 5 ;
	public static final int CONTENT_ENCRYPTEDDATA          = 6 ;
	public static final int CONTENT_COMPRESSEDDATA         = 7 ;
	public static final int CONTENT_AUTHDATA               = 8 ;
	public static final int CONTENT_AUTHENVDATA            = 9 ;
	public static final int CONTENT_TSTINFO                = 10;
	public static final int CONTENT_SPCINDIRECTDATACONTEXT = 11;
	public static final int CONTENT_RTCSREQUEST            = 12;
	public static final int CONTENT_RTCSRESPONSE           = 13;
	public static final int CONTENT_RTCSRESPONSE_EXT       = 14;
	public static final int CONTENT_MRTD                   = 15;
	public static final int CONTENT_LAST                   = 16;
	
	/* ESS securityClassification codes */
	
	public static final int CLASSIFICATION_UNMARKED     = 0  ;
	public static final int CLASSIFICATION_UNCLASSIFIED = 1  ;
	public static final int CLASSIFICATION_RESTRICTED   = 2  ;
	public static final int CLASSIFICATION_CONFIDENTIAL = 3  ;
	public static final int CLASSIFICATION_SECRET       = 4  ;
	public static final int CLASSIFICATION_TOP_SECRET   = 5  ;
	public static final int CLASSIFICATION_LAST         = 255;
	
	/* RTCS certificate status */
	
	public static final int CERTSTATUS_VALID            = 0;
	public static final int CERTSTATUS_NOTVALID         = 1;
	public static final int CERTSTATUS_NONAUTHORITATIVE = 2;
	public static final int CERTSTATUS_UNKNOWN          = 3;
	
	/* OCSP revocation status */
	
	public static final int OCSPSTATUS_NOTREVOKED = 0;
	public static final int OCSPSTATUS_REVOKED    = 1;
	public static final int OCSPSTATUS_UNKNOWN    = 2;
	
	/* The amount of detail to include in signatures when signing certificate
	   objects */
	
	// CRYPT_SIGNATURELEVEL_TYPE
	public static final int SIGNATURELEVEL_NONE       = 0; // Include only signature
	public static final int SIGNATURELEVEL_SIGNERCERT = 1; // Include signer cert
	public static final int SIGNATURELEVEL_ALL        = 2; // Include all relevant info
	public static final int SIGNATURELEVEL_LAST       = 3; // Last possible sig.level type
	
	/* The level of integrity protection to apply to enveloped data.  The 
	   default envelope protection for an envelope with keying information 
	   applied is encryption, this can be modified to use MAC-only protection
	   (with no encryption) or hybrid encryption + authentication */
	
	// CRYPT_INTEGRITY_TYPE
	public static final int INTEGRITY_NONE    = 0; // No integrity protection
	public static final int INTEGRITY_MACONLY = 1; // MAC only, no encryption
	public static final int INTEGRITY_FULL    = 2; // Encryption + ingerity protection
	
	/* The certificate export format type, which defines the format in which a
	   certificate object is exported */
	
	// CRYPT_CERTFORMAT_TYPE
	public static final int CERTFORMAT_NONE             = 0; // No certificate format
	public static final int CERTFORMAT_CERTIFICATE      = 1; // DER-encoded certificate
	public static final int CERTFORMAT_CERTCHAIN        = 2; // PKCS #7 certificate chain
	public static final int CERTFORMAT_TEXT_CERTIFICATE = 3; // base-64 wrapped cert
	public static final int CERTFORMAT_TEXT_CERTCHAIN   = 4; // base-64 wrapped cert chain
	public static final int CERTFORMAT_XML_CERTIFICATE  = 5; // XML wrapped cert
	public static final int CERTFORMAT_XML_CERTCHAIN    = 6; // XML wrapped cert chain
	public static final int CERTFORMAT_LAST             = 7; // Last possible cert.format type
	
	/* CMP request types */
	
	// CRYPT_REQUESTTYPE_TYPE
	public static final int REQUESTTYPE_NONE           = 0; // No request type
	public static final int REQUESTTYPE_INITIALISATION = 1; // Initialisation request
	public static final int REQUESTTYPE_INITIALIZATION = 1;
	public static final int REQUESTTYPE_CERTIFICATE    = 2; // Certification request
	public static final int REQUESTTYPE_KEYUPDATE      = 3; // Key update request
	public static final int REQUESTTYPE_REVOCATION     = 4; // Cert revocation request
	public static final int REQUESTTYPE_PKIBOOT        = 5; // PKIBoot request
	public static final int REQUESTTYPE_LAST           = 6; // Last possible request type
	
	/* Key ID types */
	
	// CRYPT_KEYID_TYPE
	public static final int KEYID_NONE  = 0; // No key ID type
	public static final int KEYID_NAME  = 1; // Key owner name
	public static final int KEYID_URI   = 2; // Key owner URI
	public static final int KEYID_EMAIL = 2; // Synonym: owner email addr.
	public static final int KEYID_LAST  = 3; // Last possible key ID type
	
	/* The encryption object types */
	
	// CRYPT_OBJECT_TYPE
	public static final int OBJECT_NONE             = 0; // No object type
	public static final int OBJECT_ENCRYPTED_KEY    = 1; // Conventionally encrypted key
	public static final int OBJECT_PKCENCRYPTED_KEY = 2; // PKC-encrypted key
	public static final int OBJECT_KEYAGREEMENT     = 3; // Key agreement information
	public static final int OBJECT_SIGNATURE        = 4; // Signature
	public static final int OBJECT_LAST             = 5; // Last possible object type
	
	/* Object/attribute error type information */
	
	// CRYPT_ERRTYPE_TYPE
	public static final int ERRTYPE_NONE             = 0; // No error information
	public static final int ERRTYPE_ATTR_SIZE        = 1; // Attribute data too small or large
	public static final int ERRTYPE_ATTR_VALUE       = 2; // Attribute value is invalid
	public static final int ERRTYPE_ATTR_ABSENT      = 3; // Required attribute missing
	public static final int ERRTYPE_ATTR_PRESENT     = 4; // Non-allowed attribute present
	public static final int ERRTYPE_CONSTRAINT       = 5; // Cert: Constraint violation in object
	public static final int ERRTYPE_ISSUERCONSTRAINT = 6; // Cert: Constraint viol.in issuing cert
	public static final int ERRTYPE_LAST             = 7; // Last possible error info type
	
	/* Cert store management action type */
	
	// CRYPT_CERTACTION_TYPE
	public static final int CERTACTION_NONE                   = 0 ; // No cert management action
	public static final int CERTACTION_CREATE                 = 1 ; // Create cert store
	public static final int CERTACTION_CONNECT                = 2 ; // Connect to cert store
	public static final int CERTACTION_DISCONNECT             = 3 ; // Disconnect from cert store
	public static final int CERTACTION_ERROR                  = 4 ; // Error information
	public static final int CERTACTION_ADDUSER                = 5 ; // Add PKI user
	public static final int CERTACTION_DELETEUSER             = 6 ; // Delete PKI user
	public static final int CERTACTION_REQUEST_CERT           = 7 ; // Cert request
	public static final int CERTACTION_REQUEST_RENEWAL        = 8 ; // Cert renewal request
	public static final int CERTACTION_REQUEST_REVOCATION     = 9 ; // Cert revocation request
	public static final int CERTACTION_CERT_CREATION          = 10; // Cert creation
	public static final int CERTACTION_CERT_CREATION_COMPLETE = 11; // Confirmation of cert creation
	public static final int CERTACTION_CERT_CREATION_DROP     = 12; // Cancellation of cert creation
	public static final int CERTACTION_CERT_CREATION_REVERSE  = 13; // Cancel of creation w.revocation
	public static final int CERTACTION_RESTART_CLEANUP        = 14; // Delete reqs after restart
	public static final int CERTACTION_RESTART_REVOKE_CERT    = 15; // Complete revocation after restart
	public static final int CERTACTION_ISSUE_CERT             = 16; // Cert issue
	public static final int CERTACTION_ISSUE_CRL              = 17; // CRL issue
	public static final int CERTACTION_REVOKE_CERT            = 18; // Cert revocation
	public static final int CERTACTION_EXPIRE_CERT            = 19; // Cert expiry
	public static final int CERTACTION_CLEANUP                = 20; // Clean up on restart
	public static final int CERTACTION_LAST                   = 21; // Last possible cert store log action
	
	/* SSL/TLS protocol options.  CRYPT_SSLOPTION_MINVER_SSLV3 is the same as 
	   CRYPT_SSLOPTION_NONE since this is the default */
	
	public static final int SSLOPTION_NONE                           = 0x00;
	public static final int SSLOPTION_MINVER_SSLV3                   = 0x00; // Min.protocol version
	public static final int SSLOPTION_MINVER_TLS10                   = 0x01;
	public static final int SSLOPTION_MINVER_TLS11                   = 0x02;
	public static final int SSLOPTION_MINVER_TLS12                   = 0x03;
	public static final int SSLOPTION_SUITEB_128                     = 0x04; // SuiteB security levels
	public static final int SSLOPTION_SUITEB_256                     = 0x08;
	
	/****************************************************************************
	*																			*
	*								General Constants							*
	*																			*
	****************************************************************************/
	
	/* The maximum user key size - 2048 bits */
	
	public static final int MAX_KEYSIZE                              = 256 ;
	
	/* The maximum IV size - 256 bits */
	
	public static final int MAX_IVSIZE                               = 32  ;
	
	/* The maximum public-key component size - 4096 bits, and maximum component
	   size for ECCs - 576 bits (to handle the P521 curve) */
	
	public static final int MAX_PKCSIZE                              = 512 ;
	public static final int MAX_PKCSIZE_ECC                          = 72  ;
	
	/* The maximum hash size - 512 bits.  Before 3.4 this was 256 bits, in the 
	   3.4 release it was increased to 512 bits to accommodate SHA-3 */
	
	public static final int MAX_HASHSIZE                             = 64  ;
	
	/* The maximum size of a text string (e.g.key owner name) */
	
	public static final int MAX_TEXTSIZE                             = 64  ;
	
	/* A magic value indicating that the default setting for this parameter
	   should be used.  The parentheses are to catch potential erroneous use 
	   in an expression */
	
	public static final int USE_DEFAULT                              = -100;
	
	/* A magic value for unused parameters */
	
	public static final int UNUSED                                   = -101;
	
	/* Cursor positioning codes for certificate/CRL extensions.  The parentheses 
	   are to catch potential erroneous use in an expression */
	
	public static final int CURSOR_FIRST                             = -200;
	public static final int CURSOR_PREVIOUS                          = -201;
	public static final int CURSOR_NEXT                              = -202;
	public static final int CURSOR_LAST                              = -203;
	
	/* The type of information polling to perform to get random seed 
	   information.  These values have to be negative because they're used
	   as magic length values for cryptAddRandom().  The parentheses are to 
	   catch potential erroneous use in an expression */
	
	public static final int RANDOM_FASTPOLL                          = -300;
	public static final int RANDOM_SLOWPOLL                          = -301;
	
	/* Whether the PKC key is a public or private key */
	
	public static final int KEYTYPE_PRIVATE                          = 0   ;
	public static final int KEYTYPE_PUBLIC                           = 1   ;
	
	/* Keyset open options */
	
	// CRYPT_KEYOPT_TYPE
	public static final int KEYOPT_NONE     = 0; // No options
	public static final int KEYOPT_READONLY = 1; // Open keyset in read-only mode
	public static final int KEYOPT_CREATE   = 2; // Create a new keyset
	public static final int KEYOPT_LAST     = 3; // Last possible key option type
	
	/* The various cryptlib objects - these are just integer handles */
	
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_CERTIFICATE;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_CONTEXT;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_DEVICE;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_ENVELOPE;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_KEYSET;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_SESSION;
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_USER;
	
	/* Sometimes we don't know the exact type of a cryptlib object, so we use a
	   generic handle type to identify it */
	
	//CRYPTLIBCONVERTER - NOT NEEDED: typedef int CRYPT_HANDLE;
	
	/****************************************************************************
	*																			*
	*							Encryption Data Structures						*
	*																			*
	****************************************************************************/
	
	/* Results returned from the capability query */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Algorithm information */
	//	C_CHR algoName[ CRYPT_MAX_TEXTSIZE ];/* Algorithm name */
	//	int blockSize;					/* Block size of the algorithm */
	//	int minKeySize;					/* Minimum key size in bytes */
	//	int keySize;					/* Recommended key size in bytes */
	//	int maxKeySize;					/* Maximum key size in bytes */
	//	} CRYPT_QUERY_INFO;
	
	/* Results returned from the encoded object query.  These provide
	   information on the objects created by cryptExportKey()/
	   cryptCreateSignature() */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* The object type */
	//	CRYPT_OBJECT_TYPE objectType;
	//
	//	/* The encryption algorithm and mode */
	//	CRYPT_ALGO_TYPE cryptAlgo;
	//	CRYPT_MODE_TYPE cryptMode;
	//
	//	/* The hash algorithm for Signature objects */
	//	CRYPT_ALGO_TYPE hashAlgo;
	//
	//	/* The salt for derived keys */
	//	unsigned char salt[ CRYPT_MAX_HASHSIZE ];
	//	int saltSize;
	//	} CRYPT_OBJECT_INFO;
	
	/* Key information for the public-key encryption algorithms.  These fields
	   are not accessed directly, but can be manipulated with the init/set/
	   destroyComponents() macros */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Status information */
	//	int isPublicKey;			/* Whether this is a public or private key */
	//
	//	/* Public components */
	//	unsigned char n[ CRYPT_MAX_PKCSIZE ];	/* Modulus */
	//	int nLen;					/* Length of modulus in bits */
	//	unsigned char e[ CRYPT_MAX_PKCSIZE ];	/* Public exponent */
	//	int eLen;					/* Length of public exponent in bits */
	//
	//	/* Private components */
	//	unsigned char d[ CRYPT_MAX_PKCSIZE ];	/* Private exponent */
	//	int dLen;					/* Length of private exponent in bits */
	//	unsigned char p[ CRYPT_MAX_PKCSIZE ];	/* Prime factor 1 */
	//	int pLen;					/* Length of prime factor 1 in bits */
	//	unsigned char q[ CRYPT_MAX_PKCSIZE ];	/* Prime factor 2 */
	//	int qLen;					/* Length of prime factor 2 in bits */
	//	unsigned char u[ CRYPT_MAX_PKCSIZE ];	/* Mult.inverse of q, mod p */
	//	int uLen;					/* Length of private exponent in bits */
	//	unsigned char e1[ CRYPT_MAX_PKCSIZE ];	/* Private exponent 1 (PKCS) */
	//	int e1Len;					/* Length of private exponent in bits */
	//	unsigned char e2[ CRYPT_MAX_PKCSIZE ];	/* Private exponent 2 (PKCS) */
	//	int e2Len;					/* Length of private exponent in bits */
	//	} CRYPT_PKCINFO_RSA;
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Status information */
	//	int isPublicKey;			/* Whether this is a public or private key */
	//
	//	/* Public components */
	//	unsigned char p[ CRYPT_MAX_PKCSIZE ];	/* Prime modulus */
	//	int pLen;					/* Length of prime modulus in bits */
	//	unsigned char q[ CRYPT_MAX_PKCSIZE ];	/* Prime divisor */
	//	int qLen;					/* Length of prime divisor in bits */
	//	unsigned char g[ CRYPT_MAX_PKCSIZE ];	/* h^( ( p - 1 ) / q ) mod p */
	//	int gLen;					/* Length of g in bits */
	//	unsigned char y[ CRYPT_MAX_PKCSIZE ];	/* Public random integer */
	//	int yLen;					/* Length of public integer in bits */
	//
	//	/* Private components */
	//	unsigned char x[ CRYPT_MAX_PKCSIZE ];	/* Private random integer */
	//	int xLen;					/* Length of private integer in bits */
	//	} CRYPT_PKCINFO_DLP;
	
	// CRYPT_ECCCURVE_TYPE
	public static final int ECCCURVE_NONE = 0; // No ECC curve type
	public static final int ECCCURVE_P192 = 1; // NIST P192/X9.62 P192r1/SECG p192r1 curve
	public static final int ECCCURVE_P224 = 2; // NIST P224/X9.62 P224r1/SECG p224r1 curve
	public static final int ECCCURVE_P256 = 3; // NIST P256/X9.62 P256v1/SECG p256r1 curve
	public static final int ECCCURVE_P384 = 4; // NIST P384, SECG p384r1 curve
	public static final int ECCCURVE_P521 = 5; // NIST P521, SECG p521r1
	public static final int ECCCURVE_LAST = 6; // Last valid ECC curve type
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//typedef struct {
	//	/* Status information */
	//	int isPublicKey;			/* Whether this is a public or private key */
	//
	//	/* Curve domain parameters.  Either the curveType or the explicit domain
	//	   parameters must be provided */
	//	CRYPT_ECCCURVE_TYPE curveType;	/* Named curve */
	//	unsigned char p[ CRYPT_MAX_PKCSIZE_ECC ];/* Prime defining Fq */
	//	int pLen;					/* Length of prime in bits */
	//	unsigned char a[ CRYPT_MAX_PKCSIZE_ECC ];/* Element in Fq defining curve */
	//	int aLen;					/* Length of element a in bits */
	//	unsigned char b[ CRYPT_MAX_PKCSIZE_ECC ];/* Element in Fq defining curve */
	//	int bLen;					/* Length of element b in bits */
	//	unsigned char gx[ CRYPT_MAX_PKCSIZE_ECC ];/* Element in Fq defining point */
	//	int gxLen;					/* Length of element gx in bits */
	//	unsigned char gy[ CRYPT_MAX_PKCSIZE_ECC ];/* Element in Fq defining point */
	//	int gyLen;					/* Length of element gy in bits */
	//	unsigned char n[ CRYPT_MAX_PKCSIZE_ECC ];/* Order of point */
	//	int nLen;					/* Length of order in bits */
	//	unsigned char h[ CRYPT_MAX_PKCSIZE_ECC ];/* Optional cofactor */
	//	int hLen;					/* Length of cofactor in bits */
	//
	//	/* Public components */
	//	unsigned char qx[ CRYPT_MAX_PKCSIZE_ECC ];/* Point Q on the curve */
	//	int qxLen;					/* Length of point xq in bits */
	//	unsigned char qy[ CRYPT_MAX_PKCSIZE_ECC ];/* Point Q on the curve */
	//	int qyLen;					/* Length of point xy in bits */
	//
	//	/* Private components */
	//	unsigned char d[ CRYPT_MAX_PKCSIZE_ECC ];/* Private random integer */
	//	int dLen;					/* Length of integer in bits */
	//	} CRYPT_PKCINFO_ECC;
	
	/* Macros to initialise and destroy the structure that stores the components
	   of a public key */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptInitComponents( componentInfo, componentKeyType ) \
	//	{ memset( ( componentInfo ), 0, sizeof( *componentInfo ) ); \
	//	  ( componentInfo )->isPublicKey = ( ( componentKeyType ) ? 1 : 0 ); }
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptDestroyComponents( componentInfo ) \
	//	memset( ( componentInfo ), 0, sizeof( *componentInfo ) )
	
	/* Macros to set a component of a public key */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptSetComponent( destination, source, length ) \
	//	{ memcpy( ( destination ), ( source ), ( ( length ) + 7 ) >> 3 ); \
	//	  ( destination##Len ) = length; }
	
	/****************************************************************************
	*																			*
	*								Status Codes								*
	*																			*
	****************************************************************************/
	
	/* No error in function call */
	
	public static final int OK                                       = 0   ; // No error
	
	/* Error in parameters passed to function.  The parentheses are to catch 
	   potential erroneous use in an expression */
	
	public static final int ERROR_PARAM1                             = -1  ; // Bad argument, parameter 1
	public static final int ERROR_PARAM2                             = -2  ; // Bad argument, parameter 2
	public static final int ERROR_PARAM3                             = -3  ; // Bad argument, parameter 3
	public static final int ERROR_PARAM4                             = -4  ; // Bad argument, parameter 4
	public static final int ERROR_PARAM5                             = -5  ; // Bad argument, parameter 5
	public static final int ERROR_PARAM6                             = -6  ; // Bad argument, parameter 6
	public static final int ERROR_PARAM7                             = -7  ; // Bad argument, parameter 7
	
	/* Errors due to insufficient resources */
	
	public static final int ERROR_MEMORY                             = -10 ; // Out of memory
	public static final int ERROR_NOTINITED                          = -11 ; // Data has not been initialised
	public static final int ERROR_INITED                             = -12 ; // Data has already been init'd
	public static final int ERROR_NOSECURE                           = -13 ; // Opn.not avail.at requested sec.level
	public static final int ERROR_RANDOM                             = -14 ; // No reliable random data available
	public static final int ERROR_FAILED                             = -15 ; // Operation failed
	public static final int ERROR_INTERNAL                           = -16 ; // Internal consistency check failed
	
	/* Security violations */
	
	public static final int ERROR_NOTAVAIL                           = -20 ; // This type of opn.not available
	public static final int ERROR_PERMISSION                         = -21 ; // No permiss.to perform this operation
	public static final int ERROR_WRONGKEY                           = -22 ; // Incorrect key used to decrypt data
	public static final int ERROR_INCOMPLETE                         = -23 ; // Operation incomplete/still in progress
	public static final int ERROR_COMPLETE                           = -24 ; // Operation complete/can't continue
	public static final int ERROR_TIMEOUT                            = -25 ; // Operation timed out before completion
	public static final int ERROR_INVALID                            = -26 ; // Invalid/inconsistent information
	public static final int ERROR_SIGNALLED                          = -27 ; // Resource destroyed by extnl.event
	
	/* High-level function errors */
	
	public static final int ERROR_OVERFLOW                           = -30 ; // Resources/space exhausted
	public static final int ERROR_UNDERFLOW                          = -31 ; // Not enough data available
	public static final int ERROR_BADDATA                            = -32 ; // Bad/unrecognised data format
	public static final int ERROR_SIGNATURE                          = -33 ; // Signature/integrity check failed
	
	/* Data access function errors */
	
	public static final int ERROR_OPEN                               = -40 ; // Cannot open object
	public static final int ERROR_READ                               = -41 ; // Cannot read item from object
	public static final int ERROR_WRITE                              = -42 ; // Cannot write item to object
	public static final int ERROR_NOTFOUND                           = -43 ; // Requested item not found in object
	public static final int ERROR_DUPLICATE                          = -44 ; // Item already present in object
	
	/* Data enveloping errors */
	
	public static final int ENVELOPE_RESOURCE                        = -50 ; // Need resource to proceed
	
	/* Macros to examine return values */
	
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptStatusError( status )	( ( status ) < CRYPT_OK )
	//CRYPTLIBCONVERTER - NOT SUPPORTED:
	//#define cryptStatusOK( status )		( ( status ) == CRYPT_OK )
	
	/****************************************************************************
	*																			*
	*									General Functions						*
	*																			*
	****************************************************************************/
	
	/* The following is necessary to stop C++ name mangling */
	
	
	/* Initialise and shut down cryptlib */
	
	public static native void Init() throws CryptException;
	
	public static native void End() throws CryptException;
	
	/* Query cryptlibs capabilities */
	
	public static native CRYPT_QUERY_INFO QueryCapability(
							int cryptAlgo // CRYPT_ALGO_TYPE
							) throws CryptException;
	
	/* Create and destroy an encryption context */
	
	public static native int CreateContext(
							int cryptUser, // CRYPT_USER
							int cryptAlgo // CRYPT_ALGO_TYPE
							) throws CryptException;
	
	public static native void DestroyContext(
							int cryptContext // CRYPT_CONTEXT
							) throws CryptException;
	
	/* Generic "destroy an object" function */
	
	public static native void DestroyObject(
							int cryptObject // CRYPT_HANDLE
							) throws CryptException;
	
	/* Generate a key into a context */
	
	public static native void GenerateKey(
							int cryptContext // CRYPT_CONTEXT
							) throws CryptException;
	
	public static native void GenerateKeyAsync(
							int cryptContext // CRYPT_CONTEXT
							) throws CryptException;
	
	public static native void AsyncQuery(
							int cryptObject // CRYPT_HANDLE
							) throws CryptException;
	
	public static native void AsyncCancel(
							int cryptObject // CRYPT_HANDLE
							) throws CryptException;
	
	/* Encrypt/decrypt/hash a block of memory */
	
	public static native void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer
							) throws CryptException { Encrypt(cryptContext, buffer, 0, buffer == null ? 0 : buffer.capacity()); }
	public static void Encrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer
							) throws CryptException { Encrypt(cryptContext, buffer, 0, buffer == null ? 0 : buffer.length); }
	
	public static native void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							java.nio.ByteBuffer buffer
							) throws CryptException { Decrypt(cryptContext, buffer, 0, buffer == null ? 0 : buffer.capacity()); }
	public static void Decrypt(
							int cryptContext, // CRYPT_CONTEXT
							byte[] buffer
							) throws CryptException { Decrypt(cryptContext, buffer, 0, buffer == null ? 0 : buffer.length); }
	
	/* Get/set/delete attribute functions */
	
	public static native void SetAttribute(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							int value
							) throws CryptException;
	
	public static native void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value,
							int valueOffset,
							int valueLength
							) throws CryptException;
	public static native void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value,
							int valueOffset,
							int valueLength
							) throws CryptException;
	public static void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value
							) throws CryptException { SetAttributeString(cryptHandle, attributeType, value, 0, value == null ? 0 : value.capacity()); }
	public static void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value
							) throws CryptException { SetAttributeString(cryptHandle, attributeType, value, 0, value == null ? 0 : value.length); }
	public static void SetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							String value
							) throws CryptException { SetAttributeString(cryptHandle, attributeType, value == null ? null : value.getBytes(), 0, value == null ? 0 : value.getBytes().length); }
	
	public static native int GetAttribute(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType // CRYPT_ATTRIBUTE_TYPE
							) throws CryptException;
	
	public static native int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value,
							int valueOffset
							) throws CryptException;
	public static native int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value,
							int valueOffset
							) throws CryptException;
	public static int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							java.nio.ByteBuffer value
							) throws CryptException { return GetAttributeString(cryptHandle, attributeType, value, 0); }
	public static int GetAttributeString(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType, // CRYPT_ATTRIBUTE_TYPE
							byte[] value
							) throws CryptException { return GetAttributeString(cryptHandle, attributeType, value, 0); }
	public static String GetAttributeString(
	                    int cryptHandle, // CRYPT_HANDLE
	                    int attributeType // CRYPT_ATTRIBUTE_TYPE
	                    ) throws CryptException
	                    {
	                        int length = GetAttributeString(cryptHandle, attributeType, (byte[])null);
	                        byte[] bytes = new byte[length];
	                        length = GetAttributeString(cryptHandle, attributeType, bytes);
	                        return new String(bytes, 0, length);
	                    }
	
	
	public static native void DeleteAttribute(
							int cryptHandle, // CRYPT_HANDLE
							int attributeType // CRYPT_ATTRIBUTE_TYPE
							) throws CryptException;
	
	/* Oddball functions: Add random data to the pool, query an encoded signature
	   or key data.  These are due to be replaced once a suitable alternative can
	   be found */
	
	public static native void AddRandom(
							java.nio.ByteBuffer randomData,
							int randomDataOffset,
							int randomDataLength
							) throws CryptException;
	public static native void AddRandom(
							byte[] randomData,
							int randomDataOffset,
							int randomDataLength
							) throws CryptException;
	public static void AddRandom(
							java.nio.ByteBuffer randomData
							) throws CryptException { AddRandom(randomData, 0, randomData == null ? 0 : randomData.capacity()); }
	public static void AddRandom(
							byte[] randomData
							) throws CryptException { AddRandom(randomData, 0, randomData == null ? 0 : randomData.length); }
	public static void AddRandom(
							String randomData
							) throws CryptException { AddRandom(randomData == null ? null : randomData.getBytes(), 0, randomData == null ? 0 : randomData.getBytes().length); }
	public static native void AddRandom(
	                    int pollType
	                    ) throws CryptException;
	
	
	public static native CRYPT_OBJECT_INFO QueryObject(
							java.nio.ByteBuffer objectData,
							int objectDataOffset,
							int objectDataLength
							) throws CryptException;
	public static native CRYPT_OBJECT_INFO QueryObject(
							byte[] objectData,
							int objectDataOffset,
							int objectDataLength
							) throws CryptException;
	public static CRYPT_OBJECT_INFO QueryObject(
							java.nio.ByteBuffer objectData
							) throws CryptException { return QueryObject(objectData, 0, objectData == null ? 0 : objectData.capacity()); }
	public static CRYPT_OBJECT_INFO QueryObject(
							byte[] objectData
							) throws CryptException { return QueryObject(objectData, 0, objectData == null ? 0 : objectData.length); }
	public static CRYPT_OBJECT_INFO QueryObject(
							String objectData
							) throws CryptException { return QueryObject(objectData == null ? null : objectData.getBytes(), 0, objectData == null ? 0 : objectData.getBytes().length); }
	
	/****************************************************************************
	*																			*
	*							Mid-level Encryption Functions					*
	*																			*
	****************************************************************************/
	
	/* Export and import an encrypted session key */
	
	public static native int ExportKey(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyMaxLength,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int ExportKey(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyMaxLength,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int ExportKey(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyMaxLength,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKey(encryptedKey, 0, encryptedKeyMaxLength, exportKey, sessionKeyContext); }
	public static int ExportKey(
							byte[] encryptedKey,
							int encryptedKeyMaxLength,
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKey(encryptedKey, 0, encryptedKeyMaxLength, exportKey, sessionKeyContext); }
	
	public static native int ExportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int ExportKeyEx(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int ExportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKeyEx(encryptedKey, 0, encryptedKeyMaxLength, formatType, exportKey, sessionKeyContext); }
	public static int ExportKeyEx(
							byte[] encryptedKey,
							int encryptedKeyMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int exportKey, // CRYPT_HANDLE
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ExportKeyEx(encryptedKey, 0, encryptedKeyMaxLength, formatType, exportKey, sessionKeyContext); }
	
	public static native void ImportKey(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyLength,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native void ImportKey(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyLength,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static void ImportKey(
							java.nio.ByteBuffer encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKey(encryptedKey, 0, encryptedKey == null ? 0 : encryptedKey.capacity(), importKey, sessionKeyContext); }
	public static void ImportKey(
							byte[] encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKey(encryptedKey, 0, encryptedKey == null ? 0 : encryptedKey.length, importKey, sessionKeyContext); }
	public static void ImportKey(
							String encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { ImportKey(encryptedKey == null ? null : encryptedKey.getBytes(), 0, encryptedKey == null ? 0 : encryptedKey.getBytes().length, importKey, sessionKeyContext); }
	
	public static native int ImportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyLength,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int ImportKeyEx(
							byte[] encryptedKey,
							int encryptedKeyOffset,
							int encryptedKeyLength,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int ImportKeyEx(
							java.nio.ByteBuffer encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ImportKeyEx(encryptedKey, 0, encryptedKey == null ? 0 : encryptedKey.capacity(), importKey, sessionKeyContext); }
	public static int ImportKeyEx(
							byte[] encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ImportKeyEx(encryptedKey, 0, encryptedKey == null ? 0 : encryptedKey.length, importKey, sessionKeyContext); }
	public static int ImportKeyEx(
							String encryptedKey,
							int importKey, // CRYPT_CONTEXT
							int sessionKeyContext // CRYPT_CONTEXT
							) throws CryptException { return ImportKeyEx(encryptedKey == null ? null : encryptedKey.getBytes(), 0, encryptedKey == null ? 0 : encryptedKey.getBytes().length, importKey, sessionKeyContext); }
	
	/* Create and check a digital signature */
	
	public static native int CreateSignature(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int signatureMaxLength,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int CreateSignature(
							byte[] signature,
							int signatureOffset,
							int signatureMaxLength,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int CreateSignature(
							java.nio.ByteBuffer signature,
							int signatureMaxLength,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CreateSignature(signature, 0, signatureMaxLength, signContext, hashContext); }
	public static int CreateSignature(
							byte[] signature,
							int signatureMaxLength,
							int signContext, // CRYPT_CONTEXT
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CreateSignature(signature, 0, signatureMaxLength, signContext, hashContext); }
	
	public static native int CreateSignatureEx(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int signatureMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException;
	public static native int CreateSignatureEx(
							byte[] signature,
							int signatureOffset,
							int signatureMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException;
	public static int CreateSignatureEx(
							java.nio.ByteBuffer signature,
							int signatureMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException { return CreateSignatureEx(signature, 0, signatureMaxLength, formatType, signContext, hashContext, extraData); }
	public static int CreateSignatureEx(
							byte[] signature,
							int signatureMaxLength,
							int formatType, // CRYPT_FORMAT_TYPE
							int signContext, // CRYPT_CONTEXT
							int hashContext, // CRYPT_CONTEXT
							int extraData // CRYPT_CERTIFICATE
							) throws CryptException { return CreateSignatureEx(signature, 0, signatureMaxLength, formatType, signContext, hashContext, extraData); }
	
	public static native void CheckSignature(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int signatureLength,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native void CheckSignature(
							byte[] signature,
							int signatureOffset,
							int signatureLength,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static void CheckSignature(
							java.nio.ByteBuffer signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { CheckSignature(signature, 0, signature == null ? 0 : signature.capacity(), sigCheckKey, hashContext); }
	public static void CheckSignature(
							byte[] signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { CheckSignature(signature, 0, signature == null ? 0 : signature.length, sigCheckKey, hashContext); }
	public static void CheckSignature(
							String signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { CheckSignature(signature == null ? null : signature.getBytes(), 0, signature == null ? 0 : signature.getBytes().length, sigCheckKey, hashContext); }
	
	public static native int CheckSignatureEx(
							java.nio.ByteBuffer signature,
							int signatureOffset,
							int signatureLength,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static native int CheckSignatureEx(
							byte[] signature,
							int signatureOffset,
							int signatureLength,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException;
	public static int CheckSignatureEx(
							java.nio.ByteBuffer signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CheckSignatureEx(signature, 0, signature == null ? 0 : signature.capacity(), sigCheckKey, hashContext); }
	public static int CheckSignatureEx(
							byte[] signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CheckSignatureEx(signature, 0, signature == null ? 0 : signature.length, sigCheckKey, hashContext); }
	public static int CheckSignatureEx(
							String signature,
							int sigCheckKey, // CRYPT_HANDLE
							int hashContext // CRYPT_CONTEXT
							) throws CryptException { return CheckSignatureEx(signature == null ? null : signature.getBytes(), 0, signature == null ? 0 : signature.getBytes().length, sigCheckKey, hashContext); }
	
	/****************************************************************************
	*																			*
	*									Keyset Functions						*
	*																			*
	****************************************************************************/
	
	/* Open and close a keyset */
	
	public static native int KeysetOpen(
							int cryptUser, // CRYPT_USER
							int keysetType, // CRYPT_KEYSET_TYPE
							String name,
							int options // CRYPT_KEYOPT_TYPE
							) throws CryptException;
	
	public static native void KeysetClose(
							int keyset // CRYPT_KEYSET
							) throws CryptException;
	
	/* Get a key from a keyset or device */
	
	public static native int GetPublicKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	public static native int GetPrivateKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID,
							String password
							) throws CryptException;
	
	public static native int GetKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID,
							String password
							) throws CryptException;
	
	/* Add/delete a key to/from a keyset or device */
	
	public static native void AddPublicKey(
							int keyset, // CRYPT_KEYSET
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	
	public static native void AddPrivateKey(
							int keyset, // CRYPT_KEYSET
							int cryptKey, // CRYPT_HANDLE
							String password
							) throws CryptException;
	
	public static native void DeleteKey(
							int keyset, // CRYPT_KEYSET
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*								Certificate Functions						*
	*																			*
	****************************************************************************/
	
	/* Create/destroy a certificate */
	
	public static native int CreateCert(
							int cryptUser, // CRYPT_USER
							int certType // CRYPT_CERTTYPE_TYPE
							) throws CryptException;
	
	public static native void DestroyCert(
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	
	/* Get/add/delete certificate extensions.  These are direct data insertion
	   functions whose use is discouraged, so they fix the string at char *
	   rather than C_STR */
	
	public static native int GetCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							java.nio.ByteBuffer extension,
							int extensionOffset,
							int extensionMaxLength
							) throws CryptException;
	public static native int GetCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							byte[] extension,
							int extensionOffset,
							int extensionMaxLength
							) throws CryptException;
	public static int GetCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							java.nio.ByteBuffer extension,
							int extensionMaxLength
							) throws CryptException { return GetCertExtension(certificate, oid, extension, 0, extensionMaxLength); }
	public static int GetCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							byte[] extension,
							int extensionMaxLength
							) throws CryptException { return GetCertExtension(certificate, oid, extension, 0, extensionMaxLength); }
	
	public static native void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							java.nio.ByteBuffer extension,
							int extensionOffset,
							int extensionLength
							) throws CryptException;
	public static native void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							byte[] extension,
							int extensionOffset,
							int extensionLength
							) throws CryptException;
	public static void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							java.nio.ByteBuffer extension
							) throws CryptException { AddCertExtension(certificate, oid, criticalFlag, extension, 0, extension == null ? 0 : extension.capacity()); }
	public static void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							byte[] extension
							) throws CryptException { AddCertExtension(certificate, oid, criticalFlag, extension, 0, extension == null ? 0 : extension.length); }
	public static void AddCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid,
							int criticalFlag,
							String extension
							) throws CryptException { AddCertExtension(certificate, oid, criticalFlag, extension == null ? null : extension.getBytes(), 0, extension == null ? 0 : extension.getBytes().length); }
	
	public static native void DeleteCertExtension(
							int certificate, // CRYPT_CERTIFICATE
							String oid
							) throws CryptException;
	
	/* Sign/sig.check a certificate/certification request */
	
	public static native void SignCert(
							int certificate, // CRYPT_CERTIFICATE
							int signContext // CRYPT_CONTEXT
							) throws CryptException;
	
	public static native void CheckCert(
							int certificate, // CRYPT_CERTIFICATE
							int sigCheckKey // CRYPT_HANDLE
							) throws CryptException;
	
	/* Import/export a certificate/certification request */
	
	public static native int ImportCert(
							java.nio.ByteBuffer certObject,
							int certObjectOffset,
							int certObjectLength,
							int cryptUser // CRYPT_USER
							) throws CryptException;
	public static native int ImportCert(
							byte[] certObject,
							int certObjectOffset,
							int certObjectLength,
							int cryptUser // CRYPT_USER
							) throws CryptException;
	public static int ImportCert(
							java.nio.ByteBuffer certObject,
							int cryptUser // CRYPT_USER
							) throws CryptException { return ImportCert(certObject, 0, certObject == null ? 0 : certObject.capacity(), cryptUser); }
	public static int ImportCert(
							byte[] certObject,
							int cryptUser // CRYPT_USER
							) throws CryptException { return ImportCert(certObject, 0, certObject == null ? 0 : certObject.length, cryptUser); }
	public static int ImportCert(
							String certObject,
							int cryptUser // CRYPT_USER
							) throws CryptException { return ImportCert(certObject == null ? null : certObject.getBytes(), 0, certObject == null ? 0 : certObject.getBytes().length, cryptUser); }
	
	public static native int ExportCert(
							java.nio.ByteBuffer certObject,
							int certObjectOffset,
							int certObjectMaxLength,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	public static native int ExportCert(
							byte[] certObject,
							int certObjectOffset,
							int certObjectMaxLength,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	public static int ExportCert(
							java.nio.ByteBuffer certObject,
							int certObjectMaxLength,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException { return ExportCert(certObject, 0, certObjectMaxLength, certFormatType, certificate); }
	public static int ExportCert(
							byte[] certObject,
							int certObjectMaxLength,
							int certFormatType, // CRYPT_CERTFORMAT_TYPE
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException { return ExportCert(certObject, 0, certObjectMaxLength, certFormatType, certificate); }
	
	/* CA management functions */
	
	public static native void CAAddItem(
							int keyset, // CRYPT_KEYSET
							int certificate // CRYPT_CERTIFICATE
							) throws CryptException;
	
	public static native int CAGetItem(
							int keyset, // CRYPT_KEYSET
							int certType, // CRYPT_CERTTYPE_TYPE
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	public static native void CADeleteItem(
							int keyset, // CRYPT_KEYSET
							int certType, // CRYPT_CERTTYPE_TYPE
							int keyIDtype, // CRYPT_KEYID_TYPE
							String keyID
							) throws CryptException;
	
	public static native int CACertManagement(
							int action, // CRYPT_CERTACTION_TYPE
							int keyset, // CRYPT_KEYSET
							int caKey, // CRYPT_CONTEXT
							int certRequest // CRYPT_CERTIFICATE
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*							Envelope and Session Functions					*
	*																			*
	****************************************************************************/
	
	/* Create/destroy an envelope */
	
	public static native int CreateEnvelope(
							int cryptUser, // CRYPT_USER
							int formatType // CRYPT_FORMAT_TYPE
							) throws CryptException;
	
	public static native void DestroyEnvelope(
							int envelope // CRYPT_ENVELOPE
							) throws CryptException;
	
	/* Create/destroy a session */
	
	public static native int CreateSession(
							int cryptUser, // CRYPT_USER
							int formatType // CRYPT_SESSION_TYPE
							) throws CryptException;
	
	public static native void DestroySession(
							int session // CRYPT_SESSION
							) throws CryptException;
	
	/* Add/remove data to/from and envelope or session */
	
	public static native int PushData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native int PushData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static int PushData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer
							) throws CryptException { return PushData(envelope, buffer, 0, buffer == null ? 0 : buffer.capacity()); }
	public static int PushData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer
							) throws CryptException { return PushData(envelope, buffer, 0, buffer == null ? 0 : buffer.length); }
	public static int PushData(
							int envelope, // CRYPT_HANDLE
							String buffer
							) throws CryptException { return PushData(envelope, buffer == null ? null : buffer.getBytes(), 0, buffer == null ? 0 : buffer.getBytes().length); }
	
	public static native void FlushData(
							int envelope // CRYPT_HANDLE
							) throws CryptException;
	
	public static native int PopData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static native int PopData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer,
							int bufferOffset,
							int length
							) throws CryptException;
	public static int PopData(
							int envelope, // CRYPT_HANDLE
							java.nio.ByteBuffer buffer,
							int length
							) throws CryptException { return PopData(envelope, buffer, 0, length); }
	public static int PopData(
							int envelope, // CRYPT_HANDLE
							byte[] buffer,
							int length
							) throws CryptException { return PopData(envelope, buffer, 0, length); }
	
	/****************************************************************************
	*																			*
	*								Device Functions							*
	*																			*
	****************************************************************************/
	
	/* Open and close a device */
	
	public static native int DeviceOpen(
							int cryptUser, // CRYPT_USER
							int deviceType, // CRYPT_DEVICE_TYPE
							String name
							) throws CryptException;
	
	public static native void DeviceClose(
							int device // CRYPT_DEVICE
							) throws CryptException;
	
	/* Query a devices capabilities */
	
	public static native CRYPT_QUERY_INFO DeviceQueryCapability(
							int device, // CRYPT_DEVICE
							int cryptAlgo // CRYPT_ALGO_TYPE
							) throws CryptException;
	
	/* Create an encryption context via the device */
	
	public static native int DeviceCreateContext(
							int device, // CRYPT_DEVICE
							int cryptAlgo // CRYPT_ALGO_TYPE
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*							User Management Functions						*
	*																			*
	****************************************************************************/
	
	/* Log on and off (create/destroy a user object) */
	
	public static native int Login(
							String name,
							String password
							) throws CryptException;
	
	public static native void Logout(
							int user // CRYPT_USER
							) throws CryptException;
	
	/****************************************************************************
	*																			*
	*							User Interface Functions						*
	*																			*
	****************************************************************************/
	
	
	
};