$PKG = 'libcreds2';
$TEST = 0;
$FAIL = 0;
$PASS = 0;

test_return(test_00());
test_return(test_01());
exit($FAIL == 0);

sub info
{
    local($msg) = @_;
    warn "${PKG} TEST${TEST}: $msg\n";
}

sub test_return
{
    local ($res) = @_;
    if ($res)
    {
	$PASS++;
	info("[PASS]");
    }
    else
    {
	$FAIL++;
	info("[FAIL]");
    }
    $TEST++;
}

# translate return of 'system' call into info messages
sub system_return
{
    local ($res) = @_;
    return 0 if ($res == 0);
    # Failure, interpret the result..
    if ($? == -1)
    {
	info("failed to execute: $!");
    }
    elsif ($? & 127)
    {
	info("child died with signal " . ($? & 127))
    }
    else
    {
	info("child exited with value " . ($? >> 8));
    }
    return $res;
}

# verify presence of a module, and try modprobe in to present
sub verify_insmod
{
    local($MOD) = @_;
    local($found);

    unless (open(MODULES, '</proc/modules'))
    {
	info("Opening '/proc/modules' failed -- cannot verify the presence of '$MOD'");
	return 0;
    }
    while (<MODULES>)
    {
	$found = 1 and last if (/^$MOD\s/);
    }
    close(MODULES);
    if (!$found)
    {
	info("Module '$MOD' not available -- trying modprobe");
	$found = 1 if (system_return(system("modprobe $MOD")) == 0);
    }
    return $found;
}

# Verify presense of 'aegis_credp' module/service
sub test_00
{
    # If the file exists, assume present
    return 1 if (-r '/sys/kernel/security/credp/policy');
    return 0 if (!verify_insmod('aegis_credp'));
    return 1 if (-r '/sys/kernel/security/credp/policy');
    info("The 'aegis_credp' does not appear to be functional");
    return 0;
}

# Verify presense of 'aegis_restok' module/service
sub test_01
{
    # If the file exists, assume present
    return 1 if (-r '/sys/kernel/security/restok/tokens');
    return 0 if (!verify_insmod('aegis_restok'));
    return 1 if (-r '/sys/kernel/security/restok_tokens');
    info("The 'aegis_restok' does not appear to be functional");
    return 0;
}
