/*
 * This file is part of AEGIS
 *
 * Copyright (C) 2009 Nokia Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * Author: Markku Savela
 */

/*
 * A trivial program that loads silly policy with relative path.
 *
 * Can be used to verify that system works as intended. The "./shell"
 * in current directory should be executable or a link to such.
 */
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include "credp.h"

static const credp_tlv_t items[7] = {
	/* Set capabilities */
	[0] = {CREDP_ITEM_CAP, 2},
	[1].V = (1 << 1 | 1 << 2 | 1 << 31), /* caps 1, 2, 31, ... */
	[2].V = 1, /* ...and cap 32 */
	/* Set 3 supplementary groups: 123, 100001 and 100002 */
	[3] = {CREDP_ITEM_GRP, 3},
	[4].V = 123,
	[5].V = 100001,
	[6].V = 100002,
	/* Does not change effective uid or gid */
	};
static const char *path = "./shell";

int main(int argc, char **argv)
{
	credp_load(CREDP_TYPE_SET|CREDP_TYPE_INHERIT, path, strlen(path), items, sizeof(items) / sizeof(items[0]));
}
