#include <glib.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <dbus/dbus-glib-lowlevel.h>

#include <QApplication>
#include <QWidget>

#include <phonon/phononnamespace.h>
#include <phonon/audiooutput.h>
#include <phonon/seekslider.h>
#include <phonon/mediaobject.h>
#include <phonon/volumeslider.h>
#include <phonon/backendcapabilities.h>

#include <iostream>
#include <fstream>

#include <time.h>

static DBusHandlerResult signal_filter(DBusConnection *connection, DBusMessage *message, void *user_data);

static Phonon::MediaObject* musicOn; 
static Phonon::MediaObject* musicOff; 
static Phonon::MediaObject* musicOnLock; 
static Phonon::MediaObject* musicOffLock; 
static int lockCount=0;
static int active=1;

static void connectToDbusVibra();
static void connectToDbusProfile();
static void readConfig();
static void getProfileState();

static std::string openSound;
static std::string closeSound;

static std::string openSoundLock;
static std::string closeSoundLock;

static std::string kv;
static std::string lv;
static std::string ks;
static std::string ls;

static int silent=0;

time_t keyboardSlide;

int main(int argc, char *argv[])
{
		      
	QApplication app(argc, argv);
	app.setApplicationName("lockdaemon");

	readConfig();
	
	if (ks.compare("1")==0)
	{
		std::cout<<"music ks"<<std::endl;
		musicOn =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource(openSound.c_str()));
		musicOff =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource(closeSound.c_str()));
	}
	
	if (ls.compare("1")==0)
	{
		std::cout<<"music ls"<<std::endl;
		musicOnLock =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource(openSoundLock.c_str()));
		musicOffLock =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource(closeSoundLock.c_str()));
	}

//	musicOn =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource("/home/opt/lockdaemon/open.mp3"));
//	musicOff =Phonon::createPlayer(Phonon::MusicCategory,Phonon::MediaSource(closeSound.c_str()));
	
	QWidget::connect(musicOn,SIGNAL(finished()),musicOn,SLOT(stop()));
	QWidget::connect(musicOff,SIGNAL(finished()),musicOff,SLOT(stop()));
	
	GMainLoop *loop;
	DBusConnection *bus;
	DBusConnection *busSession;
	DBusError error;

	loop = g_main_loop_new (NULL, FALSE);
	dbus_error_init (&error);
	bus = dbus_bus_get (DBUS_BUS_SYSTEM, &error);
	busSession = dbus_bus_get (DBUS_BUS_SESSION, &error);

	
	connectToDbusVibra();
	connectToDbusProfile();
	
	getProfileState();
	
	if (!bus) 
	{
		g_warning ("Failed to connect to the D-BUS daemon: %s", error.message);							
		dbus_error_free (&error);												
		return 1;											                                       
	}
	
	dbus_connection_setup_with_g_main (bus, NULL);
	dbus_connection_setup_with_g_main (busSession, NULL);

	dbus_bus_add_match (bus, "type='signal',interface='com.nokia.mce.signal'",&error);

	dbus_bus_add_match (bus, "type='signal',interface='hopbeat.lockDaemon'",&error);
	
	dbus_bus_add_match (bus, "type='signal',interface='org.freedesktop.Hal.Device'",&error);

	dbus_bus_add_match (busSession, "type='signal',interface='com.nokia.profiled'",&error);
	
	dbus_connection_add_filter (bus, signal_filter, loop, NULL);											
	dbus_connection_add_filter (busSession, signal_filter, loop, NULL);											
	g_main_loop_run (loop);												      

return 0;
}
	


static int connectedVib;
static DBusMessage* msgVib;
static DBusMessageIter argsVib;
static DBusConnection* connVib;
static DBusError errVib;
static DBusPendingCall* pendingVib;
static int retVib;
static const char* paramVib;
															
static int connectedProf;
static DBusMessage* msgProf;
static DBusMessageIter argsProf;
static DBusConnection* connProf;
static DBusError errProf;
static DBusPendingCall* pendingProf;
static int retProf;
static const char* paramProf;

static void connectToDbusProfile()
{

       	dbus_error_init(&errProf);
      	connProf = dbus_bus_get_private(DBUS_BUS_SESSION, &errProf);
	if (dbus_error_is_set(&errProf))
	{
		dbus_error_free(&errProf);
	}
	if (NULL == connProf)
	{
		return;
	}
	
	retProf = dbus_bus_request_name(connProf, "lockdaemon.profile", DBUS_NAME_FLAG_REPLACE_EXISTING , &errProf);

	if (dbus_error_is_set(&errProf))
	{
		dbus_error_free(&errProf);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retProf)
	{
		return;
	}
	connectedProf=1;

}


static void connectToDbusVibra()
{

       	dbus_error_init(&errVib);
      	connVib = dbus_bus_get_private(DBUS_BUS_SYSTEM, &errVib);
	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}
	if (NULL == connVib)
	{
		return;
	}
	
	retVib = dbus_bus_request_name(connVib, "lockdaemon.vibra", DBUS_NAME_FLAG_REPLACE_EXISTING , &errVib);

	if (dbus_error_is_set(&errVib))
	{
		dbus_error_free(&errVib);
	}
	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != retVib)
	{
		return;
	}
	connectedVib=1;
							 

}


static void getProfileState()
{

	std::cout<<"getting profile state"<<std::endl;

	char* reply;

        msgProf = dbus_message_new_method_call("com.nokia.profiled",                                  
			"/com/nokia/profiled",
			"com.nokia.profiled",
			"get_profile");

   if (NULL == msgProf)
        {
                return;
        }


   dbus_message_iter_init_append(msgProf, &argsProf);

        if (!dbus_connection_send_with_reply (connProf, msgProf, &pendingProf, -1))
        {
                return;
        }
        if (NULL == pendingProf)
        {
                return;
        }

        dbus_connection_flush(connProf);

	g_print("Waiting for state\n");
	
        dbus_message_unref(msgProf);

	dbus_pending_call_block(pendingProf);

	msgProf=dbus_pending_call_steal_reply(pendingProf);

	if (NULL==msgProf)
	{
		g_print("Null reply \n");
		return;
	}

	dbus_pending_call_unref(pendingProf);

	dbus_message_iter_init(msgProf,&argsProf);
	
	if (DBUS_TYPE_STRING == dbus_message_iter_get_arg_type(&argsProf))
	{
		g_print("getting argument: ");
		dbus_message_iter_get_basic(&argsProf,&reply);
		g_print("%s",reply);
		if (reply[0]=='g')
		{
			silent=0;
		}
		else 
			silent=1;
	}

	dbus_message_unref(msgProf);
	

}


static void vibrate(int type)
{
 
	std::cout<<"vibrating"<<std::endl;

        if (type==0) //change this to enum
        {
                paramVib = "PatternTouchscreen";
        }
        else if (type==1)
        {
                paramVib = "PatternPowerKeyPress";
        }
        else if (type==2)
        {
                paramVib= "PatternKeyboard";
        }

        if (connectedVib==0)
        {
                connectToDbusVibra();
                if (connectedVib==0)
                        return;
        }

        msgVib = dbus_message_new_method_call("com.nokia.mce",                                  
			"/com/nokia/mce/request",
			"com.nokia.mce.request",
			"req_vibrator_pattern_activate");

   if (NULL == msgVib)
        {
                return;
        }


   dbus_message_iter_init_append(msgVib, &argsVib);
   if (!dbus_message_iter_append_basic(&argsVib, DBUS_TYPE_STRING, &paramVib))
   {
                return;
   }

        if (!dbus_connection_send_with_reply (connVib, msgVib, &pendingVib, -1))
        {
                return;
        }
        if (NULL == pendingVib)
        {
                return;
        }

        dbus_connection_flush(connVib);
        dbus_message_unref(msgVib);

}









static int readKeyboardState()
{
	
	std::string line;
	std::ifstream myfile ("/sys/devices/platform/gpio-switch/slide/state");
	
    	if (myfile.is_open())
  	{
	//	while (! myfile.eof() )
		{
			getline (myfile,line);
		}
		myfile.close();
	}

		
  	else std::cout << "Unable to open file"; 

	std::cout << line << std::endl;

	if (line.compare("open")==0)
		return 1;
	else
		return 0;


}


static DBusHandlerResult signal_filter (DBusConnection *connection, DBusMessage *message, void *user_data)
{
          

	GMainLoop *loop = (GMainLoop*)user_data;

	
	if (dbus_message_is_signal (message, "org.freedesktop.Hal.Device","Condition"))
	{

		std::string path = "/org/freedesktop/Hal/devices/platform_slide";
		
	  	
		DBusError error;
  		char *s;
		char* s2;
		dbus_error_init (&error);
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_STRING, &s2, DBUS_TYPE_INVALID) && active) 
		{
			
			if (path.compare(dbus_message_get_path(message))==0)
			{
						std::cout<<"KEYBOARD"<<std::endl;
						std::cout<<time(NULL)<<std::endl;
						keyboardSlide=time(NULL);
						if (readKeyboardState())
						{
							if (ks.compare("1")==0 && !silent)
							{
								musicOff->stop();
								musicOn->play();
							}
							if (kv.compare("1")==0)
								vibrate(2);
							std::cout << "open"<<std::endl;
						}
						else
						{
							
							if (ks.compare("1")==0 && !silent)
							{
								musicOn->stop();
								musicOff->play();
							}
							if (kv.compare("1")==0)
								vibrate(2);
							std::cout << "closed" <<std::endl;
						}
			}
		}
		return DBUS_HANDLER_RESULT_HANDLED;
	}
     
	if (dbus_message_is_signal (message, "org.freedesktop.Local", "Disconnected")) 
	{
		g_main_loop_quit (loop);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
         
	//Lock message
	else if (dbus_message_is_signal (message, "com.nokia.mce.signal", "tklock_mode_ind")) 
	{
	  	DBusError error;
  		char *s;
		dbus_error_init (&error);
		
		if(time(NULL)-keyboardSlide<2)
		{
			return DBUS_HANDLER_RESULT_HANDLED;
		}
		
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID) && active) 
		{
			if (s[0]=='l' && lockCount==0)
			{
	
				if (ls.compare("1")==0 && !silent)
				{		
					musicOnLock->stop();
					musicOffLock->play();
				}
				if (lv.compare("1")==0)
					vibrate(2);
				lockCount=1;
				std::cout<<"keyboard locked"<<std::endl;
			}
			else if (s[0]=='u')
			{
			
				if (ls.compare("1")==0 && !silent)
				{
					musicOffLock->stop();
					musicOnLock->play();
				}
				if (lv.compare("1")==0)
					vibrate(2);
				
				lockCount=0;
				std::cout<<"keyboard unlocked"<<std::endl;
			}
		}
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	//profile changed message
	else if (dbus_message_is_signal (message, "com.nokia.profiled", "profile_changed")) 
	{
	  	DBusError error;
		bool a,b;
  		char *s;
		dbus_error_init (&error);
		
		g_print("Profile changed:\n");
		
		if (dbus_message_get_args(message, &error, DBUS_TYPE_BOOLEAN, &a, DBUS_TYPE_BOOLEAN, &b, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID) && active) 
		{
			g_print(s);
			if (s[0]=='g')
			{
				g_print(" I can talk!\n");
				silent=0;
			}
			else
			{
				g_print(" Silent I shall be!\n");
				silent=1;

			}
		}
		
		return DBUS_HANDLER_RESULT_HANDLED;
	}

	//Silence message	
	else if (dbus_message_is_signal (message, "hopbeat.lockDaemon", "Switch")) 
	{
	  	DBusError error;
  		char *s;
		dbus_error_init (&error);
		if (dbus_message_get_args(message, &error, DBUS_TYPE_STRING, &s, DBUS_TYPE_INVALID)) 
		{
			if (active==0)
				active=1;
			else
				active=0;
		}
		else 
		{
			g_print("Ping received, but error getting message: %s\n", error.message);
			dbus_error_free (&error);
		}
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	
	
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}

void readConfig()
{

	std::string line;
	//std::ifstream myfile ("/home/user/MyDocs/.images/lockdaemon.conf");
	std::ifstream myfile ("/home/opt/lockdaemon/lockdaemon.conf");
	if (myfile.is_open())
      	{
		int i=0;
      		while (! myfile.eof() )
		{
			getline (myfile,line);
			if (i==0)
			{
				kv=line;
				std::cout<<"kv: "<<kv<<std::endl;
			}
			else if (i==1)
			{
				lv=line;
				std::cout<<"lv: "<<lv<<std::endl;
			}
			else if (i==2)
			{
				ks=line;
				std::cout<<"ks: "<<ks<<std::endl;
			}
			else if (i==3)
			{
				ls=line;
				std::cout<<"ls: "<<ls<<std::endl;
			}
			else if (i==4)
			{
				openSound=line;
				std::cout<<"openSound: "<<openSound<<std::endl;
			}
			else if (i==5)
			{
				closeSound=line;
				std::cout<<"closeSound: "<<closeSound<<std::endl;
			}
			else if (i==6)
			{
				openSoundLock=line;
				std::cout<<"openSoundLock: "<<openSoundLock<<std::endl;
			}
			else if (i==7)
			{
				closeSoundLock=line;
				std::cout<<"closeSoundLock: "<<closeSoundLock<<std::endl;
			}
			++i;
			std::cout << line << std::endl;
		}
		myfile.close();
	}
    	else std::cout << "Unable to open file"; 

}


