// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
		
		
//#####################################################################
//#####################################################################
//##################################################################### userlist :: by gary birkett
//#####################################################################
//#####################################################################
		
		
/**	
 * userlist widget refresh, all params set, present yourself to the user.
 */	
static int userlist_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}
/**	
 * userlist dialog_open - the user zoomed into the dialog
 */	
static int userlist_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * userlist dialog_close - the dialog was closed
 */	
static int userlist_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * userlist widget shown - occurs once per lifetime
 */	
static int userlist_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * userlist mouse - occurs all the time as you stroke the screen
 */	
static int userlist_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * userlist click - occurs when a short mouse stroke occured
 */	
static int userlist_click(liqcell *self, liqcelleventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * userlist keypress - the user pressed a key
 */	
static int userlist_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * userlist keyrelease - the user released a key
 */	
static int userlist_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * userlist paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int userlist_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * userlist dynamic resizing
 */	
static int userlist_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float sx=((float)self->w)/((float)self->innerw);
	float sy=((float)self->h)/((float)self->innerh);
	
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
	liqcell_setrect_autoscale( backplane, 0,0, 84,320, sx,sy);
	return 0;
}

/**	
 * userlist_child_test_seek this function shows how to access members
 */	
	  
static void userlist_child_test_seek(liqcell *self)
{	  
	liqcell *resize1 = liqcell_child_lookup(self, "resize1");
	liqcell *backplane = liqcell_child_lookup(self, "backplane");
}	  
/**	
 * create a new userlist widget
 */	
liqcell *userlist_create()
{
	liqcell *self = liqcell_quickcreatewidget("userlist", "form", 84, 336);
	if(!self) {liqapp_log("liqcell error not create 'userlist'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# backplane:picturebox
	liqcell *backplane = liqcell_quickcreatevis("backplane", "picturebox", 0, 0, 84, 320);
	//liqcell_setfont(	backplane, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (10), 0) );
	//liqcell_propsets(  backplane, "textcolor", "rgb(0,0,0)" );
	//liqcell_propsets(  backplane, "backcolor", "rgb(128,128,128)" );
	//liqcell_propsets(  backplane, "bordercolor", "rgb(200,100,100)" );
	liqcell_child_append(  self, backplane);
	liqcell_propsets(  self, "backcolor", "rgb(64,64,64)" );
	liqcell_handleradd_withcontext(self, "refresh", userlist_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown", userlist_shown ,self);
	liqcell_handleradd_withcontext(self, "resize", userlist_resize ,self);
	//liqcell_handleradd_withcontext(self, "keypress", userlist_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", userlist_keyrelease ,self);
	liqcell_handleradd_withcontext(self, "mouse", userlist_mouse,self );
	liqcell_handleradd_withcontext(self, "click", userlist_click ,self);
	//liqcell_handleradd_withcontext(self, "paint", userlist_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open", userlist_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", userlist_dialog_close ,self);
	return self;
}

