// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
		
		
//#####################################################################
//#####################################################################
//##################################################################### liqmandel_cover :: by gary birkett
//#####################################################################
//#####################################################################


/**	
 * liqmandel_cover_preview click - occurs when a short mouse stroke occured
 */	
static int liqmandel_cover_preview_click(liqcell *self, liqcellclickeventargs *args,liqcell *context)
{
	//# run the associated dialog
	liqcell *dialog = liqcell_quickcreatevis("liqmandel_run", "liqmandel.liqmandel_run", 0,0, -1,-1);
	liqcell_easyrun( dialog );
	liqcell_release( dialog );
	
	return 0;
}
		
/**	
 * liqmandel_cover widget filter, the system is asking you to filter to the specified .
 */	
static int liqmandel_cover_filter(liqcell *self,liqcellfiltereventargs *args, liqcell *context)
{
	// system is indicating the user has typed into the search box
	// you are expected to filter your content based upon this searchterm.
	// show or hide details and rearrange contents to apply this filter.
	char *searchterm = NULL;
	args->resultoutof=0;  // total number of searchable contents
	args->resultshown=0;  // count of options remaining after filtering.
	searchterm = args->searchterm;
	if(searchterm && *searchterm)
	{
		 // check the name property
		 args->resultoutof++;
		 if( stristr(self->name,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check the classname property
		 args->resultoutof++;
		 if( stristr(self->classname,searchterm) != NULL )
		 {
			  args->resultshown++;
		 }
		 // check any other properties or children and increment counters
		 // filter out list items recursively
	}
	return 0;
}
/**	
 * liqmandel_cover widget refresh, all params set, present yourself to the user.
 */	
static int liqmandel_cover_refresh(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_cover dialog_open - the user zoomed into the dialog
 */	
static int liqmandel_cover_dialog_open(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * liqmandel_cover dialog_close - the dialog was closed
 */	
static int liqmandel_cover_dialog_close(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	 return 0;
}
/**	
 * liqmandel_cover widget shown - occurs once per lifetime
 */	
static int liqmandel_cover_shown(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_cover mouse - occurs all the time as you stroke the screen
 */	
static int liqmandel_cover_mouse(liqcell *self, liqcellmouseeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_cover click - occurs when a short mouse stroke occured
 */	
static int liqmandel_cover_click(liqcell *self, liqcellclickeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_cover keypress - the user pressed a key
 */	
static int liqmandel_cover_keypress(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_cover keyrelease - the user released a key
 */	
static int liqmandel_cover_keyrelease(liqcell *self, liqcellkeyeventargs *args,liqcell *context)
{
	return 0;
}
/**	
 * liqmandel_cover paint - being rendered.  use the vgraph held in args to do custom drawing at scale
 */	
//static int liqmandel_cover_paint(liqcell *self, liqcellpainteventargs *args,liqcell *context)
//{
//	// big heavy event, use sparingly
//	return 0;
//}
/**	
 * liqmandel_cover dynamic resizing
 */	
static int liqmandel_cover_resize(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float iw=((float)self->w);
	float ih=((float)self->h);
	
	liqcell *title = liqcell_child_lookup(self, "title");
	liqcell *author = liqcell_child_lookup(self, "author");
	liqcell *slidetext1 = liqcell_child_lookup(self, "slidetext1");
	liqcell *preview = liqcell_child_lookup(self, "preview");
	liqcell_setrect( title, iw*0.000,ih*0.000, iw*1.000,ih*0.169);
	liqcell_setrect( author, iw*0.030,ih*0.175, iw*0.870,ih*0.102);
	liqcell_setrect( slidetext1, iw*0.032,ih*0.471, iw*0.553,ih*0.065);
	liqcell_setrect( preview, iw*0.519,ih*0.346, iw*0.368,ih*0.473);
	return 0;
}

/**	
 * liqmandel_cover dynamic layout
 */	
static int liqmandel_cover_layout(liqcell *self,liqcelleventargs *args, liqcell *context)
{
	float ww=canvas.pixelwidth;
	float hh=canvas.pixelheight;
	liqcell_setrect(self,		0,0,  ww,hh);
	return 0;
}
/**	
 * liqmandel_cover_child_test_seek this function shows how to access members
 */	
	  
static void liqmandel_cover_child_test_seek(liqcell *liqmandel_cover)
{	  
	liqcell *title = liqcell_child_lookup(liqmandel_cover, "title");
	liqcell *author = liqcell_child_lookup(liqmandel_cover, "author");
	liqcell *slidetext1 = liqcell_child_lookup(liqmandel_cover, "slidetext1");
	liqcell *preview = liqcell_child_lookup(liqmandel_cover, "preview");
}	  
/**	
 * create a new liqmandel_cover widget
 */	
liqcell *liqmandel_cover_create()
{
	liqcell *self = liqcell_quickcreatewidget("liqmandel_cover", "form", 800, 480);
	if(!self) {liqapp_log("liqcell error not create 'liqmandel_cover'"); return NULL;  } 
	
	// Optimization:  The aim is to REDUCE the number of drawn layers and operations called.
	// Optimization:  use only what you NEED to get an effect
	// Optimization:  Minimal layers and complexity
	// Optimization:  defaults: background, prefer nothing, will be shown through if there is a wallpaper
	// Optimization:  defaults: text, white, very fast rendering
	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 0, 0, 800, 80);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (58), 0) );
	liqcell_setcaption(title, "Mandelbrot Explorer" );
	liqcell_propsets(  title, "textcolor", "rgb(255,255,0)" );
	liqcell_propsets(  title, "backcolor", "xrgb(0,0,0)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_propseti(  title, "textaligny", 0 );
	liqcell_child_append(  self, title);
	//############################# author:label
	liqcell *author = liqcell_quickcreatevis("author", "label", 24, 84, 696, 48);
	liqcell_setfont(	author, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (33), 0) );
	liqcell_setcaption(author, "written by Gary Birkett." );
	liqcell_propsets(  author, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  author, "backcolor", "rgb(0,0,0)" );
	liqcell_propseti(  author, "textalign", 0 );
	liqcell_propseti(  author, "textaligny", 0 );
	liqcell_child_append(  self, author);
	//############################# slidetext1:label
	liqcell *slidetext1 = liqcell_quickcreatevis("slidetext1", "label", 26, 226, 442, 30);
	liqcell_setfont(	slidetext1, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (19), 0) );
	liqcell_setcaption(slidetext1, "Super quick mandelbrot set" );
	liqcell_propsets(  slidetext1, "textcolor", "rgb(255,255,255)" );
	liqcell_propsets(  slidetext1, "backcolor", "rgb(0,0,0)" );
	liqcell_propseti(  slidetext1, "textalign", 0 );
	liqcell_propseti(  slidetext1, "textaligny", 0 );
	liqcell_child_append(  self, slidetext1);
	//############################# preview:image
	liqcell *preview = liqcell_quickcreatevis("preview", "image", 416, 166, 294, 226);
	liqcell_propsets(  preview, "imagefilename", "/usr/share/liqbase/liqmandel/media/liqmandel_cover.preview.png" );
	liqcell_child_append(  self, preview);
	liqcell_handleradd_withcontext(preview, "click",		(void*)liqmandel_cover_preview_click ,self);
	
	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	//liqcell_setimage(  self ,  liqimage_cache_getfile( "/usr/share/liqbase/liqmandel/media/liqmandel_cover_back.png",0,0,0) );
	liqcell_handleradd_withcontext(self, "filter",		 (void*)liqmandel_cover_filter ,self);
	liqcell_handleradd_withcontext(self, "refresh",		(void*)liqmandel_cover_refresh ,self);
	liqcell_handleradd_withcontext(self, "shown",		  (void*)liqmandel_cover_shown ,self);
	liqcell_handleradd_withcontext(self, "resize",	  (void*)liqmandel_cover_resize ,self);
	liqcell_handleradd_withcontext(self, "layout",	  (void*)liqmandel_cover_layout ,self);
	//liqcell_handleradd_withcontext(self, "keypress",	(void*)liqmandel_cover_keypress,self );
	//liqcell_handleradd_withcontext(self, "keyrelease", (void*)liqmandel_cover_keyrelease ,self);
	//liqcell_handleradd_withcontext(self, "mouse",		(void*)liqmandel_cover_mouse,self );
	//liqcell_handleradd_withcontext(self, "click",		(void*)liqmandel_cover_click ,self);
	//liqcell_handleradd_withcontext(self, "paint",		(void*)liqmandel_cover_paint ,self); // use only if required, heavyweight
	liqcell_handleradd_withcontext(self, "dialog_open",  (void*)liqmandel_cover_dialog_open ,self);
	liqcell_handleradd_withcontext(self, "dialog_close", (void*)liqmandel_cover_dialog_close ,self);
	return self;
}

