// this file is part of liqbase by Gary Birkett
		
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_easyrun.h>


liqcell *liqbookreader_create();
liqcell *liqbooklist_create();
int liqbookreader_run(char *bookfilename);


void liqcell_codegen_resize(liqcell *self)
{
liqcell *c;
		printf("static int %s_resize(liqcell *self,liqcelleventargs *args, liqcell *%s)\n", self->name, self->name);
		printf("{\n");
		printf("	float iw=((float)self->w);\n");
		printf("	float ih=((float)self->h);\n");
		printf("\n");
		
	c = liqcell_getlinkchild_visible(self);
	while(c)
	{
		printf("	liqcell *%s = liqcell_child_lookup(liqbook, \"%s\");\n", c->name,c->name);
		c=liqcell_getlinknext_visible(c);
	}
	c = liqcell_getlinkchild_visible(self);
	while(c)
	{
		printf("	liqcell_setrect(%s, iw*%0.3f,ih*%0.3f,iw*%0.3f,ih*%0.3f );\n", c->name,  (float)c->x / (float)self->w,   (float)c->y / (float)self->h,
													 (float)c->w / (float)self->w,   (float)c->h / (float)self->h);    
		c=liqcell_getlinknext_visible(c);
	}
		printf("	return 0;\n");		
		printf("}\n");

		printf("static int %s_layout(liqcell *self,liqcelleventargs *args, liqcell *%s)\n", self->name, self->name);
		printf("{\n");
		printf("	float ww=canvas.pixelwidth;\n");
		printf("	float hh=canvas.pixelheight;\n");
		printf("	liqcell_setrect(self,		0,0,  ww,hh);\n");
		printf("	return 0;\n");
		printf("}\n");
}


	
/**	
 * liqbook widget refresh, all params set, present yourself to the user.
 */	
static int liqbook_refresh(liqcell *self,liqcelleventargs *args, void *context)
{
	// there might be an OS level variable called filter
	// it should be set and adjusted correctly prior to calling this routine
	// you should do your best to account for this filter in any way you see fit
	return 0;
}

/**	
 * liqbook.bookselect clicked
 */	
static int bookselect_click(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	liqcell *selectbook = liqcell_child_lookup(liqbook, "selectbook");
	liqcell *continuereading = liqcell_child_lookup(liqbook, "continuereading");


	//# run the associated dialog
	liqcell *dialog = liqcell_quickcreatevis("liqbook_select", "liqbook.liqbook_select", 0,0, -1,-1);
	liqcell_easyrun( dialog );
	liqcell_release( dialog );



	 char *bookname = liqapp_pref_getvalue_def("book_filename","");
	 if(bookname && *bookname)
	 {
	 	liqcell_setenabled(continuereading,1);
	 	liqcell_setcaption_printf(continuereading, "Continue '%s'", liqapp_filename_walkoverpath(bookname));
	 }
	 else
	 {
	 	liqcell_setcaption(continuereading, "Continue Reading" );
		 liqcell_setenabled(continuereading,0);
	 }
	return 0;
}

/**	
 * liqbook.bookcontinue clicked
 */	
static int bookcontinue_click(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	char *bookname = liqapp_pref_getvalue_def("book_filename","");
	if(bookname && *bookname)
	{
		liqbookreader_run(bookname);
	}
	else
	{
	//	liqbookreader_run("/usr/share/liqbase/liqbook/media/liqbook.body.txt");
	}
	return 0;
}


/**	
 * liqbook.bookx clicked
 */	
static int bookx_click(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	char *bookname = liqcell_propgets(self,"bookname",NULL);
	if(bookname && *bookname)
	{
		liqbookreader_run(bookname);
	}
	else
	{
	//	liqbookreader_run("/usr/share/liqbase/liqbook/media/liqbook.body.txt");
	}
	return 0;
}


static int liqbook_resize(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	float iw=((float)self->w);
	float ih=((float)self->h);

	liqcell *lblcaption = liqcell_child_lookup(liqbook, "lblcaption");
	liqcell *selectbook = liqcell_child_lookup(liqbook, "selectbook");
	liqcell *continuereading = liqcell_child_lookup(liqbook, "continuereading");
	liqcell *instructions = liqcell_child_lookup(liqbook, "instructions");
	liqcell *bookx = liqcell_child_lookup(liqbook, "bookx");
	liqcell *icon = liqcell_child_lookup(liqbook, "icon");
	liqcell *title = liqcell_child_lookup(liqbook, "title");
	liqcell_setrect(lblcaption, iw*0.083,ih*0.087,iw*0.833,ih*0.100 );
	liqcell_setrect(selectbook, iw*0.083,ih*0.225,iw*0.833,ih*0.100 );
	liqcell_setrect(continuereading, iw*0.083,ih*0.350,iw*0.833,ih*0.100 );
	liqcell_setrect(instructions, iw*0.083,ih*0.700,iw*0.833,ih*0.100 );
	liqcell_setrect(bookx, iw*0.083,ih*0.825,iw*0.833,ih*0.100 );
	liqcell_setrect(icon, iw*0.013,ih*0.010,iw*0.108,ih*0.050 );
	liqcell_setrect(title, iw*0.138,ih*0.010,iw*1.508,ih*0.050 );
	return 0;

}
static int liqbook_layout(liqcell *self,liqcelleventargs *args, liqcell *liqbook)
{
	float ww=canvas.pixelwidth;
	float hh=canvas.pixelheight;
	liqcell_setrect(self,		0,0,  ww,hh);
	return 0;
}


/**	
 * create a new liqbook widget
 */	
liqcell *liqbook_create()
{
	
	// Smile, it's not every day you get to see things differently.
	
	liqcell *self = liqcell_quickcreatewidget("liqbook", "form", 480,800);
	if(!self) {liqapp_log("liqcell error not create 'liqbook'"); return NULL;  } 

{
	//############################# bookx:commandbutton
	liqcell *lblcaption = liqcell_quickcreatevis("lblcaption", "label", 40, 70, 400, 80);
	liqcell_setfont(	lblcaption, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (35), 0) );
	liqcell_setcaption(lblcaption, "Simple text book reading" );
	liqcell_handleradd_withcontext(lblcaption, "click", bookx_click, self );
	liqcell_propseti(  lblcaption, "textalign", 2 );
	liqcell_propseti(  lblcaption, "textaligny", 2 );
	liqcell_child_append(  self, lblcaption);
}


{
	//############################# bookx:commandbutton
	liqcell *selectbook = liqcell_quickcreatevis("selectbook", "commandbutton", 40, 180, 400, 80);
	liqcell_setfont(	selectbook, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (36), 0) );
	liqcell_setcaption(selectbook, "Select Book" );
	liqcell_propsets(  selectbook, "backcolor", "rgb(15,30,15)" );
	liqcell_handleradd_withcontext(selectbook, "click", bookselect_click, self );
	liqcell_propseti(  selectbook, "textalign", 2 );
	liqcell_propseti(  selectbook, "textaligny", 2 );
	liqcell_propsets(  selectbook, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, selectbook);
}
{
	//############################# bookx:commandbutton
	liqcell *continuereading = liqcell_quickcreatevis("continuereading", "commandbutton", 40, 280, 400, 80);
	liqcell_setfont(	continuereading, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0) );
	liqcell_setcaption(continuereading, "Continue Reading" );
	liqcell_propsets(  continuereading, "backcolor", "rgb(15,45,15)" );
	liqcell_handleradd_withcontext(continuereading, "click", bookcontinue_click, self );
	liqcell_propseti(  continuereading, "textalign", 2 );
	liqcell_propseti(  continuereading, "textaligny", 2 );
	liqcell_propsets(  continuereading, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, continuereading);

	 char *bookname = liqapp_pref_getvalue_def("book_filename","");
	 if(bookname && *bookname)
	 {
	 	liqcell_setenabled(continuereading,1);
	 	liqcell_setcaption_printf(continuereading, "Continue '%s'", liqapp_filename_walkoverpath(bookname));
	 }
	 else
	 {
	 	liqcell_setcaption(continuereading, "Continue Reading" );
		 liqcell_setenabled(continuereading,0);
	 }

}

{
	//############################# bookx:commandbutton
	liqcell *instructions = liqcell_quickcreatevis("instructions", "commandbutton", 40, 560, 400, 80);
	liqcell_setfont(	instructions, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (25), 0) );
	liqcell_setcaption(instructions, "Liqbook Instructions" );
	liqcell_propsets(  instructions, "backcolor", "rgb(15,35,35)" );
	liqcell_propsets(  instructions, "bookname", "/usr/share/liqbase/liqbook/media/liqbook_instructions.txt" );
	liqcell_handleradd_withcontext(instructions, "click", bookx_click, self );
	liqcell_propseti(  instructions, "textalign", 2 );
	liqcell_propseti(  instructions, "textaligny", 2 );
	liqcell_propsets(  instructions, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, instructions);
}

{
	//############################# bookx:commandbutton
	liqcell *bookx = liqcell_quickcreatevis("bookx", "commandbutton", 40, 660, 400, 80);
	liqcell_setfont(	bookx, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (25), 0) );
	liqcell_setcaption(bookx, "Liqbase Info" );
	liqcell_propsets(  bookx, "backcolor", "rgb(15,15,35)" );
	liqcell_propsets(  bookx, "bookname", "/usr/share/liqbase/libliqbase/media/liqbase.info.txt" );
	liqcell_handleradd_withcontext(bookx, "click", bookx_click, self );
	liqcell_propseti(  bookx, "textalign", 2 );
	liqcell_propseti(  bookx, "textaligny", 2 );
	liqcell_propsets(  bookx, "bordercolor", "rgb(255,255,255)" );
	liqcell_child_append(  self, bookx);
}


	//############################# icon:label
	liqcell *icon = liqcell_quickcreatevis("icon", "label", 6, 8, 52, 40);
	//liqcell_setfont(	icon, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (12), 0) );
	//liqcell_setcaption(icon, "icon" );
	//liqcell_propsets(  icon, "textcolor", "rgb(255,255,255)" );
	//liqcell_propsets(  icon, "backcolor", "rgb(0,0,0)" );
	liqcell_propsets(  icon, "bordercolor", "rgb(200,100,100)" );
	
	
	
	liqcell_setsketch(   icon,    liqsketch_newfromfile("/usr/share/liqbase/liqbook/media/liq.20110207_180837.lcuk.smile.me.page"));
	
	liqcell_propseti(  icon, "textalign", 2 );liqcell_propseti(  icon, "textalign", 2 );
	liqcell_child_append(  self, icon);
	
	//############################# title:label
	liqcell *title = liqcell_quickcreatevis("title", "label", 66, 8, 724, 40);
	liqcell_setfont(	title, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (20), 0) );
	liqcell_setcaption(title, "Liqbook - prototype" );
	//liqcell_propsets(  title, "textcolor", "rgb(255,255,255)" );
	//liqcell_propsets(  title, "backcolor", "rgb(0,0,0)" );
	liqcell_propseti(  title, "textalign", 0 );
	liqcell_child_append(  self, title);
	//liqcell_setvisible(title,0);
 
	//liqcell_propsets(  self, "backcolor", "rgb(0,0,0)" );
	liqcell_handleradd(self, "refresh", liqbook_refresh );

	liqcell_handleradd_withcontext(self, "resize",	  (void*)liqbook_resize ,self);
	liqcell_handleradd_withcontext(self, "layout",	  (void*)liqbook_layout ,self);
	
	//liqcell_codegen_resize(self);
	//exit(0);
	return self;
}








//#####################################################################
//#####################################################################
//##################################################################### main :)
//#####################################################################
//#####################################################################

// this is only used when liqbook is compiled as a standalone binary
// otherwise it can be constructed as a widget and exist with exactly the same lifespan

static void liqcell_easyrun_internal(liqcell *dialog)
{
	 if(0!=liqcanvas_init(800,480, 1))
	 {
		  liqapp_errorandfail(-1,"liqbook canvas Init");
		  //closeall();
		  return -1;
	 }
	 liqcell_easyrun( dialog );
	 liqcanvas_close();
}

int main (int argc, char* argv[])
{
	 if(liqapp_init(	argc,argv ,"liqbook" ,"0.0.1") != 0)
	 {
		  { return liqapp_errorandfail(-1,"liqbook liqapp_init failed"); }
	 }
	 
//int rotflip=0;
//	 if( 0 == atoi(liqapp_pref_getvalue_def("forcerotation","0")) )
//	 {
//		rotflip=1;
//		liqapp_pref_setvalue("forcerotation","1");
//		liqapp_prefs_save();
//	 }
		
	 
	 liqcell *self = liqbook_create();
	 liqcell_propseti(self,"easyrun_hidetools",1);
	 liqcell_easyrun_internal(self);
	 liqcell_release(self);
	 liqapp_close();
//	if(rotflip)
//	 {
//		liqapp_pref_setvalue("forcerotation","0");
//		liqapp_prefs_save();
//	 }
	 return 0;
}

