import QtQuick 1.0


Item{
	id: root
	width:  parent.width
	height: button.shown ? button.height + list.height : button.height


	property alias expandedWidth: background.width
	property alias backgroundColor: background.color
	property int duration: 500

	property alias model: list.model
	property Component delegate
	property alias count: list.count
	property alias text: button.text

	property alias orientation: list.orientation
	property alias interactive: list.interactive
	property alias snapMode: list.snapMode
	property alias listClip: list.clip
	property alias listSpacing: list.spacing
	property alias cacheBuffer: list.cacheBuffer
	property alias flickDeceleration: list.flickDeceleration

	Behavior on height { PropertyAnimation{easing.type: Easing.InOutCubic; duration: root.duration}}

	SystemPalette{id:palette}

	SectionButton{
		id: button
		shown: true

		Item{
			z:-1
			anchors.fill: parent
			anchors.bottomMargin: -background.height
			clip: true

			ListView{
				id: list

				height: contentHeight
				anchors.left: parent.left
				anchors.right: parent.right
				anchors.top: parent.top
				anchors.topMargin: -height
				anchors.leftMargin: 20
				anchors.rightMargin: 20
				spacing: 30
				interactive: false
				delegate: root.delegate

				Behavior on anchors.topMargin {PropertyAnimation{easing.type: Easing.InOutCubic; duration: root.duration} }


				Rectangle{
					id: background


					anchors.fill: list
					anchors.leftMargin: -10
					anchors.rightMargin: -10
					anchors.topMargin: -10
					anchors.bottomMargin: -10
					color: palette.dark
					radius: 5
					z:-2
				}

				states: [
					State {
						name: "shown"
						when: button.shown
						PropertyChanges {target: list; anchors.topMargin: button.height}
					}
				]

			}
		}

	}
}
