import QtQuick 1.0
import "following"
import "components"
import "common"

Window {
	id: root
	width: parent.width; height: parent.height
	borderTitle: "Followed Companies"

	onGetFinished: root.xml = xml
	Component.onCompleted: get(API.get_company_following(pagedList.start, pagedList.count))

	property string xml


PagedList{
	id: pagedList
	xml: root.xml
	anchors.topMargin: borderHeight
	onXmlSet: root.busy = true
	onXmlLoaded: root.busy = false
	pageQuery: "/companies"
	model: model
	delegate: delegate
	Connections{
		onStartChanged: root.get(API.get_company_following(pagedList.start, pagedList.count))
	}
}



FollowingModel{
	id: model
	xml: root.xml
}
Component{
	id: delegate
	FollowingDelegate{
		onClicked: {
			var comp = Qt.createComponent("company/Company.qml")
			var object = comp.createObject(root.parent)
			object.profileID = profileID
			object.caller = root
			root.state = "hidden"
		}
	}
}





}
