/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0
import "../common"


Item {
	id: root
	width: parent.width; height: column.height

	signal requestStarted
	signal clicked(string profileID)
	signal likeSent(string status)
	signal commentSent(string status)
	SystemPalette{id: palette}


	Column{
		id: column
		Row{
			id: row
			spacing: 10
			Image {
				id: image
				height:  80
				width: height
				source: pictureUrl
				Component.onCompleted: {
					if(!pictureUrl)
						source = "qrc:///qml/images/profile-picture.png"
				}

				MouseArea{
					anchors.fill: parent
					onClicked: {
						root.clicked(id)
					}
				}
			}

			Column{
				Text {font.pixelSize: 20; font.family: "Arial"; color: palette.text; text: firstName + " " + lastName}

			}


		}

		Row{
			id: shareRow
			LikeButton{
				id: like
				liked: isLiked === "true" ? true : false
				likable: isLikable === "true" ? true : false
				key: updateKey
				onRequestStarted: root.requestStarted()
				onLikeSent: root.likeSent(status)
			}

			CommentDialog{
				id: commentButton
				commentable: isCommentable === "true" ? true : false
				key: updateKey
				expandedWidth: root.width
				onRequestStarted: root.requestStarted()
				onCommentSent: root.commentSent(status)
			}


		}

	}




}



