/***********************************************************************
** Copyright (C) 2011 Anthony Naddeo <anthony.naddeo@gmail.com>
**
** This file is part of LinkedUp
**
** LinkedUp is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 3 of the License, or
** (at your option) any later version.
**
** LinkedUp is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this package; If not, see <http://www.gnu.org/licenses/>.
**
***********************************************************************/
import QtQuick 1.0

Column{
	id: root
	width: parent.width

	spacing: 10

	property alias title: title.text
	property XmlListModel model
	property Component delegate
	property alias interactive: list.interactive
	property alias contentHeight: list.height

	Text{id: title
		font.pixelSize: 30
		font.family: "Arial"
		color: palette.text
	}

	ListView{
		id: list
		model: root.model
		width: parent.width
		interactive: false
		orientation: ListView.Horizontal
		snapMode: ListView.SnapOneItem
		clip: true
		flickDeceleration: 1000
		delegate: root.delegate

	}

}
