import QtQuick 1.0
import "news"

Window {
	id: root
	width: parent.width
	height: parent.height

	property string searchString

	onSearchStringChanged: {
		if(searchString){
			model.source = "http://news.google.com/news?pz=1&ned=us&hl=en&output=rss&q=" + searchString
			root.busy = true
		}
		else if(User.numFollowing()){
			model.source = User.getCompanyQuery()
			root.busy = true
		}

		else
			var obj = noFollows.createObject(root)
	}

	imgSource: "qrc:///qml/images/gnews.png"

	NewsModel{
		id: model
		onStatusChanged: {
			if(status === XmlListModel.Ready)
				root.busy = false
		}
	}

	ListView{
		anchors.fill: parent
		anchors.topMargin: borderHeight
		spacing: 20
		model: model
		delegate: NewsDelegate{
			width: root.width
		}
	}

	Component{
		id: noFollows
		Text {
			text: "You are not following any companies.\n\nYou can search for companies on the home page and follow them there"
			font.pixelSize: 24
			color: palette.text
			width: parent.width
			anchors.verticalCenter: parent.verticalCenter
			wrapMode: Text.Wrap
			horizontalAlignment: Text.AlignHCenter

			Image {
				source: "qrc:///qml/images/star-off.png"
				anchors.bottom: parent.top
				anchors.margins: 20
				anchors.horizontalCenter: parent.horizontalCenter
				smooth: true
				scale:  1.2
			}
		}
	}

}
