import QtQuick 1.0
import "finance"
import "finance/NASDAQ.js" as NASDAQ

Window {
	id: root
	width: parent.width
	height: parent.height
	busy: true

	property string ticker

	//	borderTitle: "Finance"
	imgSource: "qrc:///qml/images/nasdaq.png"

	onTickerChanged: get("http://quotes.nasdaq.com/asp/SummaryQuote.asp?symbol=" + root.ticker)
	onGetFinished: {
		var quote = NASDAQ.parseQuotes(xml)
		if(quote)
			nasdaqText.text = quote
		else{
			var object = notFound.createObject(root)
		}

		graph.source = NASDAQ.parseGraph(xml)
	}


	Flickable{
		contentHeight: nasdaqText.height + graph.height + 20
		contentWidth: nasdaqText.width
		anchors.fill: parent
		anchors.topMargin: borderHeight
		flickableDirection: Flickable.VerticalFlick

		Text {
			id: nasdaqText
			width: root.width
			horizontalAlignment: Text.Center
			onLinkActivated: Qt.openUrlExternally(link)
			color: palette.text
			states: [
				State {
					when: root.width > root.height
					PropertyChanges {target: nasdaqText; font.pixelSize: 24}
					PropertyChanges {target: graph; height: height*2}
				}
			]
		}
		Image {
			id: graph
			smooth: true
			anchors.top: nasdaqText.bottom
			anchors.left: parent.left
			anchors.right: parent.right
			//				fillMode: Image.PreserveAspectCrop
		}
	}


	Component{
		id: notFound
		Text {
			text: "The ticker symbol '"+root.ticker+"' was not found in the NASDAQ databse, sorry"
			font.pixelSize: 22
			color: palette.text
			wrapMode: Text.Wrap
			anchors.horizontalCenter: parent.horizontalCenter
			anchors.verticalCenter: parent.verticalCenter
			width: parent.width
			horizontalAlignment: Text.Center
			Image {
				id: name
				source: "qrc:///qml/images/star-off.png"
				anchors.bottom: parent.top
				anchors.horizontalCenter: parent.horizontalCenter
			}
		}
	}



}
