/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

enum DeviceType {
	RX44,
	RX51
}

static const DeviceType device = DeviceType.RX51;

List<LedPattern> mce_ini_parse () {
	var list = new List<LedPattern> ();
	var f = FileStream.open ("/etc/mce/mce.ini", "r");
	string pattern_section = null;

	switch (device) {
	case DeviceType.RX44:
		pattern_section = "[LEDPatternNJoyRX44]";
		break;
	case DeviceType.RX51:
		pattern_section = "[LEDPatternLystiRX51]";
		break;
	}

	var line = f.read_line ();
	while (line != null) {
		if (line == pattern_section) {
			line = f.read_line ();
			while ((line != null) && (line[0] != '[')) {
				if (line.has_prefix ("Pattern")) {
					LedPattern pattern = null;
					switch (device) {
					case DeviceType.RX44:
						pattern = new LedPatternRX44 ();
						break;
					case DeviceType.RX51:
						pattern = new LedPatternRX51 ();
						break;
					}
					try {
						pattern.parse (line);
						list.append (pattern);
					} catch (LedPatternError e) {
						Hildon.Banner.show_information (null, null, e.message);
					}
				}
				line = f.read_line ();
			}
		}
		line = f.read_line ();
	}

	return list;
}

void mce_ini_store (List<LedPattern> list) {
	var f = FileStream.open ("/etc/mce/mce.ini", "r");
	var g = FileStream.open ("/tmp/mce.ini", "w");
	string pattern_section = null;

	switch (device) {
	case DeviceType.RX44:
		pattern_section = "[LEDPatternNJoyRX44]";
		break;
	case DeviceType.RX51:
		pattern_section = "[LEDPatternLystiRX51]";
		break;
	}

	var line = f.read_line ();
	while (line != null) {
		if (line == pattern_section) {
			g.printf ("%s\n", line);
			line = f.read_line ();
			while ((line != null) && (line[0] != '[')) {
				if (line.has_prefix ("Pattern")) {
					unowned List<LedPattern> node;
					for (node = list.first (); node != null; node = node.next) {
						if (line.has_prefix (node.data.name + "=")) {
							g.printf ("%s\n", node.data.dump ());
							break;
						}
					}
					if (node == null) {
						g.printf ("%s\n", line);
					}
				} else {
					g.printf ("%s\n", line);
				}
				line = f.read_line ();
			}
			if (line[0] == '[')
				g.printf ("%s\n", line);
		} else {
			g.printf ("%s\n", line);
		}
		line = f.read_line ();
	}
}
