/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

public static Osso.Status execute (Osso.Context osso, void* data, bool user_activated) {
	var window = data as Gtk.Window;

	var list = mce_ini_parse ();

	var dialog = new LedPatternDialog (list, osso);
	dialog.set_transient_for (window);

	int response = dialog.run ();
	dialog.destroy ();
	if (response == Gtk.ResponseType.OK) {
		mce_ini_store (list);
		var note = new Hildon.Note.confirmation (window, "WARNING! Apply changes without further inspection? Let's hope there is no bug in this program. Writing a broken /etc/mce/mce.ini can brick the device. If unsure, select No and apply the changes manually after inspection.");
		response = note.run ();
		note.destroy ();
		if (response == Gtk.ResponseType.OK) {
			Hildon.Banner.show_information (window, null, "Applying changes and restarting MCE ...");
			try {
				int exit_status;
				string error;
				var command = "sudo /usr/bin/led-pattern-helper save /tmp/mce.ini";
				Process.spawn_command_line_sync (command, null, out error, out exit_status);
				if (exit_status != 0) {
					var information = "Exit status: %d\n%s".printf (exit_status, error);
					note = new Hildon.Note.information (window, information);
					note.run ();
				}
			} catch (SpawnError e) {
				Hildon.Banner.show_information (null, null, e.message);
			}
		} else {
			note = new Hildon.Note.information (window, "The modified LED patterns are stored in /tmp/mce.ini. You have to manually copy this file to /etc/mce/mce.ini and restart MCE for the changes to take effect:\n\nmv /tmp/mce.ini /etc/mce/mce.ini\ninitctl stop mce; sleep 2; initctl start mce");
			note.run ();
		}
	} else if (response == LedPatternDialog.Response.RESTORE) {
		Hildon.Banner.show_information (window, null, "Applying changes and restarting MCE ...");
		try {
			int exit_status;
			string error;
			var command = "sudo /usr/bin/led-pattern-helper save /etc/mce/mce.ini.orig";
			Process.spawn_command_line_sync (command, null, out error, out exit_status);
			if (exit_status != 0) {
				var information = "Exit status: %d\n%s".printf (exit_status, error);
				var note = new Hildon.Note.information (window, information);
				note.run ();
			}
		} catch (SpawnError e) {
			Hildon.Banner.show_information (null, null, e.message);
		}
	}

	return Osso.Status.OK;
}

public static Osso.Status save_state (Osso.Context osso, void* data) {
	return Osso.Status.OK;
}
