/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

List<LedPatternRX51> mce_ini_parse () {
	var list = new List<LedPatternRX51> ();
	var f = FileStream.open ("/etc/mce/mce.ini", "r");

	var line = f.read_line ();
	while (line != null) {
		if (line == "[LEDPatternLystiRX51]") {
			line = f.read_line ();
			while ((line != null) && (line[0] != '[')) {
				if (line.has_prefix ("Pattern")) {
					var pattern = new LedPatternRX51 ();
					pattern.parse (line);
					list.append (pattern);
				}
				line = f.read_line ();
			}
		}
		line = f.read_line ();
	}

	return list;
}

void mce_ini_store (List<LedPatternRX51> list) {
	var f = FileStream.open ("/etc/mce/mce.ini", "r");
	var g = FileStream.open ("/tmp/mce.ini", "w");

	var line = f.read_line ();
	while (line != null) {
		if (line == "[LEDPatternLystiRX51]") {
			g.printf ("%s\n", line);
			line = f.read_line ();
			while ((line != null) && (line[0] != '[')) {
				if (line.has_prefix ("Pattern")) {
					unowned List<LedPatternRX51> node;
					for (node = list.first (); node != null; node = node.next) {
						if (line.has_prefix (node.data.name + "=")) {
							g.printf ("%s\n", node.data.dump ());
							break;
						}
					}
					if (node == null) {
						g.printf ("%s\n", line);
					}
				} else {
					g.printf ("%s\n", line);
				}
				line = f.read_line ();
			}
			if (line[0] == '[')
				g.printf ("%s\n", line);
		} else {
			g.printf ("%s\n", line);
		}
		line = f.read_line ();
	}
}
