/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

class LedPattern : Object {
	enum ScreenOn {
		DISPLAY_OFF = 0,
		DISPLAY_ON = 1,
		DISPLAY_OFF_ACT_DEAD = 2,
		DISPLAY_ON_ACT_DEAD = 3,
		DISPLAY_OFF_OR_ACT_DEAD = 4,
		DISABLED = 5
	}

	public string name;
	public int priority;
	public int screen_on;
	public int timeout;

	public double duration;

	public signal void changed ();
}

enum CommandType {
	UNKNOWN,
	RESET_MUX,
	SET_PWM,
	RAMP_WAIT,
	GO_TO_START,
	BRANCH,
	END,
	TRIGGER
}

class LedCommand : Object {
	public CommandType type;
	public double time;
	public double step_time;
	public double duration;
	public int level;
	public int steps;

	public virtual void set_pwm (int _level) {
		type = CommandType.SET_PWM;
		level = _level;
		changed ();
	}

	public virtual void ramp_wait (double _step_time, int _steps) {
		type = CommandType.RAMP_WAIT;
		step_time = _step_time;
		steps = _steps;
		if (steps < 0)
			duration = step_time * (1 - steps);
		else
			duration = step_time * (steps + 1);
		changed ();
	}

	public virtual void go_to_start () {
		type = CommandType.GO_TO_START;
		changed ();
	}

	public virtual void end (bool reset) {
		type = CommandType.END;
		steps = reset ? -255 : 0;
		changed ();
	}

	public signal void changed ();
}

