/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

class LedPatternButton : Gtk.Button {
	LedPatternRX51 pattern;
	Gtk.Label value_label;

	public LedPatternButton (LedPatternRX51 _pattern) {
		pattern = _pattern;

		var hbox = new Gtk.HBox (false, Hildon.MARGIN_DOUBLE);

		var lpv = new LedPatternView (pattern);
		lpv.set_size_request (200, -1);
		hbox.pack_start (lpv, false, false, 0);

		var label_box = new Gtk.VBox (false, 0);

		var title = new Gtk.Label (pattern.name.has_prefix ("Pattern") ?
		                           pattern.name.offset (7) : pattern.name);
		title.set_alignment (0.0f, 0.5f);
		label_box.pack_start (title, false, false, 0);

		value_label = new Gtk.Label ("%.2f s".printf (pattern.duration / 1000.0));
		value_label.set_alignment (0.0f, 0.5f);
		Hildon.helper_set_logical_color (value_label, Gtk.RcFlags.FG, Gtk.StateType.NORMAL, "SecondaryTextColor");
		Hildon.helper_set_logical_color (value_label, Gtk.RcFlags.FG, Gtk.StateType.PRELIGHT, "SecondaryTextColor");
		Hildon.helper_set_logical_font (value_label, "SmallSystemFont");
		label_box.pack_start (value_label, true, true, 0);

		hbox.pack_start (label_box, true, true, 0);

		add (hbox);

		pattern.changed.connect (on_pattern_changed);
	}

	private void on_pattern_changed () {
		value_label.set_text ("%.2f s".printf (pattern.duration / 1000.0));
	}
}
