/* This file is part of LED Pattern Editor.
 *
 * Copyright (C) 2010 Philipp Zabel
 *
 * LED Pattern Editor is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LED Pattern Editor is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LED Pattern Editor. If not, see <http://www.gnu.org/licenses/>.
 */

class LedPatternDialog : Gtk.Dialog {
	unowned List<LedPatternRX51> list;

	public LedPatternDialog (List<LedPatternRX51> _list) {
		list = _list;
		set_title ("LED Patterns");

		var content = (Gtk.VBox) get_content_area ();
		content.set_size_request (-1, 5*70);

		var pannable = new Hildon.PannableArea ();
		var vbox = new Gtk.VBox (false, 0);

		foreach (LedPatternRX51 pattern in list) {
			var button = new Gtk.Button ();
			Hildon.gtk_widget_set_theme_size (button, Hildon.SizeType.FINGER_HEIGHT);

			var hbox = new Gtk.HBox (false, Hildon.MARGIN_DOUBLE);

			var lpv = new LedPatternView (pattern);
			lpv.set_size_request (200, -1);
			button.set_data ("pattern", pattern);
			button.clicked.connect (on_pattern_clicked);
			hbox.pack_start (lpv, false, false, 0);

			var label = new Gtk.Label (pattern.name.has_prefix ("Pattern") ?
			                           pattern.name.offset (7) : pattern.name);
			label.set_alignment (0.0f, 0.5f);
			hbox.pack_start (label, true, true, 0);

			button.add (hbox);
			vbox.pack_start (button, true, true, 0);
		}

		pannable.add_with_viewport (vbox);
		content.pack_start (pannable, true, true, 0);
		content.show_all ();

		add_button ("Save", Gtk.ResponseType.OK);
	}

	void on_pattern_clicked (Gtk.Button button) {
		var pattern = (LedPatternRX51) button.get_data ("pattern");
		var dialog = new LedProgramDialog (pattern);
		dialog.set_transient_for (this);

		int response = 0;
		while (response >= 0)
			response = dialog.run ();
		dialog.destroy ();
	}
}
