#ifndef RADIOLIST_H
#define RADIOLIST_H

#include <QDialog>
#include <QList>
#include <QMap>
#include <QListWidgetItem>

namespace Ui {
    class RadioList;
}

class RadioList : public QDialog
{
    Q_OBJECT

public:
    explicit RadioList(QString user, QWidget *parent = 0);
    ~RadioList();
    QString radioName;
    QString radioUrl;

private:
    Ui::RadioList *ui;
    QList<QMap<QString, QString> > radios;
    QString username;
    void initializeRadioList();
    void initializeListView();

private slots:
    void radioSelected(QListWidgetItem *item);

};

#endif // RADIOLIST_H
