#ifndef COMMON_H
#define COMMON_H
#include <cstdio>
#include <QDateTime>
#include <QString>
#include <QTextStream>

#define HSKISTEVERSION "1.11"
#define HSKISTEYEARS "2009,2010,2011"

class Task : public QObject {
#define DONE 0
#define TODO 1
#define NOW 2
	Q_OBJECT
	Q_PROPERTY(QDateTime start READ pstart WRITE setStart NOTIFY startChanged)
	Q_PROPERTY(QDateTime stop READ pstop WRITE setStop NOTIFY stopChanged)
	Q_PROPERTY(QString author READ pauthor WRITE setAuthor NOTIFY authorChanged)
	Q_PROPERTY(QString title READ ptitle WRITE setTitle NOTIFY titleChanged)
	Q_PROPERTY(QString chanMnemo READ pchanMnemo WRITE setChanMnemo  NOTIFY chanMnemoChanged)
	Q_PROPERTY(bool record READ precord WRITE setRecord  NOTIFY recordChanged)

public:
	int jobNumber;
	QDateTime start;
	QDateTime stop;
	QString file;
	int ft;
	int fq;
	QString author;
	QString title;
	QString chanMnemo;
	int chanType;
	int status;
	bool doFinalCmd;
	bool unsaved;

	QDateTime pstart();
	QDateTime pstop();
	QString pauthor();
	QString ptitle();
	QString pchanMnemo();
	bool precord();

	void setStart(const QDateTime);
	void setStop(const QDateTime);
	void setAuthor(const QString);
	void setTitle(const QString);
	void setChanMnemo(const QString);
	void setRecord(bool);


	Task();
	Task(const Task&);
	Task operator=(const Task&);


signals:
	void startChanged();
	void stopChanged();
	void authorChanged();
	void titleChanged();
	void chanMnemoChanged();
	void recordChanged();
};

class Channel {
public:
	QString name;
	int type;
	QString address;
	QString mnemo;
};

int getNextJobNum();
void writeTasks();
void writeTasks(QString taskFile, QList<Task> tasks);
QList<Task> readTasks(QString taskFile);
void readTasks();
void readChannels();
void tasksToCrontab();
void interpret_line(QString line);
void readConfig();
void writeConfig();
Task* getTaskByJobNumber(int jobn);
Channel* getChannelByMnemoType(QString mnemo, int type);
QString typeToString(int type);
void initLog();

#define FMT_MP3 0
#define FMT_OGG 1
#define FMT_WAV 2
#define FMT_REAL 3
#define FMT_WMA 4
#define FMT_NAT -1


#define SEP ";:;"
#define DEFSEP "=:="
#define HSBEGIN "##beginhs#"
#define HSEND "##endhs#"

#ifndef COMMON
extern QTextStream errorS;
extern QTextStream outS;
extern QTextStream inS;
extern QTextStream logS;

extern QString crontab;
extern QString chanFile;
extern QString taskFile;
extern QString mplayer;
extern QString lame;
extern QString oggenc;
extern QString stdDir;
extern QString finalCmd;
#if defined Q_OS_WIN32
extern bool useSchtasks;
extern bool monthBeforeDay;
extern QString once;
#endif
#if defined Q_OS_LINUX
extern QString ppref;
#endif
extern QString suffixes[];
extern QList<Channel> channels;
extern QList<Task> tasks;
#else
QString suffixes[] = {".mp3",".ogg",".wav",".rm",".wma"};
#endif
#endif //COMMON_H
// kate: indent-mode cstyle; replace-tabs off; tab-width 4; 
