
#ifndef QtMaemo5Rotator_H
#define QtMaemo5Rotator_H

//----------
// Provides a means of WORKING automatic rotation for Maemo 5 apps. (The default Qt solution is buggy.)
//----------

#include <Qt>
#include <QtGui>
#include <QtCore>

class QtMaemo5Rotator : private QObject
{
    Q_OBJECT

public:

    enum RotationBehavior
    {
        AutomaticBehavior = 0,
        LandscapeBehavior = 1,
        PortraitBehavior = 2
    };

    enum Orientation
    {
        LandscapeOrientation = 0,
        PortraitOrientation = 1
    };

private:

    bool _isSetUp;
    RotationBehavior _currentBehavior;
    Orientation _currentOrientation;

public:

    explicit QtMaemo5Rotator(RotationBehavior behavior = LandscapeBehavior, QWidget *parent = NULL);
    ~QtMaemo5Rotator();

    const RotationBehavior currentBehavior();
    const Orientation currentOrientation();
    void setCurrentBehavior(RotationBehavior value);
    void setCurrentOrientation(Orientation value);

private slots:

    void on_orientation_changed(const QString& newOrienation);

signals:

    void orientationChanged(Orientation orientation);

};

#endif // QtMaemo5Rotator_H
