#ifndef CONTACTSTHREADWORKER_H
#define CONTACTSTHREADWORKER_H

#include <QtCore>
#include <QContact>
#include <QContactSortOrder>
#include <QContactManager>
#include <QContactDisplayLabel>
#include <QContactFetchRequest>
#include <QContactName>

class ContactsThreadWorker : public QThread
{
    Q_OBJECT

public:
    ContactsThreadWorker();
    void run();

signals:
    void updateContact(QtMobility::QContact);
    void DoneUpdatingContacts();
    void copy_m_Contacts(QList<QtMobility::QContact>);

public slots:
    void getContacts();
    void contactsReady();
    void updateContactsAgain();

private:
    //Methods
    void getContactsFromMemory();
    void updateAllContacts();
    bool isAllEnglish(QString label);
    bool doesPhoneNumberExist(QtMobility::QContact *i_Contact);

    //Members
    QList<QtMobility::QContact> m_Contacts;
    QtMobility::QContactFetchRequest *m_FetchRequest;

};

#endif // CONTACTSTHREADWORKER_H
