/*
 * This file is part of KDevelop
 * Copyright 2010 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef REVIEWBOARDJOBS_H
#define REVIEWBOARDJOBS_H

#include <QNetworkAccessManager>
#include <QUrl>
#include <QVariant>

class HttpPostCall : public QObject
{
	Q_OBJECT
	public:
		HttpPostCall(const QUrl& s, const QByteArray& post, QObject* parent);
		
		virtual void start();
		
		QVariant result() const;
		void setPost(const QByteArray& post) { m_post = post; }
		
	signals:
		void done(const QVariant& result, const QString& error);
		
	private slots:
		void finished();
		
	private:
		QNetworkReply* m_reply;
		QUrl m_requrl;
		QByteArray m_post;
		
		QNetworkAccessManager m_manager;
		QVariant m_result;
};

class XmlRpcCall : public HttpPostCall
{
	Q_OBJECT
	public:
		XmlRpcCall(const QUrl& s, const QString& methodname, const QList<QVariant>& arguments, QObject* parent);
		
	private:
		QByteArray createXmlRpcCall(const QString& name, const QVariantList& args);
};

#endif
