#ifndef HORARIS_H
#define HORARIS_H

#include <QtGui/QMainWindow>
#include <QtGui/QDialog>

class QDate;
class QStandardItemModel;
namespace Ui { class Horaris; class History; }

class Horaris : public QMainWindow
{
	Q_OBJECT
	public:
		Horaris(QWidget* parent=0);
		virtual ~Horaris();
		
		void addHistory(int dept, int arriv, const QDate& date);
		
	public slots:
		void search();
		void receivedStations(const QVariant& result, const QString& error);
		void searchDone(const QVariant& values, const QString& error);
		void restoreView();
		void timetableChanged(int);
		void viewHistory();
		
	private:
		void setBusy(bool busy);
		
		Ui::Horaris* m_ui;
		QStandardItemModel* m_model;
		QStandardItemModel* m_lastQueries;
		QToolBar* m_tools;
};

class HistoryDialog : public QDialog
{
	Q_OBJECT
	public:
		HistoryDialog(QStandardItemModel* m, QWidget* parent = 0);
		virtual ~HistoryDialog();
		
		int selectedRow() const;
	public slots:
		void acceptableDialog();
		
	private:
		Ui::History* m_ui;
};

#endif // gironi_H
