/*
 * Copyright (C) 2006-2007 Nokia Corporation. All rights reserved.
 *
 * This code is derived from software contributed to Nokia Corporation
 * by Kimitake <kimitake@gmail.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Nokia Corporation nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include "hildon-im-plugin.h"
#include "hildon-im-ui.h"

#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <libosso.h>
#include <mce/dbus-names.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>

#include "log.h"

#define HILDON_IM_SCIM_TYPE hildon_im_scim_get_type ()
#define HILDON_IM_SCIM(obj) GTK_CHECK_CAST(obj, hildon_im_scim_get_type (), HildonIMScim)
#define HILDON_IM_SCIM_CLASS(klass) \
        GTK_CHECK_CLASS_CAST(klass, hildon_im_scim_get_type, \
                             HildonIMScimClass)
#define HILDON_IS_IM_KEYBOARD_DECORATOR(obj) \
        GTK_CHECK_TYPE(obj, hildon_im_scim_get_type ())
#define HILDON_IM_SCIM_GET_PRIVATE(obj) \
        (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HILDON_IM_SCIM_TYPE,\
                                      HildonIMScimPrivate))


typedef struct
{
  GtkContainerClass parent;
}
HildonIMScimClass;

typedef struct
{
  GtkContainer parent;
}
HildonIMScim;

typedef struct
{
  HildonIMUI *ui;
  GtkWidget *window;
  GtkWidget *text_view;

  GtkWidget *vbox;
  
  GtkWidget *close_button;
  
}
HildonIMScimPrivate;

static GType hildon_im_scim_type = 0;
static GtkWidgetClass *parent_class = NULL;
static GConfClient *gconf_client = NULL;
static gboolean closing = FALSE;

GType hildon_im_scim_get_type (void);
GtkWidget *hildon_im_scim_new (HildonIMUI *kbd);

/* 
 * HildonIMPlugin interface
 */
static void hildon_im_scim_iface_init (HildonIMPluginIface *iface);

static void hildon_im_scim_enable (HildonIMPlugin *plugin, gboolean init);
static void hildon_im_scim_disable (HildonIMPlugin *plugin);
/*
static void hildon_im_scim_surrounding_received (HildonIMPlugin *plugin,
                                                       const gchar *surrounding,
                                                       gint offset);
static void hildon_im_scim_key_event(HildonIMPlugin *plugin,
                                                   GdkEventType type,
                                                   guint state,
                                                   guint keyval,
                                                   guint hardware_keycode);
*/
/*
 * GObject functions
 */
static void hildon_im_scim_finalize     (GObject *obj);
static void hildon_im_scim_get_property (GObject *object,
                                                guint prop_id,
                                                GValue *value,
                                                GParamSpec *pspec);
static void hildon_im_scim_set_property (GObject *object,
                                                guint prop_id,
                                                const GValue *value,
                                                GParamSpec *pspec);

static void hildon_im_scim_class_init (HildonIMScimClass *klass);
static void hildon_im_scim_init       (HildonIMScim *self);

/*
 * Internal functions
 */
static void populate_window (HildonIMScim *self);


/*
 * Module functions
 */

HildonIMPlugin* 
module_create (HildonIMUI *keyboard)
{
  return HILDON_IM_PLUGIN (hildon_im_scim_new (keyboard));
}

void
module_exit(void)
{
  /* empty */
}

void
module_init(GTypeModule *module)
{
	log_init();
 	logDebug("hildon_im_scim module_init\n");

  static const GTypeInfo type_info = {
    sizeof(HildonIMScimClass),
    NULL, /* base_init */
    NULL, /* base_finalize */
    (GClassInitFunc) hildon_im_scim_class_init,
    NULL, /* class_finalize */
    NULL, /* class_data */
    sizeof(HildonIMScim),
    0,    /* n_preallocs */
    (GInstanceInitFunc) hildon_im_scim_init,
  };

  static const GInterfaceInfo plugin_info = {
    (GInterfaceInitFunc) hildon_im_scim_iface_init,
    NULL, /* interface_finalize */
    NULL, /* interface_data */
  };

  hildon_im_scim_type =
          g_type_module_register_type(module,
                                      GTK_TYPE_CONTAINER, "HildonIMScim",
                                      &type_info,
                                      0);
  
  g_type_module_add_interface(module,
                              HILDON_IM_SCIM_TYPE,
                              HILDON_IM_TYPE_PLUGIN,
                              &plugin_info);

	gconf_client = gconf_client_get_default();
}

/*
 * This is used to know the plugin's information when loading the module
 */
const HildonIMPluginInfo *
hildon_im_plugin_get_info(void)
{
  static const HildonIMPluginInfo info =
  {
    "HIM scim wrapper",                 /* description */
    "hildon_im_scim",            /* name */
    "HIM scim",                               /* menu title */
    NULL,                               /* gettext domain */
    TRUE,                               /* visible in menu */
    FALSE,                              /* cached */
    HILDON_IM_TYPE_FULLSCREEN,          /* UI type */
    HILDON_IM_GROUP_LATIN,              /* group */
    HILDON_IM_DEFAULT_PLUGIN_PRIORITY,  /* priority */
    NULL,                               /* special character plugin */
    NULL,                               /* help page */
    TRUE,                               /* disable common UI buttons */
    0,                                  /* plugin height */
    HILDON_IM_TRIGGER_KEYBOARD          /* trigger */
  };

  return &info;
}

/*
 * This function returns the list of available languages supported
 * by the plugin.
 */
gchar ** 
hildon_im_plugin_get_available_languages (gboolean *free)
{
  static gchar *langs[] = {"en_GB", "en_US", NULL};
  *free = FALSE;

  return langs;
}

GType
hildon_im_scim_get_type (void)
{
  return hildon_im_scim_type;
}

/*
 * Implement the interface.
 */
static void
hildon_im_scim_iface_init (HildonIMPluginIface *iface)
{
  iface->enable = hildon_im_scim_enable;
  iface->disable = hildon_im_scim_disable;
//  iface->surrounding_received = hildon_im_scim_surrounding_received;
//  iface->key_event = hildon_im_scim_key_event;
}

static void
hildon_im_scim_class_init (HildonIMScimClass *klass)
{
  GObjectClass *object_class;
  GtkObjectClass *gtk_object_class;
  GtkWidgetClass *widget_class;
  GtkContainerClass *container_class;

  parent_class = g_type_class_peek_parent (klass);
  g_type_class_add_private (klass, sizeof (HildonIMScimPrivate));

  object_class = G_OBJECT_CLASS(klass);
  gtk_object_class = GTK_OBJECT_CLASS(klass);
  widget_class = GTK_WIDGET_CLASS(klass);
  container_class = GTK_CONTAINER_CLASS(klass);

  object_class->set_property  = hildon_im_scim_set_property;
  object_class->get_property  = hildon_im_scim_get_property;
  object_class->finalize      = hildon_im_scim_finalize;
  
  g_object_class_install_property (object_class, HILDON_IM_PROP_UI,
                                   g_param_spec_object (HILDON_IM_PROP_UI_DESCRIPTION, 
                                                        HILDON_IM_PROP_UI_DESCRIPTION,
                                                        "UI that uses plugin",
                                                        HILDON_IM_TYPE_UI,
                                                        G_PARAM_READWRITE
                                                        | G_PARAM_CONSTRUCT_ONLY));
}

static void
hildon_im_scim_init (HildonIMScim *self)
{
  HildonIMScimPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_KEYBOARD_DECORATOR (self));
  priv = HILDON_IM_SCIM_GET_PRIVATE (self);
}

static void 
hildon_im_scim_finalize(GObject *obj)
{
  if (G_OBJECT_CLASS (parent_class)->finalize)
  {
    G_OBJECT_CLASS (parent_class)->finalize (obj);
  }
}

GtkWidget *
hildon_im_scim_new (HildonIMUI *kbd)
{
  return g_object_new (HILDON_IM_SCIM_TYPE,
                       HILDON_IM_PROP_UI_DESCRIPTION, kbd, NULL);
}

static void
hildon_im_scim_get_property (GObject *object,
                                    guint prop_id,
                                    GValue *value,
                                    GParamSpec *pspec)
{
  HildonIMScimPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_KEYBOARD_DECORATOR(object));
  priv = HILDON_IM_SCIM_GET_PRIVATE(object);

  switch (prop_id)
  {
    case HILDON_IM_PROP_UI:
      g_value_set_object(value, priv->ui);
      break;

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
  }
}

static void
hildon_im_scim_set_property (GObject *object,
                                    guint prop_id,
                                    const GValue *value,
                                    GParamSpec *pspec)
{
  HildonIMScimPrivate *priv;

  g_return_if_fail (HILDON_IS_IM_KEYBOARD_DECORATOR (object));
  priv = HILDON_IM_SCIM_GET_PRIVATE(object);

  switch (prop_id)
  {
    case HILDON_IM_PROP_UI:
      priv->ui = g_value_get_object(value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID(object, prop_id, pspec);
      break;
  }
}

static void
close_fkb (GtkButton *button, gpointer user_data)
{
	logDebug("close_fkb\n");

	HildonIMScim *self;
	HildonIMScimPrivate *priv;

	self = HILDON_IM_SCIM(user_data);
	priv = HILDON_IM_SCIM_GET_PRIVATE(self);

	GtkTextBuffer *buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(priv->text_view));
	GtkTextIter start, end;
	gtk_text_buffer_get_start_iter(buffer, &start);
	gtk_text_buffer_get_end_iter(buffer, &end);
	hildon_im_ui_send_utf8(priv->ui, gtk_text_buffer_get_text(buffer,
				&start, &end, TRUE));

	closing = TRUE;
	hildon_im_ui_restore_previous_mode(priv->ui);
//	gtk_widget_hide(GTK_WIDGET(priv->window));

	gboolean slide_open = gconf_client_get_bool(gconf_client,
			"/system/osso/af/slide-open", NULL);
	logDebug("/system/osso/af/slide-open: %d\n", slide_open);

//	if (slide_open) {
		gtk_widget_hide(GTK_WIDGET(priv->window));
//	}	
}

static gboolean
signal_key_press (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	logDebug("signal_key_press  keyval=%02X\n", event->keyval);

	return FALSE;
}

static void
signal_hide(GtkWidget *widget, gpointer user_data)
{
	logDebug("signal_hide\n");

	HildonIMScim *self;
	HildonIMScimPrivate *priv;

	self = HILDON_IM_SCIM(user_data);
	priv = HILDON_IM_SCIM_GET_PRIVATE(self);

//	hildon_im_ui_restore_previous_mode(priv->ui);
}

static void populate_window (HildonIMScim *self)
{
	HildonIMScimPrivate *priv;
	GtkWidget *hbox, *parea;

	priv = HILDON_IM_SCIM_GET_PRIVATE(self);

	setenv("GTK_IM_MODULE", "scim");
	logDebug("set GTK_IM_MODULE\n");

	priv->vbox = gtk_vbox_new(TRUE, 5);

	priv->text_view = hildon_text_view_new();
	gtk_widget_set_name(priv->text_view, "him-textview");
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(priv->text_view), GTK_WRAP_WORD_CHAR);
	gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(priv->text_view), TRUE);
	g_signal_connect(G_OBJECT(priv->text_view), "key-press-event",
			G_CALLBACK(signal_key_press), NULL);
	
	parea = hildon_pannable_area_new();
	//g_object_set(G_OBJECT(parea), "mov_mode", HILDON_MOVEMENT_MODE_VERT, NULL);
	hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(parea), priv->text_view);

	gtk_box_pack_start(GTK_BOX(priv->vbox), parea, TRUE, TRUE, 0);

	hbox = gtk_hbox_new(FALSE, 0);
	
	priv->close_button = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT,
			HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_image(HILDON_BUTTON(priv->close_button),
		gtk_image_new_from_icon_name("keyboard_close", -1));
	hildon_button_set_image_alignment(HILDON_BUTTON(priv->close_button), 0.0, 0.0);
	gtk_widget_set_size_request(priv->close_button, gdk_screen_width()*0.1, 70);
	gtk_box_pack_start(GTK_BOX(hbox), priv->close_button, FALSE, FALSE, 0);
	g_signal_connect(priv->close_button, "clicked", G_CALLBACK(close_fkb), self);
	g_signal_connect(G_OBJECT(priv->window), "hide", G_CALLBACK(signal_hide), self);

	gtk_box_pack_start(GTK_BOX(priv->vbox), hbox, FALSE, FALSE, 0);
	gtk_container_add (GTK_CONTAINER(priv->window), priv->vbox);
}

static void
hildon_im_scim_enable(HildonIMPlugin *plugin, gboolean init)
{
	logDebug("hildon_im_scim_enable\n");

	gboolean window_is_new;
	HildonIMScim *self;
	HildonIMScimPrivate *priv;

	self = HILDON_IM_SCIM(plugin);
	priv = HILDON_IM_SCIM_GET_PRIVATE(self);

	closing = FALSE;

	window_is_new = (priv->window == NULL);
	logDebug("window_is_new:%d\n", window_is_new);

	if (window_is_new) {
		priv->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

		gtk_window_set_type_hint(GTK_WINDOW(priv->window), GDK_WINDOW_TYPE_HINT_DIALOG);
		gtk_window_set_decorated(GTK_WINDOW(priv->window), FALSE);
		
		populate_window(self);
	}

	gtk_window_fullscreen(GTK_WINDOW(priv->window));
	gtk_widget_show_all(priv->window);
	gdk_window_set_transient_for(GTK_WIDGET(priv->window)->window,
                               gtk_widget_get_root_window(GTK_WIDGET(priv->window)));

//	gtk_widget_grab_focus(priv->text_view);
}

static void
hildon_im_scim_disable(HildonIMPlugin *plugin)
{
	logDebug("hildon_im_scim_disable\n");

#if 0
	gboolean slide-open = gconf_client_get_bool(gconf_client,
			"/system/osso/af/slide-open", NULL);
	logDebug("/system/osso/af/slide-open: %d\n", slide-open);

	if (slide-open) {
		return;
	}
#endif

	// when slide key is opened, it seems this "disable" method is called.
	// but in this case, HIM GUI should not be closed.
	// When the user click "close" button on the HIM GUI,
	// "closing" flag is true, and then close
	if (!closing)
		return;

	HildonIMScim *self;
	HildonIMScimPrivate *priv;

	self = HILDON_IM_SCIM(plugin);
	priv = HILDON_IM_SCIM_GET_PRIVATE(self);

	if (GTK_WIDGET_VISIBLE(GTK_WIDGET(priv->window)))
			gtk_widget_hide(GTK_WIDGET(priv->window));

//	setenv("GTK_IM_MODULE", "hildon");

}

static void
hildon_im_scim_surrounding_received(HildonIMPlugin *plugin,
                                                  const gchar *surrounding,
                                                  gint offset)
{
}




/* vim:set fileencoding=utf-8 enc=utf-8 ts=4: */
