/*
 * This file is part of Maemo 5 Office UI for KOffice
 *
 * Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: Gopalakrishna Bhat A <gopalakbhat@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "AttachFiles.h"

#include "InputUI.h"
#include "IndividualFile.h"

#include <QCheckBox>
#include <QScrollArea>
#include <QGridLayout>
#include <QScrollArea>
#include <QSpacerItem>
#include <QPushButton>

AttachFiles::AttachFiles(InputUI *widget, QWidget *parent):
        QDialog(parent),
        m_ui(widget)
{
    setWindowTitle("Attach files");
    mainGridLayout=new QGridLayout(this);
    scrollArea=new QScrollArea(this);
    scrollArea->setWidgetResizable(true);

    scrollAreaWidgetContents = new QWidget();
    scrollAreaWidgetContents->setObjectName(QString::fromUtf8("scrollAreaWidgetContents"));
    scrollAreaWidgetContents->setGeometry(0,0,380,280);

    verticalLayout=new QVBoxLayout(scrollAreaWidgetContents);
    verticalLayout->setSpacing(0);

    verticalSpacer = new QSpacerItem(20, 40, QSizePolicy::Minimum, QSizePolicy::Expanding);

    verticalLayout->addItem(verticalSpacer);

    QStringList attachedFiles=m_ui->attachedFiles();
    for(int i=0;i<attachedFiles.size();i++) {
        fileList.append(new IndividualFile(attachedFiles.value(i),this));
        fileList.value(i)->setChecked(true);
        verticalLayout->addWidget(fileList.value(i));
    }

    scrollArea->setWidget(scrollAreaWidgetContents);

    mainGridLayout->addWidget(scrollArea, 0, 0, 3, 2);

    doneButton=new QPushButton(tr("Done"),this);
    addMoreFiles=new QPushButton(tr("More files"),this);
    connect(addMoreFiles,SIGNAL(clicked()),this,SLOT(addFile()));
    connect(doneButton,SIGNAL(clicked()),this,SLOT(onDoneClicked()));

    mainGridLayout->addWidget(addMoreFiles,3,0);
    mainGridLayout->addWidget(doneButton,3,1);
    scrollArea->resize(500,370);
    this->resize(500,370);
    this->setLayout(mainGridLayout);
}

AttachFiles::~AttachFiles()
{

}

void AttachFiles::addFile()
{
    fileList.append(new IndividualFile(QString(""),this));
    fileList.value(fileList.size()-1)->setChecked(false);
    verticalLayout->addWidget(fileList.value(fileList.size()-1));
}

void AttachFiles::onDoneClicked()
{
    QStringList fileNames;

    for(int i=0;i<fileList.size();i++) {
        if(fileList.value(i)->isChecked() && !fileList.value(i)->fileName().isEmpty()) {
            fileNames.append(fileList.value(i)->fileName());
        }
    }

    m_ui->setAttachedFiles(fileNames);
    this->accept();
}
