/**********************************************************************************************
    Copyright (C) 2009 Fabrice Crohas fcrohas@gmail.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CRDSBROADCAST_H
#define CRDSBROADCAST_H

#include <QObject>
#include <QtDBus>

class CRdsBroadcast : public QObject
{
    Q_OBJECT;
    public:
        CRdsBroadcast(QObject * parent);
        virtual ~CRdsBroadcast();
        static CRdsBroadcast& self(){return *m_self;}
	void setDelay(int delay);
	void setTimeout(int timeout);
	void setDisplay(int length);
	void setDefText(QString text);
	int getDelay();
	int getTimeout();
	int getDisplay();
	QString getDefText();
    public slots:
	void slotSetText( QString text, int timeout);
    private:
        static CRdsBroadcast * m_self;
        void setSystemText(const QString &text);
        void setDBusText(QString text);
	// Delayed timer
	QTimer *timer;
	// Timeout timer
	QTimer *timerTimeout;
	// List of text part
	QStringList *textPart;
	// Display size
	int display;
	// Delay refresh
        int refresh;
	// position in list of text
	int textCount;
	// end time of display
	int endTime;
	// DBus workaround
	bool withDBus;
	// Default Text to display
	QString defText;

    private slots:
	void slotUpdateText();
	void slotEndText();

};
#endif                           //CRDSBROADCAST_H
