/**********************************************************************************************
    Copyright (C) 2009 Crohas Fabrice fcrohas@gmail.com 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CMafwMeta.h"
#include "dbus-strings.h"

#include <QtGui>

CMafwMeta * CMafwMeta::m_self = 0;

CMafwMeta::CMafwMeta(QObject * parent)
: IRdsText(parent)
,format("%artist% %title%")
,song("")
,timeout(30000)
,state(true)
{
    m_self = this;

    QSettings cfg;
    format = cfg.value("display/mafw/format", format).toString();
    timeout = cfg.value("display/mafw/timeout", timeout).toInt();
    state = cfg.value("main/mafw", state).toBool();
    // connect plug
    song.append( format);
    connect = false;
}


CMafwMeta::~CMafwMeta()
{
    QSettings cfg;
    cfg.setValue("display/mafw/format", format);
    cfg.setValue("display/mafw/timeout", timeout);
    cfg.setValue("main/mafw", state);
}

void CMafwMeta::setFormat(QString value)
{
    format = value;
}

QString CMafwMeta::getFormat()
{
    return format;
}

void CMafwMeta::setTimeout(int value)
{
    timeout = value;
}

int CMafwMeta::getTimeout()
{
    return timeout;
}

void CMafwMeta::setEnable(bool value)
{
    bool bConnect;
    if (value) {
    	bConnect = QDBusConnection::sessionBus().connect( 0, MAFW_METADATA_PATH, MAFW_METADATA_IF,  "metadata_changed", this, SLOT(slotMetadataChanged(QString,uint,QDBusVariant)));
    	bConnect =  QDBusConnection::sessionBus().connect( 0, MAFW_METADATA_PATH, MAFW_METADATA_IF,  "state_changed", this, SLOT(slotPlayerState(int)));
    } else {
    	QDBusConnection::sessionBus().disconnect( 0, MAFW_METADATA_PATH, MAFW_METADATA_IF,  "metadata_changed", this, SLOT(slotMetadataChanged(QString,uint,QDBusVariant)));
    	QDBusConnection::sessionBus().disconnect( 0, MAFW_METADATA_PATH, MAFW_METADATA_IF,  "state_changed", this, SLOT(slotPlayerState(int)));
    }
    state = value;
}

bool CMafwMeta::getEnable()
{
    return state && connect;
}

bool CMafwMeta::getState()
{
    return state;
}

void CMafwMeta::slotMetadataChanged(QString meta, uint state,QDBusVariant data)
{
    song.replace("%"+meta+"%", data.variant().toString()); 
    // Bit rate is latest meta
    if (meta == "bitrate") {
	    sendText(song);
    }
}

void CMafwMeta::slotPlayerState(int state)
{
    if (state == 2) 
	    sendText("Stop");
    if (state == 1) 
	    sendText("Play");
}

void CMafwMeta::sendText(QString text)
{
    emit sigChanged(text,timeout);
    song.clear();
    song.append( format);
}

void CMafwMeta::setConnect(int value)
{
    if (value) {
	// If activate check before the internal plug state
	setEnable(state);
    } else {
        QDBusConnection::sessionBus().disconnect( 0, MAFW_METADATA_PATH, MAFW_METADATA_IF,  "metadata_changed", this, SLOT(slotMetadataChanged(QString,uint,QDBusVariant)));
        QDBusConnection::sessionBus().disconnect( 0, MAFW_METADATA_PATH, MAFW_METADATA_IF,  "state_changed", this, SLOT(slotPlayerState(int)));
    }
    connect = value;
}
