#ifndef CFMRADIO_H
#define CFMRADIO_H

#include <QObject>
#include <QtDBus>

class CFMRadio : public QObject
{
    Q_OBJECT
public:
    CFMRadio(QObject * parent);
    virtual ~CFMRadio();
    static CFMRadio& self(){return *m_self;}

    QString getState();
    bool setState(bool state);

    bool setFrequency(int freq);
    double getFrequency();
    double getStep();
    double getMax();
    double getMin();
    bool setFreqUp();
    bool setFreqDown();

private:
    static CFMRadio * m_self;
    bool sendAction(QString action, QString value);
    bool sendAction(QString action, uint value);
    QVariant getProperties(QString properties);

signals:

public slots:

};

#endif // CFMRADIO_H
