#include "CFMRadio.h"

#include <QtGui>

CFMRadio * CFMRadio::m_self = 0;


CFMRadio::CFMRadio(QObject *parent) :
    QObject(parent)
{
}

CFMRadio::~CFMRadio()
{
}

bool CFMRadio::sendAction(QString action, QString value)
{
    qDebug() << "Send action=" << action << " value=" << value;
    QDBusMessage message = QDBusMessage::createMethodCall ( "com.nokia.FMTx",
                        "/com/nokia/fmtx/default", // FM TX dbus path
                        "org.freedesktop.DBus.Properties",  // FM TX dbus interface
                        "Set" ); // Method
    QList<QVariant> list;
    list.append("com.nokia.FMTx.device");
    list.append(action);
    list.append(QVariant::fromValue(QDBusVariant(value) ) );
    message.setArguments(list);
    QDBusReply<QDBusVariant> reply = QDBusConnection::systemBus().call(message);
    return true;
}

bool CFMRadio::sendAction(QString action, uint value)
{
    qDebug() << "Send action=" << action << " value=" << value;
    QDBusMessage message = QDBusMessage::createMethodCall ( "com.nokia.FMTx",
                        "/com/nokia/fmtx/default", // FM TX dbus path
                        "org.freedesktop.DBus.Properties",  // FM TX dbus interface
                        "Set" ); // Method
    QList<QVariant> list;
    list.append("com.nokia.FMTx.device");
    list.append(action);
    list.append(QVariant::fromValue(QDBusVariant(value) ) );
    message.setArguments(list);
    QDBusReply<QDBusVariant> reply = QDBusConnection::systemBus().call(message);
    //qDebug() << "message=" << reply.error().message();
    return true;
}


QVariant CFMRadio::getProperties(QString properties)
{
    QDBusMessage message = QDBusMessage::createMethodCall ( "com.nokia.FMTx",
                        "/com/nokia/fmtx/default", // FM TX dbus path
                        "org.freedesktop.DBus.Properties",  // FM TX dbus interface
                        "Get" ); // Method
    QList<QVariant> list;
    list.append("com.nokia.FMTx.device");
    list.append(properties);
    message.setArguments(list);

    QDBusReply<QDBusVariant> reply = QDBusConnection::systemBus().call(message);
    return reply.value().variant();
}

bool CFMRadio::setFreqUp()
{
    int stepFreq = getStep();
    int curFreq = getFrequency();

    if ((curFreq + stepFreq) > getMax() )
           curFreq = getMin();

    sendAction("frequency", curFreq + stepFreq );
}

bool CFMRadio::setFreqDown()
{
    int stepFreq = getStep();
    int curFreq = getFrequency();

    if ((curFreq - stepFreq) < getMin() )
           curFreq = getMax();

    sendAction("frequency", curFreq - stepFreq );
}


bool CFMRadio::setFrequency(int freq)
{
    if (freq > getMax() )
           freq = getMin();

    if (freq < getMin() )
           freq = getMax();

    sendAction("frequency", freq );
}

bool CFMRadio::setState(bool state)
{
    sendAction("state", state==true ? "enabled" : "disabled");
}

QString CFMRadio::getState()
{
    return getProperties("state").toString();
}

double CFMRadio::getFrequency()
{
    return getProperties("frequency").toInt();
}

double CFMRadio::getStep()
{
    return getProperties("freq_step").toInt();
}

double CFMRadio::getMax()
{
    return getProperties("freq_max").toInt();
}

double CFMRadio::getMin()
{
    return getProperties("freq_min").toInt();
}
