/**********************************************************************************************
 *  Copyright (C) 2009 Fabrice Crohasi fcrohas@gmail.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 ***********************************************************************************************/

#include "CDlgSetup.h" 

#include "CMafwMeta.h" 
#include "CRTCom.h" 
#include "CSms.h"

#include "CDlgMafw.h" 
#include "CDlgRTCom.h" 
#include "CDlgRds.h" 
#include "CDlgSms.h"

CDlgSetup::CDlgSetup()
{
    setupUi(this);
    // init plug values
    cMafw->setChecked(CMafwMeta::self().getState() );
    cRTCom->setChecked(CRTCom::self().getState() );
    cSms->setChecked(CSms::self().getState() );

    // connect buttons
    connect(bMain, SIGNAL(clicked()), this, SLOT(slotMainSetup()));
    connect(bCall, SIGNAL(clicked()), this, SLOT(slotCallSetup()));
    connect(bMP3 , SIGNAL(clicked()), this, SLOT(slotMP3Setup() ));
    connect(bSms , SIGNAL(clicked()), this, SLOT(slotSmsSetup() ));

    // connect checkbox
    connect(cMafw  , SIGNAL(stateChanged(int)), this, SLOT(slotMafwActivate(int) ));
    connect(cRTCom , SIGNAL(stateChanged(int)), this, SLOT(slotRTComActivate(int)));
    connect(cSms , SIGNAL(stateChanged(int)), this, SLOT(slotSmsActivate(int)));

    // Get installed themes
    listTheme();

    QSettings cfg;
    cTheme->setCurrentIndex( cTheme->findText(cfg.value("main/theme","").toString()) );
    connect(cTheme, SIGNAL(currentIndexChanged ( int )), this, SLOT(slotThemeChanged(int)));

}

CDlgSetup::~CDlgSetup()
{
}

void CDlgSetup::slotSmsSetup()
{
   CDlgSms *dlgSms = new CDlgSms(this);
   dlgSms->exec();
   delete dlgSms;
}


void CDlgSetup::slotCallSetup()
{
   CDlgRTCom *dlgRTCom = new CDlgRTCom(this);
   dlgRTCom->exec();
   delete dlgRTCom;
}

void CDlgSetup::slotMP3Setup()
{
   CDlgMafw *dlgMafw = new CDlgMafw(this);
   dlgMafw->exec();
   delete dlgMafw;
}

void CDlgSetup::slotMainSetup()
{
   CDlgRds *dlgRds = new CDlgRds(this);
   dlgRds->exec();
   delete dlgRds;
}

void CDlgSetup::slotMafwActivate(int status)
{
   CMafwMeta::self().setEnable( (status>0)?true:false); 
}

void CDlgSetup::slotRTComActivate(int status)
{
   CRTCom::self().setEnable( (status>0)?true:false); 
}

void CDlgSetup::slotSmsActivate(int status)
{
   CSms::self().setEnable( (status>0)?true:false);
}

void CDlgSetup::listTheme()
{
    cTheme->clear();
    QDir dir( QDir::homePath());
    if (!dir.exists(".fmrdsnotify")) {
            dir.mkdir(".fmrdsnotify");
    }
    dir.setPath(QDir::homePath() + QLatin1String("/.fmrdsnotify"));
    dir.setFilter(QDir::Files);
    QStringList filters;
    filters << "*.svg";
    dir.setNameFilters(filters);
    dir.setSorting(QDir::Name);
    QFileInfoList fileList = dir.entryInfoList();
    QFileInfo fileInfo;
    foreach(fileInfo, fileList) {
       cTheme->addItem( fileInfo.baseName() );
    }
}

void CDlgSetup::slotThemeChanged(int index)
{
    QSettings cfg;
    cfg.setValue("main/theme", cTheme->currentText() );
    emit newTheme( cTheme->currentText() );
}
