#include "settings.h"
#include "ui_settings.h"

#include <QProcess>
#include <QtCore/QCoreApplication>
#include <QFileInfo>
#include <QSettings>

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings),

    m_process(new QProcess(this))

{
    ui->setupUi(this);

   //Set Text
    ui->checkBoxEventd->setText(tr("Enable FlopSwap"));
    ui->label_3->setText(tr("Required for FlopSwap boot operations."));
    ui->label_2->setText(tr("Threshold for Swap Used Warning"));
    ui->pushButtonSave->setText(tr("Save"));
    ui->pushButtonDefault->setText(tr("Default"));

   //Check for existance of /etc/event.d/relocateswap to draw checkbox correctly
    if ( QFileInfo("/etc/event.d/relocateswap").exists() ) ui->checkBoxEventd->setChecked(true);

   //QSettings for Spin Box
    QSettings settings("flopswap", "flopswap");
    if (settings.contains("PercentForDialog"))
    {
      int psb = settings.value("PercentForDialog").toInt();
      ui->PercentspinBox->setValue(psb);
    }
    else
    {
      settings.setValue("PercentForDialog", 94);
      settings.value("PercentForDialog").toInt();
    }
}

Settings::~Settings()
{
      delete ui;
}

void Settings::on_pushButtonSave_clicked()
{
    QSettings settings("flopswap", "flopswap");
    settings.setValue("PercentForDialog", ui->PercentspinBox->value());
}

void Settings::on_checkBoxEventd_clicked()
{
    if (ui->checkBoxEventd->isChecked())
    {
        m_process->start("sudo /opt/flopswap/script/setupstart.sh");
    }
    else
    {
        m_process->start("sudo /opt/flopswap/script/rmupstart.sh");
    }
}


void Settings::on_PercentspinBox_valueChanged(int psb)
{
    ui->PercentspinBox->setValue(psb);
}

void Settings::on_pushButtonDefault_clicked()
{
    QSettings settings("flopswap", "flopswap");
    settings.setValue("PercentForDialog", 94);
    int psb = settings.value("PercentForDialog").toInt();
    ui->PercentspinBox->setValue(psb);
}
