#!/bin/sh

####### Setup common UDV's ######

## Swap 0 - Backup internal swap location
swap0=$(blkid | grep swap | grep -v UUID | awk '/dev/ {print $1}' | cut -d ":" -f 1)

## Swap 1 - First Main Swap Location
swap1=$(blkid | grep swap | grep UUID | awk '/dev/ {print $1}' | cut -d ":" -f 1 | sed -n '1p')

## Swap 2 - Second Main Swap Location
swap2=$(blkid | grep swap | grep UUID | awk '/dev/ {print $1}' | cut -d ":" -f 1 | sed -n '2p')

## Nice
nice="/bin/busybox nice -19"

## Swap Command
xswapon="/bin/busybox swapon"
xswapoff="/bin/busybox swapoff"

#Temporary file location
tempfile=/tmp/flopswaplast

# Setup notification
r=run-standalone.sh
d=dbus-send
t=--type=method_call
o=org
f=freedesktop
n=Notifications

# Setup notification banner
banner(){
$r $d $t \
--dest=$o.$f.$n /$o/$f/$n $o.$f.$n.SystemNoteInfoprint string:"$1"
}

# Setup notification dialog
dialog(){
$r $d $t \
--dest=$o.$f.$n /$o/$f/$n $o.$f.$n.SystemNoteDialog string:"$1" uint32: string:
}

#Text Strings
sucess="Swap Refresh Sucessful"
safe="Safe to Remove Back Cover"
failed="Operation Failed"
bcwarn="DO NOT REMOVE BACK COVER - Please check swaps"
na="Swap Used is not available on device swap"
calc="One Swap space active ... calculating ..."
wait="Checking... Please Wait"
strip="Please check only one swap is active!"
ncard="No other swaps available"

# Get and Print Current Swap
swap=$(awk '/dev/ {print $1}' /proc/swaps)

#Get threshold from QSettings (psb)
psb=$(grep 'PercentForDialog*' /home/user/.config/flopswap/flopswap.conf | cut -d "=" -f 2)

