#ifndef FLICKRDEMO_H
#define FLICKRDEMO_H

#include <QtGui>
#include <QtNetwork>

#ifdef PUT_HERE_SOMETHING
  #include "xqlocation.h"
  #include "xqaccesspointmanager.h"
  #include "xqlistwidget.h"
#endif

#include "ui_flickrdemo.h"
#include "ui_previewdialog.h"

class FlickrDemo :  public QMainWindow, public Ui::FlickrDemoMainWindow
{
    Q_OBJECT

public:
    FlickrDemo(QWidget *parent = 0);

private:
    void createMenus();
    void viewSatelliteInfo();
    bool parsePictureList(QString xmlString);
    void downloadFlickerPictureList();
    void downloadPictureFromFlickr();
    void downloadNextThumbnail();
     
private Q_SLOTS:
    void on_downloadButton_clicked();
    void cancelDownload();

    void httpRequestFinished(int requestId, bool error);
    void readResponseHeader(const QHttpResponseHeader &responseHeader);
    void updateDataReadProgress(int bytesRead, int totalBytes);

    void valueChanged(double latitude, double longitude, double altitude, float speed);
    void numberOfSatellitesInViewChanged(int numSatellites);
    void numberOfSatellitesUsedChanged(int numSatellites);

private:
    QAction* m_downloadAct;
    
#ifdef Q_OS_SYMBIAN 
    XQLocation m_location;
    XQAccessPointManager m_accessPointManager;
#endif
    
    QProgressDialog m_progressDialog;
    QHttp m_http;
    QString m_filePath;
    QFile* m_file;
    int m_httpGetId;
    int m_httpThumbnailGetId;
    bool m_httpRequestAborted;

    int m_pages;
    int m_page;
     
    int m_satellitesInView;
    int m_satellitesUsed;
    double m_latitude;
    double m_longitude;
     
    bool m_downloadPictureList;
    
    bool m_downloadingThumbnails;
    int m_nameCounter;
    QStringList m_names;
};

class PictureDialog : public QDialog, public Ui::PreviewDialog
{
    Q_OBJECT

public:
    PictureDialog(const QString & filePath, const QString & pictureName, QWidget *parent = 0);
 };

#endif // FLICKRDEMO_H

// End of file

