#!/usr/bin/bash
# Simple script to debianize simple Qt applications
# Usage run this script in the debian directory
# Author: Antonio Aloisio <gnuton@gnuton.org>

#################################################################################
#####                              FUNCTIONS                                #####
#################################################################################

function message {
    # Define some colors first:
    red='\e[0;31m'
    RED='\e[1;31m'
    blue='\e[0;34m'
    BLUE='\e[1;34m'
    cyan='\e[0;36m'
    CYAN='\e[1;36m'
    NC='\e[0m' # No Color
    
    case $1 in
        info )    echo -e "${BLUE}$2${NC}" ;;
        error )   echo -e "${RED}$2${NC}" ;;
        warning ) echo -e "${CYAN}$2${NC}" ;;
        * ) echo "This is a bug" ;;
    esac
}

function get_project_dirname {
    #Usage: get_project_dirname
    #Returns projectName-version
    cd ..
    project_path=$(pwd)
    cd -
    cd ../..
    path=$(pwd)
    cd -
    echo $(echo $project_path | sed -e "s:$path/::g")
}

function get_project_name {
    #Usage: get_project_name project-0.2
    #Returns: project 
    echo $(echo $1 | sed -e "s/-[0-9].[0-9]//g")
}

function check_dirname {
    #Usage: check_dirname project-0.2
    #Returns: void. Exits with error if the check fails
    CHECK_STR=$(echo $1 | sed -e "s/[a-z]*-[0-9].[0-9]//g")
    if [ $CHECK_STR ]; then
        message error "$DIRNAME is not a valid project name. Please rename it to project-version (eg: $DIRNAME-0.1)";
        exit -1
    fi	
}

function set_project_file_name {
    #Usage: set_project_file_name project-0.2
    message info "Renamig root project file name to $1..." 
    cd ..
    j=0
    for i in $(ls *.pro); do
	echo "Processing $i:"
        if [ $j -eq 1 ]; then
            message error "ERROR Several project file in the application directory are not allowed." 
            exit 1
        fi
        let "j=$j+1"
	echo "Renaming $i to $1.pro"
        mv $i $1.pro
    done
    if [ $j -eq 0 ]; then
        message error "No project file found."
	exit 1
    fi
    
    cd -
    
}

function set_appname_in_debian_files {
    #Usage set_appname_in_debian_files MyQtApplication
    #This function replaces the var QT_APPNAME_QT in the file present in debian/
    message info "Setting application name in Debian files...";
    for i in $(ls);do
	if [ $i != "debianize.sh" ]; then
            sed -i "s/QT_APPNAME_QT/$1/g" $i
	fi
    done

}

function rename_icons {
    message info "Renamig standard icons..."
    cd ../data

    for DIR in $(ls -d */);do
        for NAME in $(ls $DIR); do
            case $(file $DIR$NAME) in
                *PNG* )                   
		    echo $DIR$NAME  $DIR${1%.*}.png
		    mv $DIR$NAME  $DIR${1%.*}.png 
		    ;;
                *"X pixmap image text"* )
	            echo $DIR$NAME  $DIR${1%.*}.xpm
		    mv $DIR$NAME  $DIR${1%.*}.png 
		    ;;
		    
                * ) 
		    message warning "file $NAME not changed." ;;
            esac
        done
    done
    cd -
}

function update_project_file {
  #FIXME LINES actually are appended in just one line. It's very hard to read 
  
   echo "
  ############# THESE LINES HAS BEEN ADDED BY QT DEBINANIZER ###########  
  ####### PLEASE CHECK THE CORRECTNESS OF THIS IN YOUR PROJECT FILE #### 
   
  BREAKING_COMPILATION_REMOVE_ME
    
  unix {
    #VARIABLES
    isEmpty(PREFIX) {
        PREFIX = /usr/local
  }
  BINDIR = \$\$PREFIX/bin
  DATADIR = \$\$PREFIX/share

  DEFINES += DATADIR=\\\"\$\$DATADIR\\\" PKGDATADIR=\\\"\$\$PKGDATADIR\\\"

  #MAKE INSTALL
  INSTALLS += target desktop iconxpm icon26 icon40 icon64

  target.path =\$\$BINDIR

  desktop.path = \$\$DATADIR/applications/hildon
  desktop.files += QT_APPNAME_QT.desktop

  iconxpm.path = \$\$DATADIR/pixmap
  iconxpm.files += data/maemo/QT_APPNAME_QT.xpm

  icon26.path = \$\$DATADIR/icons/hicolor/26x26/apps
  icon26.files += data/26x26/QT_APPNAME_QT.png

  icon40.path = \$\$DATADIR/icons/hicolor/40x40/apps
  icon40.files += data/40x40/QT_APPNAME_QT.png

  icon64.path = \$\$DATADIR/icons/hicolor/64x64/apps
  icon64.files += data/64x64/QT_APPNAME_QT.png

}
  " >> ../$1.pro
  message info "Updating project file..."   
}

function set_appname_in_the_project_file {
    #Usage set_appname_in_project  MyQtApplication
    #This function replaces the var QT_APPNAME_QT in the file present in debian/
    message info "Setting application name in project file...";
    if [ -e ../$1.pro ]; then
        sed -i "s/QT_APPNAME_QT/$1/g" ../$1.pro
    else
	message error "ERROR: project file ($1.pro) doesn't exists."
	exit 1
    fi
}

function edit_project_file {
    #Usage edit_project_file  MyQtApplication
    message info "Editing the project file...";
    echo "Your $1.pro file has been modified by Qt debianizer and"
    echo "more probably some changes are needed."
    echo "Press return to open the editor"
    read returnkey
    nano ../$1.pro
}

function update_date {
    #Replace QT_DATE_QT with Wed, 13 Aug 2008 14:17:22 +0300
    #for each file in debian dir.
    message info "Updating date in the debian files...";
    DATE=$(/bin/date -R)
    for i in $(ls); do
	if [ $i != "debianize.sh" ]; then
            sed -i "s/QT_DATE_QT/$DATE/g" $i
        fi
    done
}

function update_author_mail {
    #Replace QT_MAIL_QT with Antonio Aloisio <gnuton@gnuton.org>
    message info "Updating debian maintainer mail in the debian files...";
    echo "Please the debian maintainer info in the following format:"
    echo  "MyFirstName MyLastName <my@mail.org>"
    read MAIL
    #TODO MAIL CHECK
    for i in $(ls); do
	if [ $i != "debianize.sh" ]; then
            sed -i "s/QT_MAIL_QT/$MAIL/g" $i;
        fi 
    done	
}

function update_short_description {
    message info "Updating package short desctiption..."
    echo "Please enter a short of the packaged application"
    echo "<=================(up to 60 char)==========================>"
    read SHORTDESC
    #TODO MAIL CHECK
    sed -i "s/QT_SHORTDESCRIPTION_QT/$SHORTDESC/g" control;
}

function set_downloaded_from { 
    #Replace QT_DOWNLOADED_FROM_QT with a url
    echo "set_downloaded_from NOT_IMPLEMENTED_YET" 
}

function set_upstream_author {
    #Replace QT_UPSTREAM_AUTHOR_QT with "FirstName LastName <upstream@application.author>"
    echo "set_upstream_author NOT IMPLEMENTED YET"
}

function rename_desktop_file {
    message info "Renaming desktop file to $1.desktop"
    if [ -f project.desktop ]; then
	 mv project.desktop ../$1.desktop
    else
         message error "ERROR: project.destop file is missing in your debian directory"
	 exit 1
    fi
}

#################################################################################
#####                               MAIN                                    #####
#################################################################################
clear

#1. Check DirName and get the project name
DIRNAME=$(get_project_dirname)
check_dirname $DIRNAME
PROJECT_NAME=$(get_project_name $DIRNAME)
message info "Debianization of $PROJECT_NAME is starting..."

set_project_file_name $PROJECT_NAME
set_appname_in_debian_files $PROJECT_NAME
rename_icons $PROJECT_NAME
update_project_file $PROJECT_NAME
set_appname_in_the_project_file $PROJECT_NAME
edit_project_file $PROJECT_NAME
update_date
update_author_mail
update_short_description
#TODO update_long_description
#TODO set_downloaded_from
#TODO set_upstream_author
rename_desktop_file $PROJECT_NAME
