#include <QProcess>
#include <QDBusConnection>
#include <QDBusError>
#include <QDebug>
#include <QApplication>
#include <QDBusInterface>
#include "flashlightextradaemo.h"
#include "flashlightactiondialog.h"



const QString FlashlightExtraDaemo::DBUS_HAL_DEVICE_SERVER = "org.freedesktop.Hal";
const QString FlashlightExtraDaemo::DBUS_PATH_PLATFORM_CAM_SHUTTER = "/org/freedesktop/Hal/devices/platform_cam_shutter";
const QString FlashlightExtraDaemo::DBUS_PATH_PLATFORM_KB_LOCK = "/org/freedesktop/Hal/devices/platform_kb_lock";
const QString FlashlightExtraDaemo::DBUS_HAL_DEVICE_INTERFACE = "org.freedesktop.Hal.Device";


FlashlightExtraDaemo::FlashlightExtraDaemo(QObject *parent) :
        QThread(parent)
{


    this->actionDialog = new FlashlightActionDialog();
    this->connect(this->actionDialog, SIGNAL(buttonQuitPressedSignal()), this, SLOT(buttonQuitPressedPressed()));
    this->connect(this->actionDialog, SIGNAL(buttonLaunchCameraPressedSignal()), this, SLOT(buttonLaunchCameraPressed()));
    this->connect(this->actionDialog, SIGNAL(buttonLaunchFlashlightPressedSignal()), this, SLOT(buttonLaunchFlashlightPressed()));


    QDBusConnection bus = QDBusConnection::systemBus();

    if (!bus.isConnected()) {
        qDebug() << ("Nope missed school bus!");
        exit(1);
    }


    if(!bus.connect(
            FlashlightExtraDaemo::DBUS_HAL_DEVICE_SERVER,
            FlashlightExtraDaemo::DBUS_PATH_PLATFORM_CAM_SHUTTER,
            FlashlightExtraDaemo::DBUS_HAL_DEVICE_INTERFACE,
            "Condition",
            this,
            SLOT(onCamShutterChanged(QString, QString))
            )){
        qDebug() << "Error: " << QDBusConnection::sessionBus().lastError().message();
        exit(2);

    }else{
        qDebug() << "bus catched.";

    }

    this->setCameraUiEnabled(false);


}


void FlashlightExtraDaemo::run(){

}

void FlashlightExtraDaemo::buttonQuitPressedPressed(){

    QApplication::quit();
}

void FlashlightExtraDaemo::buttonLaunchCameraPressed(){
    qDebug() << "buttonLaunchCameraPressed";
    this->setFlashlightState(false);
    qDebug() << "this->setFlashlightState(false); executed";
   // this->setCameraUiEnabled(true);
    qDebug() << "this->setCameraUiEnabled(true); executed";
    this->lauchCameraApp();
    qDebug() << "this->lauchCameraApp(); executed";
    this->actionDialog->hide();
}

void FlashlightExtraDaemo::buttonLaunchFlashlightPressed(){
    qDebug() << "buttonLaunchFlashlightPressed";
    this->setCameraUiEnabled(false);
    this->setFlashlightState(true);
    this->actionDialog->hide();

}


FlashlightExtraDaemo::~FlashlightExtraDaemo(){
    qDebug() << "dest called";
    /** todo disconnect  */

    delete this->actionDialog;
    this->setCameraUiEnabled(true);

}

void FlashlightExtraDaemo::onCamShutterChanged(QString s1, QString s2){
   // qDebug() << "Cover params: " << s1 << " " << s2;




    bool isCoverOpened = this->isCoverOpened();
    bool isLockKeyPressed = this->isLockKeyPressed();

 this->setCameraUiEnabled(false);


    if(isCoverOpened && !this->actionDialog->isVisible()){
        this->actionDialog->exec();
        //this->actionDialog->raise();
        //this->actionDialog->activateWindow();
    }else{
        qDebug() << "hide";
        this->actionDialog->hide();
    }

   // qDebug() << "isCoverOpened" << isCoverOpened << this->actionDialog->isVisible() << this->actionDialog->isEnabled();

    if(isCoverOpened && isLockKeyPressed){
       // this->setCameraUiEnabled(false);
        //this->setFlashlightState(true);
    }

    if(!isCoverOpened){
        //this->setFlashlightState(false);

    }

}

void FlashlightExtraDaemo::setFlashlightState(bool state){
    qDebug() << "setFlashlightState()" << state;
    QString method;
    QProcess process;
    if(state){
        method = "enable";
    }else{
        method = "disable";
    }

    qDebug() << "trying to turn the flash " << method;
    process.execute(
            "run-standalone.sh "
            "dbus-send --type=method_call "
            "--dest=org.maemo.flashlight_applet /org/maemo/flashlight_applet "
            "org.maemo.flashlight_applet." +
            method
            );

}


void FlashlightExtraDaemo::setCameraUiEnabled(bool state){
    qDebug() << "setCameraUiEnabled()" << state;
    QString s;
    QProcess process;


    if(state){
        s = "t";
    }else{
        s = "k";
    }

    qDebug() << "run-standalodne.sh /usr/sbin/dsmetool -" + s + " /usr/bin/camera-ui" ;
    process.execute("run-standalone.sh /usr/sbin/dsmetool -" + s + " /usr/bin/camera-ui");

    if(state == false){
        this->msleep(155);
        process.execute("run-standalone.sh pkill camera-ui");
        return;
    }


}


void FlashlightExtraDaemo::lauchCameraApp(){
    QProcess process;
    process.execute(
            "run-standalone.sh "
            "dbus-send --session --print-reply "
                    "--dest=com.nokia.cameraui "
                    "/com/nokia/cameraui "
                    "com.nokia.cameraui.top_application"
                    );
}

bool FlashlightExtraDaemo::isCoverOpened(){
    QDBusInterface propertyInterface(
            FlashlightExtraDaemo::DBUS_HAL_DEVICE_SERVER,
            FlashlightExtraDaemo::DBUS_PATH_PLATFORM_CAM_SHUTTER,
            FlashlightExtraDaemo::DBUS_HAL_DEVICE_INTERFACE,
            QDBusConnection::systemBus()
            );

    bool isCoverOpened =! propertyInterface.call("GetProperty", "button.state.value").arguments().at(0).toBool();

    return isCoverOpened;
}

bool FlashlightExtraDaemo::isLockKeyPressed(){
    QDBusInterface propertyInterface(
            FlashlightExtraDaemo::DBUS_HAL_DEVICE_SERVER,
            FlashlightExtraDaemo::DBUS_PATH_PLATFORM_KB_LOCK,
            FlashlightExtraDaemo::DBUS_HAL_DEVICE_INTERFACE,
            QDBusConnection::systemBus()
            );

    bool isLockKeyPressed = propertyInterface.call("GetProperty", "button.state.value").arguments().at(0).toBool();

    return isLockKeyPressed;
}
