/*
 *  Flashlight applet (widget) for Maemo.
 *  Copyright (C) 2009, 2010 Roman Moravcik
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FLASHLIGHT_APPLET_H__
#define __FLASHLIGHT_APPLET_H__

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define TYPE_FLASHLIGHT_STATUS_PLUGIN            (flashlight_status_plugin_get_type ())

#define FLASHLIGHT_STATUS_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                                    TYPE_FLASHLIGHT_STATUS_PLUGIN, FlashlightPlugin))

#define FLASHLIGHT_STATUS_PLUGIN_CLASS(class)    (G_TYPE_CHECK_CLASS_CAST ((class), \
                                TYPE_FLASHLIGHT_STATUS_PLUGIN, FlashlightPluginClass))

#define IS_FLASHLIGHT_STATUS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                                                    TYPE_FLASHLIGHT_STATUS_PLUGIN))

#define IS_FLASHLIGHT_STATUS_PLUGIN_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), \
                                                    TYPE_FLASHLIGHT_STATUS_PLUGIN))

#define FLASHLIGHT_STATUS_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                            TYPE_FLASHLIGHT_STATUS_PLUGIN, FlashlightPluginClass))

#define STATUS_AREA_FLASHLIGHT_ICON_SIZE 22

typedef struct _FlashlightPlugin        FlashlightPlugin;
typedef struct _FlashlightPluginClass   FlashlightPluginClass;
typedef struct _FlashlightPluginPrivate FlashlightPluginPrivate;

struct _FlashlightPlugin
{
    HDStatusMenuItem parent;
};

struct _FlashlightPluginClass
{
    HDStatusMenuItemClass parent;
};

GType flashlight_status_plugin_get_type (void);

G_END_DECLS

#endif
