import QtQuick 1.1
import com.nokia.meego 1.0
import Qt 4.7
import QtMultimediaKit 1.1
import "qml"
import "script.js" as Sd

Page {id:mainPage
    width: 480;
    height:800;
    property int tim:0;
    lockInPortrait: true;
    //lockInLandscape: true;
    orientationLock: PageOrientation.LockPortrait;
    Rectangle {
        anchors.fill: parent;
        width: 480
        Image {id: bg_1;//背景
            z:10;
            source: "img/bg_day.png"
        }
        Image {id: bg_2;
            x: 0;
            y: 680;
            z:20;
            width: 563;
            source: "img/bg_bottom.png"
        }
        Rectangle{//欢迎界面
            visible: true;
            id:welcomeDiv
            z:12
            color: "#00ffffff";
            anchors.fill: parent;
            Image {id: logo;
                x: 240-logo.width/2;
                y: 100;
                source: "img/logo.png"
            }
            Image {id: bird0;
                x: 240-bird0.width/2;
                y: 300;
                source: "img/bird11.png"
            }
            Image {id: start
                x: 40;
                y: 420;
                source: "img/start.png"
                MouseArea{
                    anchors.fill: parent;
                    onClicked: {
                        Sd.enterGame();
                    }
                }
            }
            Image {id: rank;
                x: 250;
                y: 420;
                source: "img/rank.png"
                MouseArea{
                    anchors.fill: parent;
                    onClicked: {
                        Sd.rank();
                    }
                }
            }
        }
        Rectangle{//预备阶段界面
            visible: false;
            id:readyDiv;
            z:13
            color: "#00ffffff";
            anchors.fill: parent;
            Image {id: getready;
                x: 240-getready.width/2;
                y: 100;
                source: "img/getready.png"
            }
            Image {id: bird1;
                z:13;
                x: 120;
                y: 300;
                source: "img/bird11.png"
            }
            Image {id: study;
                x: 240-study.width/2;
                y: 250;
                source: "img/study.png"
            }
            MouseArea{
                anchors.fill: parent;
                onPressed: {
                    Sd.startGame();
                }
            }
        }
        Rectangle{//游戏界面
            visible: false;
            id:gameDiv;
            z:13;
            color: "#00ffffff";
            anchors.fill: parent;
            Image {id: bird;//游戏中的小鸟
                z:13;rotation:-20;
                x: 120;y:120;
                source: "img/bird11.png"
            }
            Item {id: sorceNow;//当前分数
                z:13;width: 130;
                x: 240-sorceNow.width/2;
                y: 60;
                Image {id: sorceNow1;x:44;source: "img/30.png";}
                Image {id: sorceNow2;x:44;source: "img/30.png";}
                Image {id: sorceNow3;x:44;source: "img/30.png";}
            }
            Item {id: guan1;//管道1
                visible: false;
                x:0;y:-150;
                Image {source: "img/guan_1.png"}
                Image {y: 720;source: "img/guan_2.png";}
            }
            Item {id: guan2;//管道2
                visible: false;
                x:240;y:-300;
                Image {source: "img/guan_1.png"}
                Image {y: 720;source: "img/guan_2.png";}
            }
            Item {id: guan3;//管道3
                visible: false;
                x:480;y:-450;
                Image {source: "img/guan_1.png"}
                Image {y: 720;source: "img/guan_2.png";}
            }

            MouseArea{
                anchors.fill: parent;
                onPressed: {
                    Sd.tap();
                }
            }
        }
        Rectangle{//游戏结束界面
            visible: false;
            id:overDiv;
            z:13
            color: "#00ffffff";
            anchors.fill: parent;
            Image {id: gameover;
                x: 240-gameover.width/2;
                y: 100;
                source: "img/gameover.png"
            }
            Image {id: overbg;
                x: 240-overbg.width/2;
                y: 200;
                source: "img/me_bg.png"
            }
            Image {id: media;
                x: 90;
                y: 275;
                source: "img/me_3.png"
            }
            Item {id: sorce;
                z:13;width: 79;
                x: 310; y: 260;
                Image {id: sorce1;x: 0;source: "img/20.png";}
                Image {id: sorce2;x:27;source: "img/20.png";}
                Image {id: sorce3;x:54;source: "img/20.png";}
            }
            Item {id: sorcebest;
                z:13;width: 79;
                x: 310; y: 330;
                Image {id: sorcebest1;x: 0;source: "img/20.png";}
                Image {id: sorcebest2;x:27;source: "img/20.png";}
                Image {id: sorcebest3;x:54;source: "img/20.png";}
            }
            Image {id: sorcenew;
                visible: false;
                x: 250;y: 330;
                source: "img/new.png"
            }
            Image {id: start2;
                x: 40;y: 420;
                source: "img/start.png"
                MouseArea{
                    anchors.fill: parent;
                    onClicked: {
                        Sd.restartGame();
                    }
                }
            }
            Image {id: rank2;
                x: 250;
                y: 420;
                source: "img/rank.png"
                MouseArea{
                    anchors.fill: parent;
                    onClicked: {
                        Sd.rank();
                    }
                }
            }
        }

    }
    //播放
    Audio {id: playMusic1;source: "sound/fb_start.wav"}
    Audio {id: playMusic2;source: "sound/fb_tap.wav"}
    Audio {id: playMusic3;source: "sound/fb_sorce.wav"}
    Audio {id: playMusic4;source: "sound/fb_die.wav"}
    //“关于”弹窗
    Dialog{
        id:myDia
        anchors.centerIn: parent
        //color:"white"
        z: 22;
    }

    //定时器
    Timer{
        id:mTimer
        interval: 10;
        running: true;
        repeat: true
        onTriggered: {
            Sd.sicle();
        }
    }
}
