#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QFileSystemWatcher>
#include <QMainWindow>
#include <QModelIndex>
#include <QListWidgetItem>
#include <QProcess>
//#include "loadimage.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0, QString openfolder = "");
    ~MainWindow();
    Ui::MainWindow *ui;
    QProcess *proc;
    QStringList procesos;

    int GetFolderSize ( const QString &path );
    QString GetFileSize ( int size );

public slots:
    void checkDevice();
    void execDevice();
    void checkFinished(int);
    void CargarBrowser(QString directorio);
    void agregarArchivo(QString archivo);
    void dirChanged(const QString directorio);
    void OpenFile(QString file);
    void orientationChanged();
    void renameSel();
    void removeSel();
    void editSel();
    void permissionSel();
    void compressSel();
    void addToClipboard();
    void checkClipboard();
    void shareBT();
    void paintIMG();
    void checkOrientation();
    void addSymlink();
    void changeIcon();

private:
    //Thread *pepe;

private slots:
    void on_pushButton_customContextMenuRequested(QPoint pos);
    void on_h_full_clicked();
    void on_v_full_clicked();
    void on_search_textChanged(QString );
    void on_qsearch_clicked();
    void on_lineEdit_editingFinished();
    void on_barButton_clicked();
    void on_lineEdit_textChanged(QString );
    void on_listWidget_itemDoubleClicked(QListWidgetItem* item);
    void on_v_settings_clicked();
    void on_h_settings_clicked();
    void on_listWidget_customContextMenuRequested(QPoint pos);
    void on_h_bookmarks_clicked();
    void on_v_bookmarks_clicked();
    void on_h_clipboard_clicked();
    void on_v_clipboard_clicked();
    void on_h_tools_clicked();
    void on_v_tools_clicked();
    void on_lineEdit_returnPressed();
    void on_pushButton_clicked();
    void on_pushButton_2_clicked();
    void on_listWidget_itemClicked(QListWidgetItem* item);
    void on_actionAbout_triggered();
    void on_actionHelp_triggered();

protected:
    virtual void keyPressEvent(QKeyEvent* k);
    virtual void keyReleaseEvent(QKeyEvent* k);

};

#endif // MAINWINDOW_H
