#include "compressdlg.h"
#include "ui_compressdlg.h"
#include "qsettings.h"
#include "qmaemo5rotator.h"
#include "QFileInfo"
#include "compress.h"
#include "home.h"
#include "error.h"
#include "sys/vfs.h"


CompressDlg::CompressDlg(QWidget *parent, QString path, QStringList lista) :
    QDialog(parent),
    ui(new Ui::CompressDlg)
{
    ui->setupUi(this);
    directory = path;
    lista1 = lista;

    QSettings settings("cepiperez","filemanager");
    QString iconSet = settings.value("IconStyle", "Humanity").toString();

    ui->button->setIcon( QPixmap("/opt/filebox/icons/" + iconSet + "/homefolder.png") );
    ui->button->setText( QFileInfo(directory).fileName() );
    if ( directory == "/") ui->button->setText( "/" );
    ui->button->setValueText( directory );
    if ( directory == "/") ui->button->setValueText( "" );

    ui->comboBox->clear();
    QStringList entries2;
    //entries2 << ".tar" << ".tar.gz" << ".tar.bz2" << ".zip";
    entries2.append(".tar");
    entries2.append(".tar.gz");
    entries2.append(".tar.bz2");
    if ( QFileInfo("/usr/bin/zip").exists() ) entries2.append(".zip");
    ui->comboBox->addItems( entries2 );

    QString method = settings.value("CompressMethod", ".tar").toString();
    if ( method == ".tar.gz" ) ui->comboBox->setCurrentIndex(1);
    else if ( method == ".tar.bz2" ) ui->comboBox->setCurrentIndex(2);
    else if ( method == ".zip" && QFileInfo("/usr/bin/zip").exists() ) ui->comboBox->setCurrentIndex(3);
    else ui->comboBox->setCurrentIndex(0);

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

}

CompressDlg::~CompressDlg()
{
    delete ui;
}

void CompressDlg::on_comboBox_activated(QString )
{
    QSettings settings("cepiperez","filemanager");
    settings.setValue("CompressMethod", ui->comboBox->currentText());
    settings.sync();
}

void CompressDlg::on_pushButton_clicked()
{
    this->close();
}


void CompressDlg::on_pushButton_2_clicked()
{
    int errores=0;
    if ( lista1.count() > 0 )
    {
        QSettings settings("cepiperez","filemanager");
        QString dir = settings.value("CompressFolder","/home/user/MyDocs").toString();

        settings.setValue("CompressMethod", ui->comboBox->currentText());

        struct statfs stat;
        unsigned long freeSize = 0;
        int TargetSize = 0;
        QByteArray ba = dir.toLatin1();
        const char *str1 = ba.data();
        statfs ( str1, &stat );
        freeSize = stat.f_bsize*stat.f_bfree;
        for (int fi=0; fi < lista1.count(); ++fi)
        {
            if ( QFileInfo(lista1[fi]).isFile() ) TargetSize += QFileInfo(lista1[fi]).size();
            else TargetSize += GetFolderSize( lista1[fi] );
        }

        if ( QFileInfo( dir + "/" + ui->lineEdit->text() + ui->comboBox->currentText() ).exists() )
        {
            Error* ed = new Error( this, tr("The file already exists. Try another name.") );
            ed->exec();
            errores=1;
        }


        if ( freeSize < TargetSize )
        {
            Error* ed = new Error( this, tr("Not enough space to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;

        QString tf = dir + "/checking";
        QFile destFile(tf);
        if (!destFile.open(QIODevice::WriteOnly))
        {
            Error* ed = new Error( this, tr("You don't have permissions to proceed.") );
            ed->exec();
            errores=1;
        }
        if ( errores == 1 ) return;
        QFile::remove(tf);

        Compress* cf1 = new Compress(this,lista1,ui->lineEdit->text()+ui->comboBox->currentText(),directory);
        cf1->exec();
        this->close();

    }

}

void CompressDlg::on_lineEdit_textChanged(QString )
{
    if ( ui->lineEdit->text() == "" ) ui->pushButton_2->setEnabled(false);
    else ui->pushButton_2->setEnabled(true);
}

int  CompressDlg::GetFolderSize (const QString &path )
{
  //recursive
  QDir dir ( path );
  QStringList::Iterator it;
  int size = 0;
  QStringList files = dir.entryList ( QDir::AllEntries | QDir::NoDotAndDotDot );
  it = files.begin();
  while ( it != files.end() ) {
    size += QFileInfo ( path, *it ).size();
    ++it;
  }
  QStringList dirs = dir.entryList ( QDir::Dirs );
  it = dirs.begin();
  while ( it != dirs.end() ) {
    if ( *it != "." && *it != ".." )
      size += GetFolderSize ( path + "/" + *it );
    ++it;
  }

  return size;
}

void CompressDlg::on_button_clicked()
{
    QSettings settings("cepiperez","filemanager");
    Home* hw = new Home(this, "CompressFolder", settings.value("CompressFolder","/home/user/MyDocs").toString());
    hw->exec();
    QString dr = settings.value("CompressFolder","/home/user/MyDocs").toString();
    ui->button->setText( QFileInfo(dr).fileName() );
    if ( dr == "/") ui->button->setText( "/" );
    ui->button->setValueText( dr );
    if ( dr == "/") ui->button->setValueText( "" );
}
